package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;

public abstract class BaseVectorValueField extends BaseEditableField
{
//	protected IValidator[] _xmlnode_0_unb_Validators;
	
	public abstract List getValuesFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder);
	
	public String getFieldName()
	{
		return _xmlnode_req_Bind.getID();
	}
	
	@Override
	protected boolean isMandatory(HttpServletRequest request)
	{
	    // TODO: mandatory est un attribut boolen de l'lment ?
	    return false;
	}

	@Override
	public boolean isEditable(HttpServletRequest iRequest)
	{
		return _xmlnode_req_Bind.isGetSet() && super.isEditable(iRequest);
	}
	public void submit(HttpServletRequest iRequest, FormSubmitContext iSubmitContext) throws Exception
	{
		if(!isEditable(iRequest))
			return;
		
		// --- transform
		List values = getValuesFromRequest(iRequest, iSubmitContext.getValidationErrors());
		if(iSubmitContext.getValidationErrors().hasItemErrors(getFieldName()))
			// --- conversion errors: do not set
			return;
		
		// --- set
        _xmlnode_req_Bind.setValue(iRequest, ReflectionHelper.vect2obj(values, _xmlnode_req_Bind.getType()));
		
		// --- validate
		/*
		if(_xmlnode_0_unb_Validators != null)
		{
			for(int i=0; i<_xmlnode_0_unb_Validators.length; i++)
			{
				ValidationErrors errors = _xmlnode_0_unb_Validators[i].checkValidity(values);
				if(errors != null && errors.hasErrors())
					iValidationLogger.addErrors(this, errors);
			}
		}
		*/
	}
}
