package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;


public class CheckBox extends BaseSingleValueField
{
	private boolean _xmlattr_opt_TrueIsChecked = true;
	private IBinding _xmlnode_opt_OnChange;

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_Bind != null && !_xmlnode_req_Bind.hasErrors())
		{
			Class type = Boolean.class;
			
			// --- check binding type
	    	if(!ReflectionHelper.isBoolean(_xmlnode_req_Bind.getType()))
				iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Binding has invalid type.");
			
			// --- check validator types
			if(_xmlnode_0_unb_Validators != null)
			{
				for(int i=0; i<_xmlnode_0_unb_Validators.length; i++)
				{
					if(!_xmlnode_0_unb_Validators[i].isTypeValid(type))
						iErrors.logMessage(this, "Validators", IValidityLogger.ERROR, "Validator "+i+" has invalid type.");
				}
			}
		}
	}

	public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder)
	{
		// --- si la requete est value
	    boolean checked = iRequest.getParameter(getFieldName()) != null;
	    if(_xmlattr_opt_TrueIsChecked)
	    	return new Boolean(checked);
    	return new Boolean(!checked);
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		if(_xmlnode_opt_OnChange == null)
			return;
		
		FormSubmitContext submitCtx = getForm().getSubmitContext(iRequest);
		if(submitCtx != null && submitCtx.getAction().equals("change:"+getFieldName()))
		{
			// --- the submit action was a dynamic change of this field: callback handler
			_xmlnode_opt_OnChange.invoke(iRequest);
		}
	}
	protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		boolean showEditable = iContext.isEditMode() && isEditable(iRequest);
		
		// --- rcupration de la valeur
		Boolean checked = null;
		if(showEditable && iContext.getSubmitContext() != null)
		{
			// --- after a submit: retrieve value from the request
			checked = new Boolean(iRequest.getParameter(getFieldName()) != null);
		}
		else
		{
			// --- first display: retireve value from the bean
			boolean val = ((Boolean)_xmlnode_req_Bind.invoke(iRequest)).booleanValue();
			checked = new Boolean(_xmlattr_opt_TrueIsChecked ? val : !val);
		}
		if(checked == null)
			// --- intialisation  vide
			// TODO: valeur par dfaut ?
			checked = Boolean.TRUE;

		// --- include required JavaScript
		if(_xmlnode_opt_OnChange != null)
			HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");

		iWriter.print("<input type='checkbox' class='checkbox'");
		iWriter.print(" id='");
		iWriter.print(getFieldId());
		iWriter.print("'");
		iWriter.print(" name='");
		iWriter.print(getFieldName());
		iWriter.print("'");
		if(checked.booleanValue())
			iWriter.print(" checked='checked'");
		if(!showEditable)
			iWriter.print(" disabled='disabled'");
		
		if(showEditable && _xmlnode_opt_OnChange != null)
		{
			// --- add javascript to submit changes immediately
			iWriter.print(" onclick=\"Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"')\"");
		}
		
		iWriter.print("/>");
	}
}
