package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.enums.DateType;
import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.html.form.BaseForm;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;


public class DateField extends BaseSingleValueField
{
	protected Application _xmlroot;
	protected IPage _xmlancestor_Page;
	protected BaseForm _xmlancestor_Form;
	
	private DateType _xmlattr_opt_Type = DateType.DateOnly;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- register this component as a request handler
	    if(_xmlroot.registerRequestHandler(getPathID(), this) != null)
        	iErrors.logMessage(this, "ID", IValidityLogger.INFO, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
        
        // --- check binding type
		if(_xmlnode_req_Bind != null && !_xmlnode_req_Bind.hasErrors())
		{
			Class type = _xmlnode_req_Bind.getType();
			
			// --- check binding type
	    	if(!ReflectionHelper.isDate(type))
				iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Binding has invalid type.");
			
			// --- check validator types
			if(_xmlnode_0_unb_Validators != null)
			{
				for(int i=0; i<_xmlnode_0_unb_Validators.length; i++)
				{
					if(!_xmlnode_0_unb_Validators[i].isTypeValid(type))
						iErrors.logMessage(this, "Validators", IValidityLogger.ERROR, "Validator "+i+" has invalid type.");
				}
			}
		}
	}

	public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder)
	{
		Date date = null;
		
		// --- 1: parse date
		if(_xmlattr_opt_Type == DateType.DateAndTime || _xmlattr_opt_Type == DateType.DateOnly)
		{
			String val = iRequest.getParameter(getFieldName());
			if(val == null)
				return null;
			val = val.trim();
			if(val.length() == 0)
				return null;
			
			// --- a date was entered: parse
			BricksSession session = BricksSession.getSession(iRequest);
			DateFormat format = DateType.getInputFormat(session.getLocaleConfig(), DateType.DateOnly);
			try
	        {
				date = format.parse(val);
	        }
	        catch(ParseException e)
	        {
	        	iValidationHolder.addItemError(getFieldName(), new LocalizedMessage("validation.date.wrong_format", "bricks", new Object[]{format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : format.toString()}));
	        	return null;
	        }
		}
		
		// --- 2: parse time
		if(_xmlattr_opt_Type == DateType.DateAndTime || _xmlattr_opt_Type == DateType.TimeOnly)
		{
			int hours = Integer.parseInt(iRequest.getParameter(getFieldName()+"_h"));
			int minutes = Integer.parseInt(iRequest.getParameter(getFieldName()+"_m"));
			int seconds = Integer.parseInt(iRequest.getParameter(getFieldName()+"_s"));
			
			if(date == null)
				date = new Date();
			
			date.setHours(hours);
			date.setMinutes(minutes);
			date.setSeconds(seconds);
		}
		
        return ReflectionHelper.date2Obj(date, _xmlnode_req_Bind.getType());
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
	}
	protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		boolean editable = iContext.isEditable() && isEditable(iRequest);
		BricksSession session = BricksSession.getSession(iRequest);
		
		// --- rcupration de la valeur
		Date dateVal = null;
		String date = null;
		int hours = 0;
		int minutes = 0;
		int seconds = 0;
//		String val = null;
		if(editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().getValidationErrors() != null)
		{
			// --- after a submit: retrieve value from the request
			if(_xmlattr_opt_Type == DateType.DateAndTime || _xmlattr_opt_Type == DateType.DateOnly)
			{
				date = iRequest.getParameter(getFieldName());
			}
			if(_xmlattr_opt_Type == DateType.DateAndTime || _xmlattr_opt_Type == DateType.TimeOnly)
			{
				hours = Integer.parseInt(iRequest.getParameter(getFieldName()+"_h"));
				minutes = Integer.parseInt(iRequest.getParameter(getFieldName()+"_m"));
				seconds = Integer.parseInt(iRequest.getParameter(getFieldName()+"_s"));
			}
		}
		else
		{
			// --- first display: retireve value from the bean
			dateVal = ReflectionHelper.obj2Date(_xmlnode_req_Bind.invoke(iRequest));
			if(dateVal != null)
			{
				DateFormat format = DateType.getInputFormat(session.getLocaleConfig(), DateType.DateOnly);
				date = format.format(dateVal);
				hours = dateVal.getHours();
				minutes = dateVal.getMinutes();
				seconds = dateVal.getSeconds();
			}
		}
		if(date == null)
			// --- intialisation  vide
			date = "";
		
		if(editable)
		{
			if(iContext.isEditMode())
				HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
			
			// --- render field(s)
			if(_xmlattr_opt_Type == DateType.DateAndTime || _xmlattr_opt_Type == DateType.DateOnly)
			{
				// --- render date field
				iWriter.print("<input type='text'");
				iWriter.print(" id='");
				iWriter.print(getFieldId());
				iWriter.print("'");
				iWriter.print(" name='");
				iWriter.print(getFieldName());
				iWriter.print("'");
				iWriter.print(" size='10'");
				if(!iContext.isEditMode())
					iWriter.print(" disabled='disabled'");
				iWriter.print(" value=\"");
				iWriter.print(HtmlUtils.encode2HTML(date));
				iWriter.print("\"");
				iWriter.print(">");
				
				// --- render the calendar link
				if(iContext.isEditMode())
				{
					String calendarText = BricksMessages.getMessage(iResponse.getLocale(), "datefield.show_calendar");
					UrlBuilder calendarUrl = _xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
					iWriter.print("<a class='CalendarButton'");
					/*
					iWriter.print(" href='");
					iWriter.print(calendarUrl.toUrl(session.getLocaleConfig().getCharSet(), true));
					iWriter.print("'");
					iWriter.print(" target='_blank'");
					*/
					
					iWriter.print(" href='javascript:void(0)'");
					iWriter.print(" onclick=\"");
					iWriter.print("DateField_showCalendar(event, '"+_xmlancestor_Form.getID()+"', '"+getFieldName()+"', '"+calendarUrl.toUrl(session.getLocaleConfig().getCharSet(), true)+"'); return false;");
					iWriter.print("\"");
					iWriter.print(" title=\"");
					iWriter.print(HtmlUtils.encode2HTML(calendarText));
					iWriter.print("\"");
					iWriter.print(">");
					iWriter.print(HtmlUtils.encode2HTML(calendarText));
					iWriter.print("</a>");
				}
			}
			if(_xmlattr_opt_Type == DateType.DateAndTime || _xmlattr_opt_Type == DateType.TimeOnly)
			{
				// --- render time fields
				
				// --- hour
				iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "datefield.hours")));
				iWriter.print("<select name='");
				iWriter.print(getFieldName());
				iWriter.print("_h'");
				if(!iContext.isEditMode())
					iWriter.print(" disabled='disabled'");
				iWriter.println(">");
				for(int i=0; i<24; i++)
				{
					iWriter.print("<option value='");
					iWriter.print(String.valueOf(i));
					iWriter.print("'");
					if(i==hours)
						iWriter.print(" selected='selected'");
					iWriter.print(">");
					iWriter.print(String.valueOf(i));
					iWriter.println("</option>");
				}
				iWriter.println("</select>");
				
				// --- minutes
				iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "datefield.minutes")));
				iWriter.print("<select name='");
				iWriter.print(getFieldName());
				iWriter.print("_m'");
				if(!iContext.isEditMode())
					iWriter.print(" disabled='disabled'");
				iWriter.println(">");
				for(int i=0; i<60; i++)
				{
					iWriter.print("<option value='");
					iWriter.print(String.valueOf(i));
					iWriter.print("'");
					if(i==minutes)
						iWriter.print(" selected='selected'");
					iWriter.print(">");
					iWriter.print(String.valueOf(i));
					iWriter.println("</option>");
				}
				iWriter.println("</select>");
				
				// --- seconds
				iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "datefield.seconds")));
				iWriter.print("<select name='");
				iWriter.print(getFieldName());
				iWriter.print("_s'");
				if(!iContext.isEditMode())
					iWriter.print(" disabled='disabled'");
				iWriter.println(">");
				for(int i=0; i<60; i++)
				{
					iWriter.print("<option value='");
					iWriter.print(String.valueOf(i));
					iWriter.print("'");
					if(i==seconds)
						iWriter.print(" selected='selected'");
					iWriter.print(">");
					iWriter.print(String.valueOf(i));
					iWriter.println("</option>");
				}
				iWriter.println("</select>");
			}
		}
		else
		{
			// --- display value
			if(dateVal != null)
			{
				DateFormat format = DateType.getInputFormat(session.getLocaleConfig(), _xmlattr_opt_Type);
				iWriter.print(HtmlUtils.encode2HTML(format.format(dateVal)));
			}
		}
	}
	// ================================================================================================
	// === render calendar methods
	// ================================================================================================
	private static HashMap<String, String> key2Name = new HashMap<String, String>();
	
	private static String getMonthAndYearName(Locale locale, Calendar cal)
	{
		return getMonthName(locale, cal.get(Calendar.DAY_OF_MONTH))+" "+cal.get(Calendar.YEAR);
	}
	
	private static String getMonthName(Locale locale, int month)
	{
		String key = "m."+locale.getLanguage()+"."+month;
		String name = key2Name.get(key);
		if(name == null)
		{
			synchronized(key2Name)
            {
				// --- fullname
				SimpleDateFormat sdf = new SimpleDateFormat("MMMMM", locale);
//				Date d = new Date(0, month, 1);
				Calendar cal = Calendar.getInstance().getInstance(locale);
				cal.set(Calendar.MONTH, month);
				name = sdf.format(cal.getTime());
				key2Name.put(key, name);
            }
		}
		return name;
	}
	private static String getDayName(Locale locale, int day)
	{
		String key = "d."+locale.getLanguage()+"."+day;
		String name = key2Name.get(key);
		if(name == null)
		{
			synchronized(key2Name)
            {
				// --- fullname
//				SimpleDateFormat sdf = new SimpleDateFormat("EEEEE", locale);
				// --- 3 characters
				SimpleDateFormat sdf = new SimpleDateFormat("E", locale);
//				Date d = new Date(0, 0, day);
				Calendar cal = Calendar.getInstance().getInstance(locale);
				cal.set(Calendar.DAY_OF_WEEK, day);
				name = sdf.format(cal.getTime());
				key2Name.put(key, name);
            }
		}
		return name;
	}
	public static void main(String[] args)
	{
		Locale[] locales = {Locale.FRENCH, Locale.US, Locale.UK};
		System.out.println(" saturday: "+Calendar.SATURDAY);
		System.out.println(" sunday: "+Calendar.SUNDAY);
		System.out.println(" monday: "+Calendar.MONDAY);
		for(int i=0; i<locales.length; i++)
		{
			Calendar cal = Calendar.getInstance(locales[i]);
			System.out.println("Locale "+locales[i]);
			
			System.out.println(" first day in week: "+cal.getFirstDayOfWeek()+" ("+getDayName(locales[i], cal.getFirstDayOfWeek())+")");
			
			for(int j=0; j<12; j++)
				System.out.println(" month "+j+": "+getMonthName(locales[i], j));
			
			for(int j=0; j<7; j++)
				System.out.println(" day "+j+": "+getDayName(locales[i], j));
		}
	}
	public void renderCalendar(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		// --- 1: retrieve selected date
		BricksSession session = BricksSession.getSession(iRequest);
		DateFormat inputFormat = DateType.getInputFormat(session.getLocaleConfig(), DateType.DateOnly);
		String selectedStr = iRequest.getParameter("selected");
		Date selected = null;
		if(selectedStr != null)
		{
			selectedStr = selectedStr.trim();
			// --- a date was entered: parse
			try
	        {
				selected = inputFormat.parse(selectedStr);
	        }
	        catch(ParseException e)
	        {
	        	// --- ignore
	        }
		}
		
		// --- retrieve month to display
//		Date displayedMonth = new Date();
		int month = 0;
		int year = 0;
		String monthStr = iRequest.getParameter("month");
		if(monthStr != null)
		{
			// --- displayed mont specified: get
			int idx = monthStr.indexOf('-');
			month = Integer.parseInt(monthStr.substring(0, idx))-1;
			year = Integer.parseInt(monthStr.substring(idx+1));
		}
		else if(selected != null)
		{
			// --- display month of selected date
			month = selected.getMonth();
			year = selected.getYear()+1900;
		}
		else
		{
			// --- get current month
			Calendar displayedMonth = Calendar.getInstance(iResponse.getLocale());
			month = displayedMonth.get(Calendar.MONTH);
			year = displayedMonth.get(Calendar.YEAR);
		}
		
		// --- render
		Calendar cal = Calendar.getInstance(iResponse.getLocale());
		cal.set(year, month, 1, 0, 0, 0);
		
		UrlBuilder url;
		
		DateFormat monthUrlFormat = new SimpleDateFormat("M-yyyy");
		DateFormat monthDisplayFormat = new SimpleDateFormat("MMMMM yyyy", iResponse.getLocale());
		
		// --- 2: render calendar page
		// ---------------------------
		iResponse.setContentType("text/html;charset="+session.getLocaleConfig().getCharSet());
		PrintWriter iWriter = iResponse.getWriter();
		
		// --- 3: render
		//TODO: other headers
		
		iWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
		iWriter.print("<html lang=\"");
		iWriter.print(session.getLocaleConfig().getLocale().getLanguage());
		iWriter.println("\">");
		iWriter.println("<head>");

		// --- write page title
		iWriter.print("<title>");
		iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "calendar.title", new Object[]{monthDisplayFormat.format(cal.getTime())})));
		iWriter.println("</title>");

		// --- meta tags
		// html content type
		iWriter.println("<meta http-equiv='content-type' content='text/html;charset="+session.getLocaleConfig().getCharSet()+"'>");
		// no cache (for all browsers)
		// et pourquoi pas ???
		iWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
		iWriter.println("<meta http-equiv='pragma' content='no-cache'>");
		iWriter.println("<meta http-equiv='expires' content='0'>");
		// --- les liens relatifs le sont par rapport  l'application
		iWriter.print("<base href='");
		iWriter.print(iRequest.getScheme());
		iWriter.print("://");
		iWriter.print(iRequest.getServerName());
		iWriter.print(":");
		iWriter.print(String.valueOf(iRequest.getServerPort()));
		iWriter.print(iRequest.getContextPath());
		iWriter.print("/");
		iWriter.println("'>");

		// --- import stylesheets
		IFrame frame = _xmlroot.getFrame(_xmlancestor_Page.getFrameName());
		CssStyleSheet[] styleSheets = frame.getStyleSheets();
		if(styleSheets != null)
		{
			for(int i=0; i<styleSheets.length; i++)
			{
				iWriter.print("<link rel='stylesheet' type='text/css' href='");
				iWriter.print(styleSheets[i].getFile());
				iWriter.println("'>");
			}
		}
		
		// --- include javascript
		HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");

		iWriter.println("</head>");
		
		iWriter.println("<body class=Calendar>");
		
		iWriter.println("<table class=Calendar>");
		
		// --- toolbar row
		// ---------------
		iWriter.print("<tr class=Toolbar>");
		iWriter.print("<th colspan=8>");
		
		iWriter.print("<div>");
		
		// --- prev year link
		cal.set(year, month, 1);
		cal.add(Calendar.YEAR, -1);
		url = _xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
		url.setParameter("month", monthUrlFormat.format(cal.getTime()));
		if(selected != null)
			url.setParameter("selected", selectedStr);
		iWriter.print("<a class='PrevYear' href='");
		iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
		iWriter.print("' title='");
		iWriter.print(monthDisplayFormat.format(cal.getTime()));
		iWriter.print("'>&nbsp;</a>");
		
		iWriter.print("&nbsp;");

		// --- prev month link
		cal.set(year, month, 1);
		cal.add(Calendar.MONTH, -1);
		url = _xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
		url.setParameter("month", monthUrlFormat.format(cal.getTime()));
		if(selected != null)
			url.setParameter("selected", selectedStr);
		iWriter.print("<a class='PrevMonth' href='");
		iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
		iWriter.print("' title='");
		iWriter.print(monthDisplayFormat.format(cal.getTime()));
		iWriter.print("'>&nbsp;</a>");
		
		iWriter.print("&nbsp;");
		
		// --- write current month
		cal.set(year, month, 1);
		iWriter.print("<span class='Title'>");
		iWriter.print(monthDisplayFormat.format(cal.getTime()));
		iWriter.print("</span>");
		
		iWriter.print("&nbsp;");

		// --- next month link
		cal.set(year, month, 1);
		cal.add(Calendar.MONTH, +1);
		url = _xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
		url.setParameter("month", monthUrlFormat.format(cal.getTime()));
		if(selected != null)
			url.setParameter("selected", selectedStr);
		iWriter.print("<a class='NextMonth' href='");
		iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
		iWriter.print("' title='");
		iWriter.print(monthDisplayFormat.format(cal.getTime()));
		iWriter.print("'>&nbsp;</a>");
		
		iWriter.print("&nbsp;");
		
		// --- next year link
		cal.set(year, month, 1);
		cal.add(Calendar.YEAR, +1);
		url = _xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
		url.setParameter("month", monthUrlFormat.format(cal.getTime()));
		if(selected != null)
			url.setParameter("selected", selectedStr);
		iWriter.print("<a class='NextYear' href='");
		iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
		iWriter.print("' title='");
		iWriter.print(monthDisplayFormat.format(cal.getTime()));
		iWriter.print("'>&nbsp;</a>");
		
		iWriter.print("</div>");

		iWriter.print("</th>");
		iWriter.println("</tr>");
		
		// --- header row (day names)
		// --------------------------
		cal.set(year, month, 1);
		iWriter.print("<tr class=DayNames>");
		
		iWriter.print("<th scope=col class=Week>");
		iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "calendar.week")));
		iWriter.print("</th>");
		
		int firstDayInWeek = cal.getFirstDayOfWeek();
		int day = firstDayInWeek;
		for(int i=0; i<7; i++)
		{
			iWriter.print("<th scope=col>");
			iWriter.print(getDayName(iResponse.getLocale(), day));
			iWriter.print("</th>");
			day++;
			if(day > 6) day = 0;
		}
		iWriter.println("</tr>");
		
		// --- week rows
		// -------------
		cal.set(year, month, 1);
		int nbWeeks = cal.getActualMaximum(Calendar.WEEK_OF_MONTH);
		cal.set(Calendar.WEEK_OF_MONTH, 1);
		cal.set(Calendar.DAY_OF_WEEK, firstDayInWeek);
		
		for(int i=0; i<nbWeeks; i++)
		{
			iWriter.print("<tr class=Week>");
			
			iWriter.print("<td class=Week>");
			iWriter.print("<span>");
			iWriter.print(String.valueOf(cal.get(Calendar.WEEK_OF_YEAR)));
			iWriter.print("</span>");
			iWriter.print("</td>");
			
			for(int j=0; j<7; j++)
			{
				int dayInWeek = cal.get(Calendar.DAY_OF_WEEK);
				Date dayDate = cal.getTime();

				iWriter.print("<td class=Day>");
				iWriter.print("<a class='Day");
				if(dayInWeek == Calendar.SATURDAY || dayInWeek == Calendar.SUNDAY)
					iWriter.print(" WeekEnd");
				if(cal.get(Calendar.MONTH) != month)
					iWriter.print(" OutMonth");
				if(selected != null && selected.getYear() == dayDate.getYear() && selected.getMonth() == dayDate.getMonth() && selected.getDate() == dayDate.getDate())
					iWriter.print(" Selected");
				iWriter.print("'");
				iWriter.print(" href='javascript:void(0)'");
				iWriter.print(" onclick=\"");
				iWriter.print("DateField_setDateAndClose('"+_xmlancestor_Form.getID()+"', '"+getFieldName()+"', '"+inputFormat.format(dayDate)+"'); return false;");
				iWriter.print("\"");
//				iWriter.print(" href=\"javascript:void(");
//				iWriter.print("DateField_setDateAndClose('"+_xmlancestor_Form.getID()+"', '"+getFieldName()+"', '"+inputFormat.format(dayDate)+"')");
//				iWriter.print(")\"");
				iWriter.print(">");
				iWriter.print(String.valueOf(cal.get(Calendar.DATE)));
				iWriter.print("</a>");
				iWriter.print("</td>");
				
				// --- add one day
				cal.add(Calendar.DAY_OF_YEAR, 1);
			}
			iWriter.println("</tr>");
		}
		
		iWriter.println("</table>");
		
		iWriter.println("</body>");
		iWriter.println("</html>");
		
		iWriter.flush();
		iWriter.close();
	}
}
