package com.ebm_ws.infra.bricks.components.base.html.form.field;


import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class DynAutocomplete extends BaseBeanProvider implements IXmlObject, IIdentifiable, IAutocomplete
{
	protected Application _xmlroot;
	private String _xmlattr_opt_ValueBeanName = "$value";
	private IBinding _xmlnode_req_CompletedValues;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Autocomplete";
	}
	// --- [-] IIdentifiable implementation
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    if(_xmlroot.registerRequestHandler(getPathID(), this) != null)
        	iErrors.logMessage(this, "ID", IValidityLogger.INFO, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
		if(_xmlnode_req_CompletedValues != null && !_xmlnode_req_CompletedValues.hasErrors())
		{
			Class valueClass = ReflectionHelper.getVectorElementClass(_xmlnode_req_CompletedValues.getGenericType());
			if(valueClass != String.class)
		    	iErrors.logMessage(this, "CompletedValues", IValidityLogger.ERROR, "Bound values must be vector of String.");
		}
	}
	/**
	 * Render the JavaScript function body with signature: <fn>(textField)
	 */
	public void renderJsAutocomplete(String iJsCallbackFnName, HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		
		HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Common.js");
		HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Autocomplete.js");
		
		UrlBuilder jsonRequestUrl = _xmlroot.createServiceUrl(iRequest, this, "jsonRequest");
		
		writer.println("<script language='javascript' type='text/javascript'>");
		writer.println(
				"var Autocomplete_DynTimeout = undefined;\n" +
				"function "+iJsCallbackFnName+"(textField)\n" +
				"{\n" +
				"	if(Autocomplete_DynTimeout != undefined)\n" +
				"	{\n" +
				"		clearTimeout(Autocomplete_DynTimeout);\n" +
				"		Autocomplete_DynTimeout = undefined;\n" +
				"	}\n" +
				"	Autocomplete_DynTimeout = setTimeout(function() {\n" +
				"		Autocomplete_getDynValues(textField, '"+jsonRequestUrl.toUrl(iResponse.getCharacterEncoding(), false)+"');\n" +
				"	}, 1000);\n" +
				"}");
		writer.println("</script>");
	}

	// ========================================================================
	// === JSON Methods
	// ========================================================================
	public void jsonRequest(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
System.out.println("--> AjaxAutocomplete.jsonRequest(): "+iRequest.getQueryString());
		
		BricksSession session = BricksSession.getSession(iRequest);
		iResponse.setContentType("text/plain;charset="+session.getLocaleConfig().getCharSet());
//		iResponse.setHeader("Cache-Control", "no-store"); //HTTP 1.1
		iResponse.setHeader("Cache-Control", "no-cache"); //HTTP 1.1
		iResponse.setHeader("Pragma", "no-cache"); //HTTP 1.0
		iResponse.setDateHeader("Expires", 0); //prevents caching at the proxy server

		PrintWriter iWriter = iResponse.getWriter();

		String value = iRequest.getParameter("value");
		iRequest.setAttribute(_xmlattr_opt_ValueBeanName, value);
		List proposedValues = ReflectionHelper.obj2List(_xmlnode_req_CompletedValues.invoke(iRequest));
		if(proposedValues == null)
		{
			iWriter.print("null");
		}
		else
		{
			iWriter.print("[");
			for(int i=0; i<proposedValues.size(); i++)
			{
				if(i > 0)
					iWriter.print(",");
				iWriter.print("'");
				iWriter.print(HtmlUtils.encode2JsString(String.valueOf(proposedValues.get(i))));
				iWriter.print("'");
			}
			iWriter.print("]");
		}

		iWriter.flush();
		iWriter.close();
	}
	// ==================================================================
	// === BeanProvider
	// ==================================================================
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ValueBeanName.equals(iName))
			return String.class;
		return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ValueBeanName.equals(iName))
			return String.class;
		return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlattr_opt_ValueBeanName.equals(iName))
			return iRequest.getAttribute(iName);
		return getParentBeanValue(iRequest, iName);
	}
}
