package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.enums.IntegerFieldType;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;


public class IntegerField extends BaseSingleValueField
{
	private IntegerFieldType _xmlattr_opt_Type = IntegerFieldType.InputField;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_Bind != null && !_xmlnode_req_Bind.hasErrors())
		{
			Class type = _xmlnode_req_Bind.getType();
			
			// --- check binding type
	    	if(!ReflectionHelper.isIntegerLike(_xmlnode_req_Bind.getType()))
				iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Binding "+_xmlnode_req_Bind+" has invalid type: "+_xmlnode_req_Bind.getType()+". Either int or Integer is expected.");
			
			// --- check validator types
			if(_xmlnode_0_unb_Validators != null)
			{
				for(int i=0; i<_xmlnode_0_unb_Validators.length; i++)
				{
					if(!_xmlnode_0_unb_Validators[i].isTypeValid(type))
						iErrors.logMessage(this, "Validators", IValidityLogger.ERROR, "Validator "+i+" has invalid type.");
				}
			}
		}
	}
	public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder)
	{
		String val = iRequest.getParameter(getFieldName());
		try
        {
	        return ReflectionHelper.parse2Type(val, _xmlnode_req_Bind.getType());
        }
        catch(NumberFormatException e)
        {
        	iValidationHolder.addItemError(getFieldName(), new LocalizedMessage("validation.int.not_an_int", "bricks"));
        	return null;
        }
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
	}
	protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		boolean editable = iContext.isEditable() && isEditable(iRequest);
		
		// --- rcupration de la valeur
		String val = null;
		if(editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().getValidationErrors() != null)
		{
			// --- after a submit: retrieve value from the request
			val = iRequest.getParameter(getFieldName());
		}
		else
		{
			// --- first display: retireve value from the bean
			val = String.valueOf(_xmlnode_req_Bind.invoke(iRequest));
		}
		if(val == null)
			// --- intialisation  vide
			// TODO: valeur par dfaut ?
			val = "";
		
		if(_xmlattr_opt_Type == IntegerFieldType.InputField)
		{
			if(editable)
			{
				iWriter.print("<input type='text'");
				iWriter.print(" id='");
				iWriter.print(getFieldId());
				iWriter.print("'");
				iWriter.print(" name='");
				iWriter.print(getFieldName());
				iWriter.print("'");
				iWriter.print(" size='10'");
				if(!iContext.isEditMode())
					iWriter.print(" disabled='disabled'");
				iWriter.print(" value=\"");
				iWriter.print(HtmlUtils.encode2HTML(val));
				iWriter.print("\"");
				iWriter.print(">");
			}
			else
			{
				iWriter.print(HtmlUtils.encode2HTML(val));
			}
		}
		else // percentage bar
		{
			// TODO: make editable
			iWriter.print("<div class=PercentageBar>");
			iWriter.print("<div class=Bar style='width: "+val+"%'>&nbsp;</div>");
			iWriter.print("<div class=Percentage>"+val+"%</div>");
			iWriter.println("</div>");
		}
	}
}
