package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.form.BaseForm;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.form.IFormItem;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class MessageField implements IXmlObject, IFormItem
{
	private BaseForm _xmlancestor_Form;
	protected IMessage _xmlnode_req_Label;
	protected IMessage _xmlnode_req_Value;
	private IBoolExpr _xmlnode_opt_Visible;
	private IMenuItem[] _xmlnode_0_unb_FieldButtons;
	
	public void checkThisNode(Object validSupport, IValidityLogger errors)
	{
	}
	protected BaseForm getForm()
	{
		return _xmlancestor_Form;
	}
	public boolean isVisible(HttpServletRequest iRequest)
	{
		return _xmlnode_opt_Visible == null || _xmlnode_opt_Visible.eval(iRequest);
	}

	public void submit(HttpServletRequest request, FormSubmitContext submitContext) throws Exception
	{
	}
	public void preRender(HttpServletRequest request) throws Exception
	{
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(!isVisible(iRequest))
			return;
		
		FormRenderingContext renderingCtx = getForm().getRenderingContext(iRequest);

		PrintWriter iWriter = iResponse.getWriter();
		iWriter.println("<div class='field "+(renderingCtx.isOddField() ? "odd" : "even")+"'>");
		// --- label
		iWriter.print("<label class=field");
		/*
		if(renderingCtx.isEditMode() && this.isEditable(iRequest))
		{
			iWriter.print(" for='");
			iWriter.print(getFieldId());
			iWriter.print("'");
		}
		*/
		iWriter.print(">");
		iWriter.print(HtmlUtils.encode2HTML(_xmlnode_req_Label.getMessage(iRequest)));
		iWriter.println("</label>");
		
		// --- value
		iWriter.print("<div class=input>");
		iWriter.print(HtmlUtils.encode2HTML(_xmlnode_req_Value.getMessage(iRequest)));
		iWriter.println("</div>");
		
		// --- mark mandatory fields ?
		
		// --- field buttons
		// --- only displayed in edition mode ? (otherwise do we have to submit?)
		if(_xmlnode_0_unb_FieldButtons != null && _xmlnode_0_unb_FieldButtons.length > 0)
		{
			ILinkHrefRenderer linkRenderer = null;
			if(renderingCtx.isEditMode())
			{
				// --- field buttons are disabled
				linkRenderer = new ILinkHrefRenderer()
				{
					public boolean isEnabled(HttpServletRequest request)
					{return false;}
					public void renderHref(HttpServletRequest request, HttpServletResponse response, String href) throws Exception {}
				};
			}
			
			iWriter.println("<ul class=fieldbuttons>");
			for(int i=0; i<_xmlnode_0_unb_FieldButtons.length; i++)
				_xmlnode_0_unb_FieldButtons[i].render(iRequest, iResponse, linkRenderer);
			iWriter.println("</ul>");
		}
		
		iWriter.println("</div>");
	}
}
