package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.MultiChoiceType;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.item.DisplayableItem;
import com.ebm_ws.infra.bricks.components.base.html.item.IItemsProvider;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;


public class MultiChoiceField extends BaseVectorValueField
{
	private MultiChoiceType _xmlattr_opt_Type = MultiChoiceType.CheckBoxes;
	private int _xmlattr_opt_ListSize = 8;

	private Class bindingType;

	private IItemsProvider _xmlnode_req_Items;
	private IBinding _xmlnode_opt_OnChange;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- accept int, Integer or String
		if(_xmlnode_req_Bind != null && !_xmlnode_req_Bind.hasErrors())
		{
			bindingType = ReflectionHelper.getVectorElementClass(_xmlnode_req_Bind.getGenericType());
			if(bindingType == null)
			{
		    	iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Bound data must be vector data.");
			}
			else if(!ReflectionHelper.isIntegerLike(bindingType) && bindingType != String.class)
			{
		    	iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Bound data must be either String, Integer or int.");
			}
			
		    // --- test type compatibility between items type and binding
			if(_xmlnode_req_Items != null)
			{
				if(!ReflectionHelper.isAssignable(bindingType, _xmlnode_req_Items.getItemValueType()))
					iErrors.logMessage(this, "Items", IValidityLogger.ERROR, "Items type ("+_xmlnode_req_Items.getItemValueType()+") incompatible with binding ("+bindingType+")");
			}
		}
	}

	public List getValuesFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder)
	{
		String[] values = iRequest.getParameterValues(getFieldName());
		if(values == null)
			return null;
		//TODO: construire un tableau du type requis
		if(ReflectionHelper.isIntegerLike(bindingType))
		{
			List ret = new ArrayList();
			for(int i=0; i<values.length; i++)
				ret.add(ReflectionHelper.parse2Type(values[i], bindingType));
			return ret;
		}
		else
		{
			// --- return a String array
			List ret = new ArrayList();
			for(int i=0; i<values.length; i++)
				ret.add(values[i]);
			return ret;
		}
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		if(_xmlnode_opt_OnChange == null)
			return;
		
		FormSubmitContext submitCtx = getForm().getSubmitContext(iRequest);
		if(submitCtx != null && submitCtx.getAction().equals("change:"+getFieldName()))
		{
			// --- the submit action was a dynamic change of this field: callback handler
			_xmlnode_opt_OnChange.invoke(iRequest);
		}
	}
	protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		boolean showEditable = iContext.isEditMode() && isEditable(iRequest);
		
		// --- rcupration des valeurs possibles
		DisplayableItem[] items = _xmlnode_req_Items.getItems(iRequest);
		if(items == null || items.length == 0)
			// no items: skip
			return;
		
		// --- rcupration de la valeur de slection
		List selected = null;
		if(showEditable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction())
		{
			// --- after a submit: retrieve value from the request
			selected = getValuesFromRequest(iRequest, null);
		}
		else
		{
			// --- first display: retireve value from the bean
			selected = ReflectionHelper.obj2List(_xmlnode_req_Bind.invoke(iRequest));
		}
		if(selected == null)
			// --- intialisation  vide
			// TODO: valeur par dfaut ?
			selected = new ArrayList();
		
		// --- include required JavaScript
		if(showEditable)
			HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");

		if(_xmlattr_opt_Type == MultiChoiceType.CheckBoxes)
		{
			iWriter.println("<ul>");
			for(int i=0; i<items.length; i++)
			{
				// --- eval whether this item is selected
				boolean checked = false;
				for(int j=0; j<selected.size(); j++)
				{
					if(selected.get(j).equals(items[i].getValue()))
					{
						checked = true;
						break;
					}
				}
				String id = getFieldId()+"_"+i;

				iWriter.print("<li>");
				if(showEditable && !items[i].isEnabled() && checked)
				{
					// --- need to submit checked state for a non-enabled item
					iWriter.print("<input type='hidden'");
					iWriter.print(" name='");
					iWriter.print(getFieldName());
					iWriter.print("'");
					iWriter.print(" value='");
					iWriter.print(String.valueOf(items[i].getValue()));
					iWriter.print("'");
					iWriter.print("/>");
				}
				
				iWriter.print("<input type='checkbox' class='checkbox'");
				iWriter.print(" name='");
				iWriter.print(getFieldName());
				iWriter.print("'");
				iWriter.print(" id='");
				iWriter.print(id);
				iWriter.print("'");
				if(!showEditable || !items[i].isEnabled())
				{
					iWriter.print(" disabled='disabled'");
				}
				else
				{
					if(showEditable && _xmlnode_opt_OnChange != null)
					{
						// --- add javascript to submit changes immediately
						iWriter.print(" onclick=\"Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"')\"");
					}
				}
				iWriter.print(" value='");
				iWriter.print(String.valueOf(items[i].getValue()));
				iWriter.print("'");
				if(checked)
					iWriter.print(" checked='checked'");
				iWriter.print("/>");
				
				// --- using a label with for attribute manages the toggling
				iWriter.print("<label for='");
				iWriter.print(id);
				iWriter.print("'");
				if(showEditable && items[i].isEnabled())
				{
					if(_xmlnode_opt_OnChange != null)
						// --- add javascript to submit changes immediately
						// (setTimeout for FF)
						iWriter.print(" onclick=\"setTimeout(&quot;Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"')&quot;, 0)\"");
						// --- toggle and submit
// no ?						iWriter.print("Checkbox_toggle('"+id+"'); Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"'); return false;");
				}
				iWriter.print(">");
				iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
				
				iWriter.print("</label>");
				
				iWriter.println("</li>");
			}
			iWriter.println("</ul>");
		}
		else // List
		{
			iWriter.print("<select");
			iWriter.print(" multiple='multiple'");
			iWriter.print(" id='");
			iWriter.print(getFieldId());
			iWriter.print("'");
			iWriter.print(" name='");
			iWriter.print(getFieldName());
			iWriter.print("'");
			iWriter.print(" size='");
			iWriter.print(String.valueOf(_xmlattr_opt_ListSize));
			iWriter.print("'");
			if(!showEditable)
				iWriter.print(" disabled='disabled'");
			if(showEditable && _xmlnode_opt_OnChange != null)
			{
				// --- add javascript to submit changes immediately
				iWriter.print(" onchange=\"Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"')\"");
			}
			iWriter.println(">");
			
			for(int i=0; i<items.length; i++)
			{
				iWriter.print("<option");
				iWriter.print(" value='");
				iWriter.print(String.valueOf(items[i].getValue()));
				iWriter.print("'");
				if(!items[i].isEnabled())
					iWriter.print(" disabled='disabled'");
				for(int j=0; j<selected.size(); j++)
				{
					if(selected.get(j).equals(items[i].getValue()))
					{
						iWriter.print(" selected='selected'");
						break;
					}
				}
				iWriter.print(">");
				iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
				iWriter.println("</option>");
			}
			
			iWriter.println("</select>");
		}
	}

	/**
	 * Helper method to retreive the object representing the selectable item that is currently being rendered.
	 * This method should be called by custom message components during the rendering process.
	 * @param iRequest
	 * @return
	 */
	/*
	public static Item getCurrentItem(HttpServletRequest iRequest)
	{
		return (Item)iRequest.getAttribute("#item");
	}
	*/
}
