package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.SingleChoiceType;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.item.DisplayableItem;
import com.ebm_ws.infra.bricks.components.base.html.item.IItemsProvider;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;


public class SingleChoiceField extends BaseSingleValueField
{
	private SingleChoiceType _xmlattr_opt_Type = SingleChoiceType.ComboBox;
	private int _xmlattr_opt_ListSize = 8;
	
	private Class bindingType;
	
	private IItemsProvider _xmlnode_req_Items;
	private IBinding _xmlnode_opt_OnChange;

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- accept int, Integer or String
		if(_xmlnode_req_Bind != null && !_xmlnode_req_Bind.hasErrors())
		{
			bindingType = _xmlnode_req_Bind.getType();
			if(bindingType == null)
			{
		    	iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Binding type not found.");
			}
			else if(!ReflectionHelper.isIntegerLike(bindingType) && bindingType != String.class)
			{
		    	iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Bound data must be either String, Integer or int.");
			}
			
		    // --- test type compatibility between items type and binding
			if(_xmlnode_req_Items != null)
			{
				if(!ReflectionHelper.isAssignable(bindingType, _xmlnode_req_Items.getItemValueType()))
					iErrors.logMessage(this, "Items", IValidityLogger.ERROR, "Items type ("+_xmlnode_req_Items.getItemValueType()+") incompatible with binding ("+bindingType+")");
			}
		}
		
		// --- check validator types
		if(bindingType != null && _xmlnode_0_unb_Validators != null)
		{
			for(int i=0; i<_xmlnode_0_unb_Validators.length; i++)
			{
				if(!_xmlnode_0_unb_Validators[i].isTypeValid(bindingType))
					iErrors.logMessage(this, "Validators", IValidityLogger.ERROR, "Validator "+i+" has invalid type.");
			}
		}
	}
	public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder)
	{
		String selected = iRequest.getParameter(getFieldName());
		if(selected == null)
			return null;
		return ReflectionHelper.parse2Type(selected, bindingType);
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		if(_xmlnode_opt_OnChange == null)
			return;
		
		FormSubmitContext submitCtx = getForm().getSubmitContext(iRequest);
		if(submitCtx != null && submitCtx.getAction().equals("change:"+getFieldName()))
		{
			// --- the submit action was a dynamic change of this field: callback handler
			_xmlnode_opt_OnChange.invoke(iRequest);
		}
	}
	protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		boolean editable = iContext.isEditable() && isEditable(iRequest);
		boolean showEditable = editable && iContext.isEditMode();
		
		// --- rcupration des items
		DisplayableItem[] items = _xmlnode_req_Items.getItems(iRequest);
		if(items == null || items.length == 0)
			throw new Exception("No item for SingleChoiceField.");
		
		// --- rcupration de la valeur de slection
		String selectedStr = null;
		if(editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction())
		{
			// --- after a submit: retrieve value from the request
			selectedStr = iRequest.getParameter(getFieldName());
		}
		else
		{
			// --- first display: retireve value from the bean
			selectedStr = String.valueOf(_xmlnode_req_Bind.invoke(iRequest));
		}
		if(selectedStr == null)
			// --- intialisation  vide
			// TODO: valeur par dfaut ?
			selectedStr = String.valueOf(items[0].getValue());
		
		// --- include required JavaScript
		if(_xmlnode_opt_OnChange != null)
			HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
		
		if(_xmlattr_opt_Type == SingleChoiceType.RadioButtons)
		{
			iWriter.println("<ul>");
			for(int i=0; i<items.length; i++)
			{
				String valStr = String.valueOf(items[i].getValue());
				String id = getFieldId()+"_"+i;
				boolean selected = selectedStr.equals(valStr);
				
				iWriter.print("<li>");
				iWriter.print("<input type='radio' class='radio'");
				iWriter.print(" name='");
				iWriter.print(getFieldName());
				iWriter.print("'");
				iWriter.print(" id='");
				iWriter.print(id);
				iWriter.print("'");
				if(!showEditable || !items[i].isEnabled())
					iWriter.print(" disabled='disabled'");
				iWriter.print(" value='");
				iWriter.print(valStr);
				iWriter.print("'");
				if(selected)
					iWriter.print(" checked='checked'");
				if(showEditable && !selected && _xmlnode_opt_OnChange != null)
				{
					// --- add javascript to submit changes immediately
					iWriter.print(" onclick=\"Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"')\"");
				}
				iWriter.print("/>");
				
				// --- using a label with for attribute manages the toggling
				iWriter.print("<label for='");
				iWriter.print(id);
				iWriter.print("'");
				if(showEditable && !selected && items[i].isEnabled())
				{
					if(_xmlnode_opt_OnChange != null)
						// --- add javascript to submit changes immediately
						// (setTimeout for FF)
						iWriter.print(" onclick=\"setTimeout(&quot;Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"')&quot;, 0)\"");
						// --- toggle and submit
						// no? iWriter.print(" onclick=\"Radio_check('"+id+"'); Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"'); return false;\"");
				}
				iWriter.print(">");
				iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
				iWriter.print("</label>");
				
				iWriter.println("</li>");
			}
			iWriter.println("</ul>");
		}
		else // ComboBox or List
		{
			if(_xmlattr_opt_Type == SingleChoiceType.ComboBox && !editable)
			{
				// --- display as a simple text
				DisplayableItem item = null;
				for(int i=0; i<items.length; i++)
				{
					if(selectedStr.equals(String.valueOf(items[i].getValue())))
					{
						item = items[i];
						break;
					}
				}
				if(item != null)
					iWriter.print(HtmlUtils.encode2HTML(item.getText()));
			}
			else
			{
//				int size = _xmlattr_opt_Type == SingleChoiceType.ComboBox ? 1 : _xmlattr_opt_ListSize;
				iWriter.print("<select");
				iWriter.print(" id='");
				iWriter.print(getFieldId());
				iWriter.print("'");
				iWriter.print(" name='");
				iWriter.print(getFieldName());
				iWriter.print("'");
				if(_xmlattr_opt_Type == SingleChoiceType.List)
				{
					iWriter.print(" size='");
					iWriter.print(String.valueOf(_xmlattr_opt_ListSize));
					iWriter.print("'");
				}
				if(!showEditable)
					iWriter.print(" disabled='disabled'");
				if(showEditable && _xmlnode_opt_OnChange != null)
				{
					// --- add javascript to submit changes immediately
					iWriter.print(" onchange=\"Form_submit('"+getForm().getID()+"', 'change:"+getFieldName()+"')\"");
				}
				iWriter.println(">");
				
				for(int i=0; i<items.length; i++)
				{
					String valStr = String.valueOf(items[i].getValue());
					iWriter.print("<option");
					iWriter.print(" value='");
					iWriter.print(valStr);
					iWriter.print("'");
					if(!items[i].isEnabled())
						iWriter.print(" disabled='disabled'");
					if(selectedStr.equals(valStr))
						iWriter.print(" selected='selected'");
					iWriter.print(">");
					iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
					iWriter.println("</option>");
				}
				
				iWriter.println("</select>");
			}
		}
	}


	/**
	 * Helper method to retreive the object representing the selectable item that is currently being rendered.
	 * This method should be called by custom message components during the rendering process.
	 * @param iRequest
	 * @return
	 */
	/*
	public static Item getCurrentItem(HttpServletRequest iRequest)
	{
		return (Item)iRequest.getAttribute("#item");
	}
	*/
}
