package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;


public class TextField extends BaseSingleValueField
{
	private int _xmlattr_opt_Rows = 1;
	private int _xmlattr_opt_Cols = 20;
	private IBoolExpr _xmlnode_opt_IsPassword;
	private IAutocomplete _xmlnode_opt_Autocomplete;
	
	/*
	public Class getBaseType()
	{
	    return String.class;
	}
	*/
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_Bind != null && !_xmlnode_req_Bind.hasErrors())
		{
			Class type = String.class;
			
			// --- check binding type
	    	if(!type.isAssignableFrom(_xmlnode_req_Bind.getType()))
				iErrors.logMessage(this, "Bind", IValidityLogger.ERROR, "Binding has invalid type.");
			
			// --- check validator types
			if(_xmlnode_0_unb_Validators != null)
			{
				for(int i=0; i<_xmlnode_0_unb_Validators.length; i++)
				{
					if(!_xmlnode_0_unb_Validators[i].isTypeValid(type))
						iErrors.logMessage(this, "Validators", IValidityLogger.ERROR, "Validator "+i+" has invalid type.");
				}
			}
		}
	}
	public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder)
	{
	    return iRequest.getParameter(getFieldName());
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
	}
	protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		boolean editable = iContext.isEditable() && isEditable(iRequest);

		// --- rcupration de la valeur
		String val = null;
		if(editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction())
		{
			// --- after a submit: retrieve value from the request
			val = iRequest.getParameter(getFieldName());
		}
		else
		{
			// --- first display: retireve value from the bean
			val = (String)_xmlnode_req_Bind.invoke(iRequest);
		}
		if(val == null)
			// --- intialisation  vide
			// TODO: valeur par dfaut ?
			val = "";
		
		if(_xmlattr_opt_Rows > 1)
		{
			iWriter.print("<textarea");
			iWriter.print(" id='");
			iWriter.print(getFieldId());
			iWriter.print("'");
			iWriter.print(" name='");
			iWriter.print(getFieldName());
			iWriter.print("'");
			iWriter.print(" cols='");
			iWriter.print(String.valueOf(_xmlattr_opt_Cols));
			iWriter.print("'");
			iWriter.print(" rows='");
			iWriter.print(String.valueOf(_xmlattr_opt_Rows));
			iWriter.print("'");
			if(!editable || !iContext.isEditMode())
				iWriter.print(" disabled='disabled'");
			iWriter.print(">");
			iWriter.print(encodeTextarea(val));
			iWriter.print("</textarea>");
		}
		else
		{
			boolean password = _xmlnode_opt_IsPassword != null && _xmlnode_opt_IsPassword.eval(iRequest);
			if(editable)
			{
				iWriter.print("<input");
				if(password)
				{
					iWriter.print(" type='password'");
				}
				else
				{
					iWriter.print(" type='text'");
					/* No: doesn't validate in HTML 4.01
					 * This is done in JavaScript
					if(_xmlnode_opt_Autocomplete != null)
						iWriter.print(" autocomplete='off'");
					*/
				}
				iWriter.print(" id='");
				iWriter.print(getFieldId());
				iWriter.print("'");
				iWriter.print(" name='");
				iWriter.print(getFieldName());
				iWriter.print("'");
				iWriter.print(" size='");
				iWriter.print(String.valueOf(_xmlattr_opt_Cols));
				iWriter.print("'");
				if(!iContext.isEditMode())
					iWriter.print(" disabled='disabled'");
				iWriter.print(" value=\"");
				iWriter.print(HtmlUtils.encode2HTML(val));
				iWriter.print("\"");
				iWriter.print(">");
				
				if(!password && _xmlnode_opt_Autocomplete != null)
				{
					// --- initialize the autocomplete component for this textfield
					String jsCallbackFnName = "onChange_"+toJsFunctionName(getForm().getID())+"_"+toJsFunctionName(getFieldName());
					_xmlnode_opt_Autocomplete.renderJsAutocomplete(jsCallbackFnName, iRequest, iResponse);
					
					iWriter.println("<script language='javascript' type='text/javascript'>");
					iWriter.println("Autocomplete_init('"+getForm().getID()+"', '"+getFieldName()+"', "+jsCallbackFnName+");");
					iWriter.println("</script>");
				}
			}
			else
			{
				if(password)
					// TODO ?
					iWriter.print("*****");
				else
					iWriter.print(HtmlUtils.encode2HTML(val));
			}
		}
	}
	private static String toJsFunctionName(String text)
	{
		int nbChars = text.length();
		StringBuffer sb = new StringBuffer(nbChars);
		for(int i=0; i<nbChars; i++)
		{
			char c = text.charAt(i);
			if(Character.isLetterOrDigit(c))
				sb.append(c);
			else
				sb.append('_');
		}
		return sb.toString();
	}
	private static String encodeTextarea(String text)
	{
		int nbChars = text.length();
		StringBuffer sb = new StringBuffer(nbChars);
		for(int i=0; i<nbChars; i++)
		{
			char c = text.charAt(i);
			switch(c)
			{
				/*
			case '\n': // \n turned into <br>
				sb.append("<br>");
				break;
			case '\r': // \r turned into braking whitespace
				sb.append(" ");
				break;
			case '\t': // TAB is turned into 4 non-braking spaces
				sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
				break;
				*/
			case '<':
				sb.append("&lt;");
				break;
			case '>':
				sb.append("&gt;");
				break;
				/*
			case '\"':
				sb.append("&quot;");
				break;
				*/
			default:
				sb.append(c);
				break;
			}
		}
		return sb.toString();
	}
}
