package com.ebm_ws.infra.bricks.components.base.html.item;

import java.lang.reflect.Type;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class DynamicItems extends BaseBeanProvider implements IXmlObject, IItemsProvider
{
	private String _xmlattr_opt_ItemBeanName = "$item";
	private IBinding _xmlnode_req_Items;
	private IBinding _xmlnode_opt_Value;
	private IMessage _xmlnode_opt_Text;
	private IBoolExpr _xmlnode_opt_Disabled;
	
	private Type itemType;
	private Class itemClass;
	private Class itemValueClass;
	
	private void initialize()
	{
		if(itemClass != null)
			return;
		if(_xmlnode_req_Items != null && !_xmlnode_req_Items.hasErrors())
		{
			itemClass = ReflectionHelper.getVectorElementClass(_xmlnode_req_Items.getGenericType());
			itemType = ReflectionHelper.getVectorElementType(_xmlnode_req_Items.getGenericType());
			
			if(_xmlnode_opt_Value != null && !_xmlnode_opt_Value.hasErrors())
				itemValueClass = _xmlnode_opt_Value.getType();
			else
				itemValueClass = itemClass;
		}
	}
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_Items != null && !_xmlnode_req_Items.hasErrors())
		{
			if(itemClass == null)
				initialize();
			if(itemClass == null)
		    	iErrors.logMessage(this, "Items", IValidityLogger.ERROR, "Bound items must be vector data.");
		}
		
		/* Pas de check... on peut accepter d'autres types (ex: boolean, ...). en fait tous les types parsables
		if(valueType != null)
		{
			if(!ReflectionHelper.isIntegerLike(valueType) && !String.class.isAssignableFrom(valueType))
		    	iErrors.logMessage(this, "Value", IValidityLogger.ERROR, "Value must return either a String, int or Integer (current: "+valueType.getName()+").");
		}
		*/
	}
	public DisplayableItem[] getItems(HttpServletRequest iRequest) throws Exception
	{
//		Object[] itemObjs = ReflectionHelper.obj2Array(_xmlnode_req_Items.getValue(iRequest), false);
		List itemObjs = ReflectionHelper.obj2List(_xmlnode_req_Items.invoke(iRequest));
		if(itemObjs == null)
			return null;
		DisplayableItem[] items = new DisplayableItem[itemObjs.size()];
		for(int i=0; i<itemObjs.size(); i++)
		{
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, itemObjs.get(i));
			
			Object value = itemObjs.get(i);
			
			if(_xmlnode_opt_Value != null)
				value = _xmlnode_opt_Value.invoke(iRequest);
			
			String text = _xmlnode_opt_Text == null ? String.valueOf(value) : _xmlnode_opt_Text.getMessage(iRequest);
			
			items[i] = new DisplayableItem(value, text);
			
			if(_xmlnode_opt_Disabled != null)
				items[i].setEnabled(!_xmlnode_opt_Disabled.eval(iRequest));
		}
	    return items;
	}
	public Class getItemValueType()
	{
		if(itemClass == null)
			initialize();
		return itemValueClass;
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			if(itemClass == null) throw new UnresolvedBeanError();
			return itemClass;
		}
		return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			if(itemType == null) throw new UnresolvedBeanError();
			return itemType;
		}
		return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
			return iRequest.getAttribute(iName);
		return getParentBeanValue(iRequest, iName);
	}
}
