package com.ebm_ws.infra.bricks.components.base.html.item;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class InlineItems implements IXmlObject, IItemsProvider
{
	private Item[] _xmlcollect_1_unb_Items;
	private Class itemValueClass;
	
	private void initialize()
	{
		if(itemValueClass != null)
			return;
		if(_xmlcollect_1_unb_Items != null && _xmlcollect_1_unb_Items.length > 0)
		{
			itemValueClass = _xmlcollect_1_unb_Items[0]._xmlnode_req_Value.getType();
		}
	}
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(itemValueClass == null)
			initialize();
	}
	public DisplayableItem[] getItems(HttpServletRequest iRequest) throws Exception
	{
		DisplayableItem[] items = new DisplayableItem[_xmlcollect_1_unb_Items.length];
		for(int i=0; i<items.length; i++)
		{
			items[i] = new DisplayableItem(_xmlcollect_1_unb_Items[i]._xmlnode_req_Value.invoke(iRequest), _xmlcollect_1_unb_Items[i]._xmlnode_req_Text.getMessage(iRequest));
			if(_xmlcollect_1_unb_Items[i]._xmlnode_opt_Disabled != null)
				items[i].setEnabled(!_xmlcollect_1_unb_Items[i]._xmlnode_opt_Disabled.eval(iRequest));
		}
		return items;
	}
	public Class getItemValueType()
	{
		if(itemValueClass == null)
			initialize();
	    return itemValueClass;
	}
}
