package com.ebm_ws.infra.bricks.components.base.html.layout;


import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Div implements IXmlObject, IView
{
	private String _xmlattr_opt_ID;
	private String _xmlattr_opt_CssClass;
	private IBoolExpr _xmlnode_opt_Visible;
	private IView[] _xmlcollect_1_unb_Views;

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    
	}
	public boolean isVisible(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Visible == null)
			return true;
		return _xmlnode_opt_Visible.eval(iRequest);
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		if(!isVisible(iRequest))
			return;
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
			_xmlcollect_1_unb_Views[i].preRender(iRequest);
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(!isVisible(iRequest))
			return;
		PrintWriter iWriter = iResponse.getWriter();
		// --- open DIV
		iWriter.print("<div");
		if(_xmlattr_opt_ID != null)
		{
			iWriter.print(" id='");
			iWriter.print(_xmlattr_opt_ID);
			iWriter.print("'");
		}
		if(_xmlattr_opt_CssClass != null)
		{
			iWriter.print(" class='");
			iWriter.print(_xmlattr_opt_CssClass);
			iWriter.print("'");
		}
		iWriter.println(">");
		
		// --- render content
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
			_xmlcollect_1_unb_Views[i].render(iRequest, iResponse);
		
		// --- close DIV
		iWriter.println("</div>");
	}
}
