package com.ebm_ws.infra.bricks.components.base.html.menu;


import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Button implements IXmlObject, IMenuItem
{
	private String _xmlattr_opt_Target;
	private IMessage _xmlnode_req_Title;
	private IMessage _xmlnode_opt_Tooltip;
	private IImage _xmlnode_opt_Icon;
	private IAction _xmlnode_req_OnClick;
	private IBoolExpr _xmlnode_opt_Disabled;
	private IBoolExpr _xmlnode_opt_Visible;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    
	}
	private boolean isVisible(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Visible == null)
			return true;
		return _xmlnode_opt_Visible.eval(iRequest);
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse, ILinkHrefRenderer iLinkRenderer) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		if(!isVisible(iRequest))
			// --- do not render
			return;
		
		boolean rendererDisabled = (iLinkRenderer != null && !iLinkRenderer.isEnabled(iRequest));
		boolean disabled = rendererDisabled || (_xmlnode_opt_Disabled != null && _xmlnode_opt_Disabled.eval(iRequest));
		String iconSrc = _xmlnode_opt_Icon == null ? null : _xmlnode_opt_Icon.getImage(iRequest);
		
		String title = _xmlnode_req_Title.getMessage(iRequest);
		String tooltip = _xmlnode_opt_Tooltip == null ? null : _xmlnode_opt_Tooltip.getMessage(iRequest);
		
		iWriter.print("<li>");
		// --- open
		if(disabled)
		{
			iWriter.print("<span class='disabled'");
		}
		else
		{
			iWriter.print("<a");
			if(iLinkRenderer != null)
			{
				// --- the table has a form: let it render the link
				iLinkRenderer.renderHref(iRequest, iResponse, _xmlnode_req_OnClick.getURL(iRequest, true));
			}
			else
			{
				// --- render the href
				iWriter.print(" href='");
				iWriter.print(_xmlnode_req_OnClick.getURL(iRequest, true));
				iWriter.print("'");
			}
			if(_xmlattr_opt_Target != null)
			{
				iWriter.print(" target='");
				iWriter.print(_xmlattr_opt_Target);
				iWriter.print("'");
			}
		}
		// --- tooltip
		if(tooltip != null)
		{
			iWriter.print(" title='");
		    iWriter.print(HtmlUtils.encode2HTML(tooltip));
			iWriter.print("'");
		}
		iWriter.print(">");
		// --- icon
		if(iconSrc != null)
		{
			iWriter.print("<img src='");
			iWriter.print(iconSrc);
			iWriter.print("' alt='");
			if(tooltip != null)
				iWriter.print(HtmlUtils.encode2HTML(tooltip));
			iWriter.print("'/>");
		}
		// --- title
	    iWriter.print(HtmlUtils.encode2HTML(title));
		// --- close
	    if(disabled)
	    	iWriter.print("</span>");
	    else
	    	iWriter.print("</a>");

		iWriter.println("</li>");
	}
}
