package com.ebm_ws.infra.bricks.components.base.html.menu;


import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider.UnresolvedBeanError;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class DynamicButtons extends BaseBeanProvider implements IXmlObject, IMenuItem, IBeanProvider
{
	private String _xmlattr_opt_ItemBeanName = "$item";
	private IBinding _xmlnode_req_Items;
	private IMessage _xmlnode_req_Title;
	private IMessage _xmlnode_opt_Tooltip;
	private IImage _xmlnode_opt_Icon;
	private IAction _xmlnode_req_OnClick;
	private IBoolExpr _xmlnode_opt_Disabled;
	private IBoolExpr _xmlnode_opt_Visible;
	private Type itemType;
	private Class itemClass;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_Items != null && !_xmlnode_req_Items.hasErrors())
		{
			// --- check items is of vector type
			itemClass = ReflectionHelper.getVectorElementClass(_xmlnode_req_Items.getGenericType());
			itemType = ReflectionHelper.getVectorElementType(_xmlnode_req_Items.getGenericType());
			if(itemClass == null)
		    	iErrors.logMessage(this, "Items", IValidityLogger.ERROR, "Bound items must be vector data.");
		}
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse, ILinkHrefRenderer iLinkRenderer) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		
		List items = ReflectionHelper.obj2List(_xmlnode_req_Items.invoke(iRequest));
		if(items == null || items.isEmpty())
			// --- do not render
			return;
		
		boolean rendererDisabled = (iLinkRenderer != null && !iLinkRenderer.isEnabled(iRequest));
		for(int i=0; i<items.size(); i++)
		{
			// --- set contextual bean
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, items.get(i));
			
			// --- evaluate visibility
			boolean visible = _xmlnode_opt_Visible == null || _xmlnode_opt_Visible.eval(iRequest);
			if(!visible)
				// --- do not render button
				continue;
			
			// --- evaluate "enability"
			boolean disabled = rendererDisabled || (_xmlnode_opt_Disabled != null && _xmlnode_opt_Disabled.eval(iRequest));
			
			// --- retrieve icon
			String iconSrc = _xmlnode_opt_Icon == null ? null : _xmlnode_opt_Icon.getImage(iRequest);
			String title = _xmlnode_req_Title.getMessage(iRequest);
			String tooltip = _xmlnode_opt_Tooltip == null ? null : _xmlnode_opt_Tooltip.getMessage(iRequest);

			// --- render
			iWriter.print("<li>");
			
			// --- open
			if(disabled)
			{
				iWriter.print("<span class='disabled'");
			}
			else
			{
				iWriter.print("<a");
				if(iLinkRenderer != null)
				{
					// --- the table has a form: let it render the link
					iLinkRenderer.renderHref(iRequest, iResponse, _xmlnode_req_OnClick.getURL(iRequest, true));
				}
				else
				{
					// --- render the href
					iWriter.print(" href='");
					iWriter.print(_xmlnode_req_OnClick.getURL(iRequest, true));
					iWriter.print("'");
				}
			}
			// --- tooltip
			if(tooltip != null)
			{
				iWriter.print(" title='");
			    iWriter.print(HtmlUtils.encode2HTML(tooltip));
				iWriter.print("'");
			}
			iWriter.print(">");
			// --- icon
			if(iconSrc != null)
			{
				iWriter.print("<img src='");
				iWriter.print(iconSrc);
				iWriter.print("' alt='");
				if(tooltip != null)
					iWriter.print(HtmlUtils.encode2HTML(tooltip));
				iWriter.print("'/>");
			}
			// --- title
		    iWriter.print(HtmlUtils.encode2HTML(title));
			// --- close
		    if(disabled)
		    	iWriter.print("</span>");
		    else
		    	iWriter.print("</a>");
		
			iWriter.println("</li>");
		}
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			if(itemClass == null) throw new UnresolvedBeanError();
			return itemClass;
		}
		return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			if(itemType == null) throw new UnresolvedBeanError();
			return itemType;
		}
		return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
			return iRequest.getAttribute(iName);
		return getParentBeanValue(iRequest, iName);
	}
}
