package com.ebm_ws.infra.bricks.components.base.html.menu;


import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Menu implements IXmlObject, IView
{
	private String _xmlattr_opt_CssClass = "Menu";
	private IMessage _xmlnode_opt_Title;
	private IImage _xmlnode_opt_Icon;
	private IBoolExpr _xmlnode_opt_Visible;
	private IMenuItem[] _xmlnode_1_unb_Items;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    
	}
	public boolean isVisible(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Visible == null)
			return true;
		return _xmlnode_opt_Visible.eval(iRequest);
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		boolean visible = isVisible(iRequest);
		if(!visible)
			return;
		
		PrintWriter iWriter = iResponse.getWriter();
		// --- include JavaScript (for focus management)
		HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Menu.js");
		iWriter.print("<div class='");
		iWriter.print(_xmlattr_opt_CssClass);
		iWriter.print("'>");
		if(_xmlnode_opt_Title != null)
		{
//			iWriter.print("<span class='title'>");
			int hLevel = HeadingUtils.getLevel(iRequest);
			HeadingUtils.incrLevel(iRequest);
			iWriter.print("<h");
			iWriter.print(String.valueOf(hLevel));
			iWriter.print(" class='title'>");
			String title = _xmlnode_opt_Title.getMessage(iRequest);
			// --- retrieve icon
			String iconSrc = _xmlnode_opt_Icon == null ? null : _xmlnode_opt_Icon.getImage(iRequest);
			if(iconSrc != null)
			{
				iWriter.print("<img src='");
				iWriter.print(iconSrc);
				iWriter.print("' alt='");
				// empty alt is ok		    iWriter.print(HtmlUtils.encode2HTML(title, false));
				iWriter.print("'/>");
			}
			iWriter.print(HtmlUtils.encode2HTML(title));
//			iWriter.println("</span>");
			iWriter.print("</h");
			iWriter.print(String.valueOf(hLevel));
			iWriter.print(">");
		}
		
		iWriter.print("<ul>");
		for(int i=0; i<_xmlnode_1_unb_Items.length; i++)
		{
			_xmlnode_1_unb_Items[i].render(iRequest, iResponse, null);
		}
		iWriter.print("</ul>");
		
		// --- decrement heading level
		if(_xmlnode_opt_Title != null)
			HeadingUtils.decrLevel(iRequest);
		
		iWriter.println("</div>");
	}
}
