package com.ebm_ws.infra.bricks.components.base.html.menu;


import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class SubMenu implements IXmlObject, IMenuItem
{
	private String _xmlattr_opt_Target;
	private IMessage _xmlnode_req_Title;
	private IMessage _xmlnode_opt_Tooltip;
	private IImage _xmlnode_opt_Icon;
	private IAction _xmlnode_opt_OnClick;
	private IBoolExpr _xmlnode_opt_Disabled;
	private IMenuItem[] _xmlnode_1_unb_Items;
	private IBoolExpr _xmlnode_opt_Visible;
	private IBoolExpr _xmlnode_opt_ShowSubMenu;

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse, ILinkHrefRenderer iLinkRenderer) throws Exception
	{
		if(_xmlnode_opt_Visible != null && !_xmlnode_opt_Visible.eval(iRequest))
			// --- do not render
			return;
		
		String iconSrc = _xmlnode_opt_Icon == null ? null : _xmlnode_opt_Icon.getImage(iRequest);
		String title = _xmlnode_req_Title.getMessage(iRequest);
		String tooltip = _xmlnode_opt_Tooltip == null ? null : _xmlnode_opt_Tooltip.getMessage(iRequest);
		boolean rendererDisabled = (iLinkRenderer != null && !iLinkRenderer.isEnabled(iRequest));
		boolean isHyperLink = !rendererDisabled && _xmlnode_opt_OnClick != null && (_xmlnode_opt_Disabled == null || !_xmlnode_opt_Disabled.eval(iRequest));
		
		boolean showSubMenu = _xmlnode_opt_ShowSubMenu == null || _xmlnode_opt_ShowSubMenu.eval(iRequest);
		
		PrintWriter iWriter = iResponse.getWriter();
		iWriter.print("<li");
		if(showSubMenu) iWriter.print(" class=submenu");
		iWriter.print(">");
		
		if(isHyperLink || showSubMenu)
		{
			iWriter.print("<a");
			if(showSubMenu)
			{
				// --- make a submenu focussable
				iWriter.print(" class=submenu onfocus='Menu_focus(this)' onblur='Menu_blur(this)'");
			}
			if(isHyperLink)
			{
				if(iLinkRenderer != null)
				{
					// --- the table has a form: let it render the link
					iLinkRenderer.renderHref(iRequest, iResponse, _xmlnode_opt_OnClick.getURL(iRequest, true));
				}
				else
				{
					// --- render the href
					iWriter.print(" href='");
					iWriter.print(_xmlnode_opt_OnClick.getURL(iRequest, true));
					iWriter.print("'");
				}
				if(_xmlattr_opt_Target != null)
				{
					iWriter.print(" target='");
					iWriter.print(_xmlattr_opt_Target);
					iWriter.print("'");
				}
			}
			else
			{
				// --- pure sub-menu
				// Note: cannot use a span here as tabindex, onfocus and onblur are not allowed ==> doesn't validate!
				iWriter.print(" href='javascript:void(0)'");
			}
		}
		else
		{
			iWriter.print("<span class=disabled");
		}
		// --- tooltip
		if(tooltip != null)
		{
			iWriter.print(" title='");
		    iWriter.print(HtmlUtils.encode2HTML(tooltip));
			iWriter.print("'");
		}
		iWriter.print(">");
		// --- icon
		if(iconSrc != null)
		{
			iWriter.print("<img src='");
			iWriter.print(iconSrc);
			iWriter.print("' alt='");
			if(tooltip != null)
				iWriter.print(HtmlUtils.encode2HTML(tooltip));
			iWriter.print("'/>");
		}
		// --- title
	    iWriter.print(HtmlUtils.encode2HTML(title));
		// --- close
	    if(isHyperLink || showSubMenu)
	    	iWriter.print("</a>");
	    else
	    	iWriter.print("</span>");
		
		// --- render children items
	    if(showSubMenu)
	    {
	    	SubMenuLinkRenderer subMenuLinkRenderer = new SubMenuLinkRenderer(iLinkRenderer);
			iWriter.print("<ul>");
			for(int i=0; i<_xmlnode_1_unb_Items.length; i++)
			{
				_xmlnode_1_unb_Items[i].render(iRequest, iResponse, subMenuLinkRenderer);
			}
			iWriter.print("</ul>");
	    }
	    
		iWriter.println("</li>");
	}
	private static class SubMenuLinkRenderer implements ILinkHrefRenderer
	{
		private ILinkHrefRenderer parent;
		public SubMenuLinkRenderer(ILinkHrefRenderer parent)
		{
			this.parent = parent;
		}
		public boolean isEnabled(HttpServletRequest request)
		{
			return parent == null ? true : parent.isEnabled(request);
		}
		public void renderHref(HttpServletRequest request, HttpServletResponse response, String href) throws Exception
		{
			PrintWriter iWriter = response.getWriter();
			if(parent == null)
			{
				iWriter.print(" onfocus='Menu_focus(this)' onblur='Menu_blur(this)'");
				iWriter.print(" href='");
				iWriter.print(href);
				iWriter.print("'");
			}
			else
			{
				if(!(parent instanceof SubMenuLinkRenderer))
					iWriter.print(" onfocus='Menu_focus(this)' onblur='Menu_blur(this)'");
				
				parent.renderHref(request, response, href);
			}
		}
	}
}
