package com.ebm_ws.infra.bricks.components.base.html.tab;

import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.tab.TabPageRenderingContext.TabDef;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class DynamicTabs extends BaseBeanProvider implements IXmlObject, ITabs, IBeanProvider, IIdentifiable
{
	private TabPage _xmlancestor_TabPage;
	
	private String _xmlattr_opt_ItemBeanName = "$tab";
	private String _xmlattr_opt_CssClass;
	
	private IBinding _xmlnode_req_Items;
	private IBinding _xmlnode_req_ID;
	private IMessage _xmlnode_req_Title;
	private IImage _xmlnode_opt_Icon;
	private IBoolExpr _xmlnode_opt_Visible;
	private IView[] _xmlcollect_1_unb_Views;
	private IBinding[] _xmlnode_0_unb_OnPreRender;
	private Type itemType;
	private Class itemClass;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "DynTab_"+_xmlnode_req_ID.getID();
	}
	// --- [-] IIdentifiable implementation


	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_Items != null && !_xmlnode_req_Items.hasErrors())
		{
			// --- check items is of vector type
			itemClass = ReflectionHelper.getVectorElementClass(_xmlnode_req_Items.getGenericType());
			itemType = ReflectionHelper.getVectorElementType(_xmlnode_req_Items.getGenericType());
			if(itemClass == null)
		    	iErrors.logMessage(this, "Items", IValidityLogger.ERROR, "Bound items must be vector data.");
		}
	}
	private boolean isVisible(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Visible == null)
			return true;
		return _xmlnode_opt_Visible.eval(iRequest);
	}
	public void declareTabs(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception
	{
		List items = ReflectionHelper.obj2List(_xmlnode_req_Items.invoke(iRequest));
		if(items == null || items.isEmpty())
			// --- no tab
			return;
		for(int i=0; i<items.size(); i++)
		{
			// --- set contextual bean
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, items.get(i));
			
			// --- get ID
			String id = String.valueOf(_xmlnode_req_ID.invoke(iRequest));
			
			// --- evaluate visibility
			boolean visible = _xmlnode_opt_Visible == null || _xmlnode_opt_Visible.eval(iRequest);
			
			// --- evaluate "enability"
//			boolean disabled = _xmlnode_opt_Disabled != null && _xmlnode_opt_Disabled.eval(iRequest);
			boolean enabled = true;
			
			iContext.addTab(this, id, visible, enabled, items.get(i));
		}

	}
	public void preRender(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception
	{
		// --- set contextual bean
		iRequest.setAttribute(_xmlattr_opt_ItemBeanName, iContext.getSelectedTab().getAttached());
		
		// --- OnPreRender callback
		if(_xmlnode_0_unb_OnPreRender != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnPreRender.length; i++)
				_xmlnode_0_unb_OnPreRender[i].invoke(iRequest);
		}
		
		// --- pre render content
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
			_xmlcollect_1_unb_Views[i].preRender(iRequest);
	}
	public void renderTabs(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		
		List<TabDef> tabs = iContext.getTabsByProvider(this);
		for(int i=0; i<tabs.size(); i++)
		{
			TabDef renderingTab = tabs.get(i);
			
			if(!renderingTab.isVisible())
				continue;
			
			// --- set contextual bean
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, renderingTab.getAttached());
			
			String title = _xmlnode_req_Title.getMessage(iRequest);
			// --- retrieve icon
			String iconSrc = _xmlnode_opt_Icon == null ? null : _xmlnode_opt_Icon.getImage(iRequest);
	
			iWriter.print("<li");
			if(_xmlattr_opt_CssClass != null)
			{
				iWriter.print(" class='");
				iWriter.print(_xmlattr_opt_CssClass);
				iWriter.print("'");
			}
			iWriter.print(">");
			if(renderingTab.getId().equals(iContext.getSelectedTabId()))
			{
				// --- selected tab: use an Heading
//				iWriter.print("<span class='Selected'>");
				int hLevel = HeadingUtils.getLevel(iRequest);
				HeadingUtils.incrLevel(iRequest);
				iWriter.print("<h");
				iWriter.print(String.valueOf(hLevel));
				iWriter.print(" class='Selected'>");
				if(iconSrc != null)
				{
					iWriter.print("<img src='");
					iWriter.print(iconSrc);
					iWriter.print("' alt='");
					// empty alt is ok		    iWriter.print(HtmlUtils.encode2HTML(title, false));
					iWriter.print("'/>");
				}
				iWriter.print(HtmlUtils.encode2HTML(title));
//				iWriter.print("</span>");
				iWriter.print("</h");
				iWriter.print(String.valueOf(hLevel));
				iWriter.print(">");
			}
			else if(!renderingTab.isEnabled())
			{
				iWriter.print("<span class='Disabled'>");
				if(iconSrc != null)
				{
					iWriter.print("<img src='");
					iWriter.print(iconSrc);
					iWriter.print("' alt='");
					// empty alt is ok		    iWriter.print(HtmlUtils.encode2HTML(title, false));
					iWriter.print("'/>");
				}
				iWriter.print(HtmlUtils.encode2HTML(title));
				iWriter.print("</span>");
			}
			else
			{
				iWriter.print("<a href='");
				UrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
				url.setParameter(iContext.getTabParamName(), renderingTab.getId());
				iWriter.print(url.toUrl(iRequest.getCharacterEncoding(), true));
				iWriter.print("'>");
				if(iconSrc != null)
				{
					iWriter.print("<img src='");
					iWriter.print(iconSrc);
					iWriter.print("' alt='");
					// empty alt is ok		    iWriter.print(HtmlUtils.encode2HTML(title, false));
					iWriter.print("'/>");
				}
				iWriter.print(HtmlUtils.encode2HTML(title));
				iWriter.print("</a>");
			}
			iWriter.println("</li>");
		}
	}
	public void renderContent(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception
	{
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
		{
			_xmlcollect_1_unb_Views[i].render(iRequest, iResponse);
		}
		// --- decrement heading level
		HeadingUtils.decrLevel(iRequest);
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			if(itemClass == null) throw new UnresolvedBeanError();
			return itemClass;
		}
		return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			if(itemType == null) throw new UnresolvedBeanError();
			return itemType;
		}
		return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
			return iRequest.getAttribute(iName);
		return getParentBeanValue(iRequest, iName);
	}
}
