package com.ebm_ws.infra.bricks.components.base.html.tab;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.tab.TabPageRenderingContext.TabDef;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Tab implements IXmlObject, ITabs, IIdentifiable
{
	private String _xmlattr_req_ID;
	private String _xmlattr_opt_CssClass;
	
	private TabPage _xmlancestor_TabPage;
	private IMessage _xmlnode_req_Title;
	private IImage _xmlnode_opt_Icon;
	private IBoolExpr _xmlnode_opt_Visible;
	private IView[] _xmlcollect_1_unb_Views;
	private IBinding[] _xmlnode_0_unb_OnPreRender;

	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Tab_"+_xmlattr_req_ID;
	}
	// --- [-] IIdentifiable implementation

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	}
	private boolean isVisible(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Visible == null)
			return true;
		return _xmlnode_opt_Visible.eval(iRequest);
	}
	public void declareTabs(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception
	{
		iContext.addTab(this, _xmlattr_req_ID, isVisible(iRequest), true, null);
	}
	public void preRender(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception
	{
		// --- OnPreRender callback
		if(_xmlnode_0_unb_OnPreRender != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnPreRender.length; i++)
				_xmlnode_0_unb_OnPreRender[i].invoke(iRequest);
		}
		
		// --- pre render content
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
			_xmlcollect_1_unb_Views[i].preRender(iRequest);
	}
	public void renderTabs(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception
	{
		TabDef renderingTab = iContext.getTab(_xmlattr_req_ID);
		if(!renderingTab.isVisible())
			return;

		String title = _xmlnode_req_Title.getMessage(iRequest);
		String iconSrc = _xmlnode_opt_Icon == null ? null : _xmlnode_opt_Icon.getImage(iRequest);

		PrintWriter iWriter = iResponse.getWriter();
		iWriter.print("<li");
		if(_xmlattr_opt_CssClass != null)
		{
			iWriter.print(" class='");
			iWriter.print(_xmlattr_opt_CssClass);
			iWriter.print("'");
		}
		iWriter.print(">");
		if(renderingTab.getId().equals(iContext.getSelectedTabId()))
		{
//			iWriter.print("<span class='Selected'>");
			int hLevel = HeadingUtils.getLevel(iRequest);
			HeadingUtils.incrLevel(iRequest);
			iWriter.print("<h");
			iWriter.print(String.valueOf(hLevel));
			iWriter.print(" class='Selected'>");
			if(iconSrc != null)
			{
				iWriter.print("<img src='");
				iWriter.print(iconSrc);
				iWriter.print("' alt='");
				// empty alt is ok		    iWriter.print(HtmlUtils.encode2HTML(title, false));
				iWriter.print("'/>");
			}
			iWriter.print(HtmlUtils.encode2HTML(title));
//			iWriter.print("</span>");
			iWriter.print("</h");
			iWriter.print(String.valueOf(hLevel));
			iWriter.print(">");
		}
		else if(!renderingTab.isEnabled())
		{
			iWriter.print("<span class='Disabled'>");
			if(iconSrc != null)
			{
				iWriter.print("<img src='");
				iWriter.print(iconSrc);
				iWriter.print("' alt='");
				// empty alt is ok		    iWriter.print(HtmlUtils.encode2HTML(title, false));
				iWriter.print("'/>");
			}
			iWriter.print(HtmlUtils.encode2HTML(title));
			iWriter.print("</span>");
		}
		else
		{
			iWriter.print("<a href='");
			UrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
			url.setParameter(iContext.getTabParamName(), renderingTab.getId());
			iWriter.print(url.toUrl(iRequest.getCharacterEncoding(), true));
			iWriter.print("'>");
			if(iconSrc != null)
			{
				iWriter.print("<img src='");
				iWriter.print(iconSrc);
				iWriter.print("' alt='");
				// empty alt is ok		    iWriter.print(HtmlUtils.encode2HTML(title, false));
				iWriter.print("'/>");
			}
			iWriter.print(HtmlUtils.encode2HTML(title));
			iWriter.print("</a>");
		}
		iWriter.println("</li>");
	}
	public void renderContent(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception
	{
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
		{
			_xmlcollect_1_unb_Views[i].render(iRequest, iResponse);
		}
		// --- decrement heading level
		HeadingUtils.decrLevel(iRequest);
	}
}
