package com.ebm_ws.infra.bricks.components.base.html.tab;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.tab.TabPageRenderingContext.TabDef;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.RenderingContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;


public class TabPage implements IXmlObject, IView, IIdentifiable
{
	private IPage _xmlancestor_Page;
	
	private String _xmlattr_req_ID;
	private String _xmlattr_opt_CssClass = "Tab";
	private ITabs[] _xmlcollect_1_unb_Tabs;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "TabPage_"+_xmlattr_req_ID;
	}
	// --- [-] IIdentifiable implementation

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    
	}
	/*
	private int getTabIndex(String iID)
	{
		if(_xmlcollect_1_unb_Tabs == null)
			return -1;
		for(int i=0; i<_xmlcollect_1_unb_Tabs.length; i++)
		{
			if(iID.equals(_xmlcollect_1_unb_Tabs[i].getID()))
				return i;
		}
		return -1;
	}
	*/
	public String getID()
	{
	    return _xmlattr_req_ID;
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		// --- prepare tabpage rendering context
		// --- tab param name starts with underscore for a frame tabpage
		String tabParamName = _xmlancestor_Page == null ? "_tab_"+getID() : "tab_"+getID();
		TabPageRenderingContext context = new TabPageRenderingContext(tabParamName);
		for(int i=0; i<_xmlcollect_1_unb_Tabs.length; i++)
		{
			_xmlcollect_1_unb_Tabs[i].declareTabs(iRequest, context);
		}
		// --- find selected tab
		TabDef selectedTab = null;
		String reqTabId = iRequest.getParameter(tabParamName);
		if(reqTabId == null && _xmlancestor_Page == null)
		{
			// --- for a frame tabpage, retrieve selected tab from session
			reqTabId = (String)BricksSession.getSession(iRequest).getAttribute(tabParamName);
		}
		if(reqTabId != null)
		{
			selectedTab = context.getTab(reqTabId);
			if(!selectedTab.isVisible() || !selectedTab.isEnabled())
				selectedTab = null;
		}
		if(selectedTab == null)
		{
			// --- no tab specified: show the first available
			selectedTab = context.getFirstDisplayableTab();
		}
		
		// --- pre render selected tab
		if(selectedTab != null)
		{
			// --- for a frame tabpage, store selected tab in session
			if(_xmlancestor_Page == null)
			{
				BricksSession.getSession(iRequest).setAttribute(tabParamName, selectedTab.getId());
			}

			// --- put rendering context in request
//			iRequest.setAttribute("tabctx_"+getID(), context);
			context.setSelectedTab(selectedTab);
			selectedTab.getProvider().preRender(iRequest, context);
		}
		RenderingContext.get(iRequest).put(this, "context", context);
	}
	/*
	public TabPageRenderingContext getRenderingContext(HttpServletRequest iRequest)
	{
		return (TabPageRenderingContext)iRequest.getAttribute("tabctx_"+getID());
	}
	*/
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		TabPageRenderingContext context = (TabPageRenderingContext)RenderingContext.get(iRequest).get(this, "context");
		if(!context.hasVisibleTabs())
			return;
		
		PrintWriter iWriter = iResponse.getWriter();
		iWriter.println("<div id='"+getID()+"' class='"+_xmlattr_opt_CssClass+"'>");
		iWriter.println("<ul>");
//		while(tabs.hasMoreElements())
		for(int i=0; i<_xmlcollect_1_unb_Tabs.length; i++)
		{
			_xmlcollect_1_unb_Tabs[i].renderTabs(iRequest, iResponse, context);
		}
		iWriter.println("</ul>");
		iWriter.println("</div>");
		
		// --- render content
		if(context.getSelectedTab() != null)
		{
			iWriter.println("<div class='"+_xmlattr_opt_CssClass+"Content'>");
			context.getSelectedTab().getProvider().renderContent(iRequest, iResponse, context);
			iWriter.println("</div>");
		}
	}
}
