package com.ebm_ws.infra.bricks.components.base.html.tab;

import java.util.ArrayList;
import java.util.List;

public class TabPageRenderingContext
{
	private List<TabDef> tabs = new ArrayList<TabDef>();
	private TabDef selectedTab;
	private String tabParamName;
	
	public TabPageRenderingContext(String tabParamName)
	{
		this.tabParamName = tabParamName;
	}
	public String getTabParamName()
	{
		return tabParamName;
	}
	/**
	 * Returns the selected tab id
	 */
	public String getSelectedTabId()
    {
		if(selectedTab == null)
			return null;
    	return selectedTab.getId();
    }
	/**
	 * Returns the selected tab defintion
	 */
	public TabDef getSelectedTab()
    {
    	return selectedTab;
    }
	/**
	 * Defines the selected tab
	 */
	public void setSelectedTab(TabDef selectedTab)
    {
    	this.selectedTab = selectedTab;
    }
	/**
	 * Determines whether the tab page has visible tabs
	 */
	public boolean hasVisibleTabs()
	{
		for(int i=0; i<tabs.size(); i++)
		{
			TabDef tab = tabs.get(i);
			if(tab.isVisible())
				return true;
		}
		return false;
	}
	/**
	 * Declares a new tab to the tab page context
	 * @param provider
	 * @param id
	 * @param visible
	 * @param enabled
	 * @param attached
	 */
	public void addTab(ITabs provider, String id, boolean visible, boolean enabled, Object attached)
	{
		tabs.add(new TabDef(provider, id, visible, enabled, attached));
	}
	/**
	 * Returns all tabs declared by the given provider
	 * @param iProvider
	 * @return
	 */
	public List<TabDef> getTabsByProvider(ITabs iProvider)
	{
		List<TabDef> ret = new ArrayList<TabDef>();
		for(int i=0; i<tabs.size(); i++)
		{
			if(tabs.get(i).getProvider() == iProvider)
				ret.add(tabs.get(i));
		}
		return ret;
	}
	/**
	 * Returns the tab definition from its id
	 * @param id
	 * @return
	 */
	public TabDef getTab(String id)
	{
		for(int i=0; i<tabs.size(); i++)
		{
			if(tabs.get(i).getId().equals(id))
				return tabs.get(i);
		}
		return null;
	}
	/**
	 * Returns the first displayable tab.
	 * @return
	 */
	public TabDef getFirstDisplayableTab()
	{
		for(int i=0; i<tabs.size(); i++)
		{
			TabDef tab = tabs.get(i);
			if(tab.isEnabled() && tab.isVisible())
				return tabs.get(i);
		}
		return null;
	}
	// ================================================================
	// === Tab Definition
	// ================================================================
	public static class TabDef
	{
		private ITabs provider;
		private String id;
		private boolean visible;
		private boolean enabled;
		private Object attached;
		
		public TabDef(ITabs provider, String id, boolean visible, boolean enabled, Object attached)
		{
			this.provider = provider;
			this.id = id;
			this.visible = visible;
			this.enabled = enabled;
			this.attached = attached;
		}
		public Object getAttached()
		{
			return attached;
		}
		public ITabs getProvider()
		{
			return provider;
		}

		public boolean isEnabled()
        {
        	return enabled;
        }

		public String getId()
        {
        	return id;
        }

		public boolean isVisible()
        {
        	return visible;
        }
	}
}
