package com.ebm_ws.infra.bricks.components.base.html.table;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.enums.Alignment;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.table.TableRenderingContext;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public abstract class BaseColumn implements IColumn, IXmlObject
{
	private Table _xmlancestor_Table;
	
	private Alignment _xmlattr_opt_Alignment = Alignment.Left;
	
	private IMessage _xmlnode_req_Title;
	private ISorter _xmlnode_opt_Sort;
	private IFilter _xmlnode_opt_Filter;
	private IBoolExpr _xmlnode_opt_Visible;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    
	}
	public Alignment getAligment()
	{
		return _xmlattr_opt_Alignment;
	}
	public boolean isVisible(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Visible == null)
			return true;
		return _xmlnode_opt_Visible.eval(iRequest);
	}
	public IFilter getFilter()
	{
	    return _xmlnode_opt_Filter;
	}
	public ISorter getSorter()
	{
	    return _xmlnode_opt_Sort;
	}
	public String getTitle(HttpServletRequest iRequest)
	{
		return _xmlnode_req_Title.getMessage(iRequest);
	}
	public void renderHeader(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, ILinkHrefRenderer iLinkRenderer, int icol) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		writer.print("<th");
		// --- id
		/* no: use scope instead
		writer.print(" id='");
		writer.print(_xmlancestor_Table.getID());
		writer.print(String.valueOf(icol));
		writer.print("'");
		*/
		writer.print(" scope=col");
		
		// --- alignment
		if(getAligment() == Alignment.Left)
			writer.print(" align=left");
		else if(getAligment() == Alignment.Right)
			writer.print(" align=right");
		else if(getAligment() == Alignment.Center)
			writer.print(" align=center");
		writer.print(">");
		if(getSorter() != null)
		{
			int sortcol = icol+1;
			if(icol == context.getSortColumn() && context.getSortDirection())
				// click sorts descendingly
				sortcol = -sortcol;
			UrlBuilder sorturl = BricksUrlBuilder.copyFromRequest(iRequest, true);
			// go back to first page
//			sorturl.setParameter(_xmlancestor_Table.getID()+".page", "0");
			sorturl.removeParameter(_xmlancestor_Table.getID()+".page");
			sorturl.setParameter(_xmlancestor_Table.getID()+".sort", String.valueOf(sortcol));
			
			writer.print("<a");
			if(iLinkRenderer != null)
			{
				// --- the table has a form: let it render the link
				iLinkRenderer.renderHref(iRequest, iResponse, sorturl.toUrl(iRequest.getCharacterEncoding(), true));
			}
			else
			{
				// --- render the href
				writer.print(" href='");
				writer.print(sorturl.toUrl(iRequest.getCharacterEncoding(), true));
				writer.print("'");
			}
			
//			BricksSession session = BricksSession.getSession(iRequest);
			writer.print(" title='");
			if(sortcol < 0)
				writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.sortdesc")));
			else
				writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.sortasc")));
			writer.print("'");
			
			if(context.getSortColumn() == icol)
			{
				// --- this column is sorted...
				if(context.getSortDirection())
					// --- ... ascendingly
					writer.print(" class='sortedasc'");
				else
					// --- ... descendingly
					writer.print(" class='sorteddesc'");
			}
			
			writer.print(">");
		}
		else
			writer.print("<span>");
		
		// --- column title
		writer.print(HtmlUtils.encode2HTML(_xmlnode_req_Title.getMessage(iRequest)));
		
		if(getSorter() != null)
			writer.print("</a>");
		else
			writer.print("</span>");
		
		if(_xmlnode_opt_Filter != null)
		{
			writer.print("<div class=filter>");
			getFilter().render(iRequest, iResponse, context, iLinkRenderer, icol);
			writer.print("</div>");
		}
		
		writer.println("</th>");
	}

	public void renderCell(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		writer.print("<td");
		
		// --- headers
		/* no: use scope instead
		writer.print(" headers='");
		writer.print(_xmlancestor_Table.getID());
		writer.print(String.valueOf(icol));
		writer.print("'");
		*/
		
		// --- alignment
		if(getAligment() == Alignment.Right)
			writer.print(" align=right");
		else if(getAligment() == Alignment.Center)
			writer.print(" align=center");
		writer.print(">");
		
		// --- render cell content
		renderCellContent(iRequest, iResponse, icol, iRowObject);
		
		writer.println("</td>");
	}
}
