package com.ebm_ws.infra.bricks.components.base.html.table;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.DateType;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;

public class DateColumn extends BaseColumn
{
	private DateType _xmlattr_opt_Type = DateType.DateOnly;
	private IBinding _xmlnode_req_Date;
	
	@Override
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    super.checkThisNode(iValidSupport, iErrors);
	    
	    if(_xmlnode_req_Date != null && !_xmlnode_req_Date.hasErrors())
	    {
	    	if(!ReflectionHelper.isDate(_xmlnode_req_Date.getType()))
	    		iErrors.logMessage(this, "Date", IValidityLogger.ERROR, "The Date binding has to return a value of type java.util.Date or java.util.Calendar");
    	}
	}
	public Object getCellValue(HttpServletRequest iRequest, Object iRowObject) throws Exception
	{
		return ReflectionHelper.obj2Date(_xmlnode_req_Date.invoke(iRequest));
	}
	public String getCellText(HttpServletRequest iRequest, Object iRowObject) throws Exception
	{
		Date date = ReflectionHelper.obj2Date(_xmlnode_req_Date.invoke(iRequest));
		if(date == null)
			return null;
		BricksSession session = BricksSession.getSession(iRequest);
		DateFormat format = DateType.getOutputFormat(session.getLocaleConfig(), _xmlattr_opt_Type);
		return format.format(date);
	}
	public void renderCellContent(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		Date date = ReflectionHelper.obj2Date(_xmlnode_req_Date.invoke(iRequest));
		if(date == null)
		{
			// --- empty cell
			writer.print("&nbsp;");
			return;
		}
		
		BricksSession session = BricksSession.getSession(iRequest);
		DateFormat format = DateType.getOutputFormat(session.getLocaleConfig(), _xmlattr_opt_Type);
		writer.print(HtmlUtils.encode2HTML(format.format(date)));
	}
	public Class getCellType()
	{
		if(_xmlnode_req_Date == null)
			return null;
	    return _xmlnode_req_Date.getType();
	}
}
