package com.ebm_ws.infra.bricks.components.base.html.table;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.table.TableRenderingContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlSubstitutionGroup;

public interface IColumn extends IXmlSubstitutionGroup, IXmlObject
{
	boolean isVisible(HttpServletRequest iRequest);
	
	ISorter getSorter();
	
	IFilter getFilter();
	
	String getTitle(HttpServletRequest iRequest);
	
	void renderHeader(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, ILinkHrefRenderer iLinkRenderer, int icol) throws Exception;

//	void renderFilterCell(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, ILinkHrefRenderer iLinkRenderer, int icol) throws Exception;

	void renderCell(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception;
	
	void renderCellContent(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception;

	/**
	 * Used by some IFilter to retrieve the cell message
	 * @param iRequest
	 * @param iRowObject
	 * @return
	 * @throws Exception
	 */
	String getCellText(HttpServletRequest iRequest, Object iRowObject) throws Exception;
	
	/**
	 * Used by IFilter and ISorter to get the internal cell value
	 * @param iRequest
	 * @param iRowObject
	 * @return
	 * @throws Exception
	 */
	Object getCellValue(HttpServletRequest iRequest, Object iRowObject) throws Exception;
	
	Class getCellType();
}
