package com.ebm_ws.infra.bricks.components.base.html.table;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class SelectionBindings implements IXmlObject
{
	protected IBinding _xmlnode_req_RowID;
	protected IBinding _xmlnode_req_SelectedIDs;
//	protected IBinding _xmlnode_opt_SelectAll;
	
	private Class _idType;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_RowID != null && !_xmlnode_req_RowID.hasErrors())
		{
			_idType = _xmlnode_req_RowID.getType();
			if(String.class != _idType && Integer.class != _idType && int.class != _idType)
				iErrors.logMessage(this, "RowID", IValidityLogger.ERROR, "Row IDs must be either String, Integer or int.");
		}
		if(_xmlnode_req_SelectedIDs != null && !_xmlnode_req_SelectedIDs.hasErrors())
		{
			Class selectedIdType = ReflectionHelper.getVectorElementClass(_xmlnode_req_SelectedIDs.getGenericType());
			if(String.class != selectedIdType && Integer.class != selectedIdType && int.class != selectedIdType)
				iErrors.logMessage(this, "SelectedIDs", IValidityLogger.ERROR, "Selected IDs must be either String, Integer or int.");
			else if(_idType != null && _idType != selectedIdType)
				iErrors.logMessage(this, "SelectedIDs", IValidityLogger.ERROR, "Selected IDs type doesn't match row ID type.");
			
			if(!_xmlnode_req_SelectedIDs.isGetSet())
				iErrors.logMessage(this, "SelectedIDs", IValidityLogger.ERROR, "Selected IDs binding cannot be set.");
		}
		/*
		if(_xmlnode_opt_SelectAll != null && !_xmlnode_opt_SelectAll.hasErrors())
		{
			Class selectAllType = _xmlnode_opt_SelectAll.getType();
			if(Boolean.class != selectAllType && boolean.class != selectAllType)
				iErrors.logMessage(this, "SelectAll", IValidityLogger.ERROR, "SelectAll binding must be of type Boolean or boolean.");
			if(!_xmlnode_opt_SelectAll.isGetSet())
				iErrors.logMessage(this, "SelectAll", IValidityLogger.ERROR, "SelectAll binding cannot be set.");
		}
		*/
	}
	public Class getIDType()
	{
		return _idType;
	}
}
