package com.ebm_ws.infra.bricks.components.base.html.table;

import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.TableStyle;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.util.RenderingContext;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Table extends BaseBeanProvider implements IView, IXmlObject, IIdentifiable, IBeanProvider, ILinkHrefRenderer
{
	private Application _xmlroot;
	
	private String _xmlattr_req_ID;
	private String _xmlattr_opt_CssClass = "Table";
	private boolean _xmlattr_opt_SortAndPaginateLocaly = false;
	private String _xmlattr_opt_RowBeanName = "$row";
	private TableStyle _xmlattr_opt_Style = TableStyle.Table;

	private IMessage _xmlnode_opt_Title;
	private IBinding _xmlnode_opt_ResultsPerPage;
	private IBinding _xmlnode_req_RowsData;
	private SelectionBindings _xmlnode_opt_Selection;
	private IView[] _xmlnode_0_unb_DetailsView;
	private IMenuItem[] _xmlnode_0_unb_Toolbar;
	private IColumn[] _xmlnode_1_unb_Columns;
	
	private Class _itemClass;
	private Type _itemType;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Table_"+_xmlattr_req_ID;
	}
	// --- [-] IIdentifiable implementation

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_opt_ResultsPerPage != null && !_xmlnode_opt_ResultsPerPage.hasErrors())
		{
			if(!int.class.isAssignableFrom(_xmlnode_opt_ResultsPerPage.getType()) && !Integer.class.isAssignableFrom(_xmlnode_opt_ResultsPerPage.getType()))
		    	iErrors.logMessage(this, "ResultsPerPage", IValidityLogger.ERROR, "ResultsPerPage binding must return either an int or Integer.");
		}
		if(_xmlnode_req_RowsData != null && !_xmlnode_req_RowsData.hasErrors())
		{
			_itemType = ReflectionHelper.getVectorElementType(_xmlnode_req_RowsData.getGenericType());
			_itemClass = ReflectionHelper.getVectorElementClass(_xmlnode_req_RowsData.getGenericType());
			if(_itemClass == null)
				iErrors.logMessage(this, "Data", IValidityLogger.ERROR, "Data binding is not of vector type.");
		}
		if(_xmlattr_opt_SortAndPaginateLocaly)
			iErrors.logMessage(this, "SortAndPaginateLocaly", IValidityLogger.INFO, "Have table handle sort and pagination localy may overwhelm server resources.");
		
		// --- register this component as a request handler
	    if(_xmlroot.registerRequestHandler(getPathID(), this) != null)
        	iErrors.logMessage(this, "ID", IValidityLogger.INFO, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
	}
	public String getID()
	{
	    return _xmlattr_req_ID;
	}
	public String getFormName()
	{
	    return "form."+_xmlattr_req_ID;
	}
	public String getRowBeanName()
	{
		return _xmlattr_opt_RowBeanName;
	}
	public IColumn[] getColumns()
	{
		return _xmlnode_1_unb_Columns;
	}
	public void submit(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		// --- manage selection, filtering and toolbar actions
		if(_xmlnode_opt_Selection != null)
		{
			// --- update selection
			String[] values = iRequest.getParameterValues("selection");
			if(values == null)
				values = new String[0];
			
			List selection = new ArrayList();
			if(ReflectionHelper.isIntegerLike(_xmlnode_opt_Selection.getIDType()))
			{
				for(int i=0; i<values.length; i++)
					selection.add(ReflectionHelper.parse2Type(values[i], _xmlnode_opt_Selection.getIDType()));
			}
			else
			{
				for(int i=0; i<values.length; i++)
					selection.add(values[i]);
			}
			// --- now set the new selection (invoke binding)
			_xmlnode_opt_Selection._xmlnode_req_SelectedIDs.setValue(iRequest, ReflectionHelper.vect2obj(selection, _xmlnode_opt_Selection._xmlnode_req_SelectedIDs.getType()));
		}
		
		// --- filter, sort, navigation will be taken into account in the rendering
		
		// --- now redirect to the requested action if any
		String redirectUrl = iRequest.getParameter("redirect_href");
		if(redirectUrl != null && redirectUrl.length() > 0)
		{
			// --- redirect
			iResponse.sendRedirect(redirectUrl);
			return;
		}
		
		// --- no redirection url passed: redirect to this page
		BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
		
		// --- reinject filter values
		for(int i=0; i<_xmlnode_1_unb_Columns.length; i++)
		{
			if(_xmlnode_1_unb_Columns[i].getFilter() != null)
			{
				String filterParam = getID()+".filter."+i;
				String filter = iRequest.getParameter(filterParam);
				if(filter != null)
					filter = filter.trim();
					// TODO: have each filter manage its own parameters
				if(filter != null && filter.length() > 0)
					url.setParameter(filterParam, filter);
				else
					url.removeParameter(filterParam);
			}
		}
		iResponse.sendRedirect(url.toUrl(iResponse.getCharacterEncoding(), false));
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		// --- evaluate context and place in request
		TableRenderingContextImpl context = new TableRenderingContextImpl();
		
		// --- eval columns visibility
		context.columnsVisibility = new boolean[_xmlnode_1_unb_Columns.length];
		context.columnsCount = 0;
		for(int i=0; i<_xmlnode_1_unb_Columns.length; i++)
		{
			context.columnsVisibility[i] = _xmlnode_1_unb_Columns[i].isVisible(iRequest);
			if(context.columnsVisibility[i])
				context.columnsCount++;
		}
		
		// --- set columns
		context.columns = _xmlnode_1_unb_Columns;
		
		// --- rows per page
		if(_xmlnode_opt_ResultsPerPage != null)
			context.setRowsPerPage(((Integer)_xmlnode_opt_ResultsPerPage.invoke(iRequest)).intValue());
		
		// --- current page
		if(context.getRowsPerPage() != Integer.MAX_VALUE)
		{
			// --- pagination
			String pageStr = iRequest.getParameter(_xmlattr_req_ID+".page");
			if(pageStr != null)
				context.setPage(Integer.parseInt(pageStr));
		}
		
		// --- sort options
		String sort = iRequest.getParameter(_xmlattr_req_ID+".sort");
		if(sort != null)
		{
			int sortColAndDir = Integer.parseInt(sort);
			context.sortColumn = Math.abs(sortColAndDir)-1;
			context.sortDirection = sortColAndDir > 0;
		}
		
		// --- filters
		for(int i=0; i<_xmlnode_1_unb_Columns.length; i++)
		{
			if(!context.columnsVisibility[i])
				continue;
			if(_xmlnode_1_unb_Columns[i].getFilter() != null)
			{
				context.hasFilters = true;
				// TODO: let filters manage their own parameters (like in Form)
				String filter = iRequest.getParameter(getID()+".filter."+i);
				if(filter != null)
				{
					filter = filter.trim();
					if(filter.length() > 0)
					{
						// --- add filter
						if(context.columnFilters == null)
							context.columnFilters = new String[_xmlnode_1_unb_Columns.length];
						context.columnFilters[i] = filter;
					}
				}
			}
		}
		
		// --- place rendering context in request
		iRequest.setAttribute("$context", context);
		
		// --- retrieve data
		List data = ReflectionHelper.obj2List(_xmlnode_req_RowsData.invoke(iRequest));
		if(_xmlattr_opt_SortAndPaginateLocaly)
			data = sortAndPaginate(iRequest, data, context);
		
		// --- pre render expanded row
		if(_xmlnode_0_unb_DetailsView != null && _xmlnode_0_unb_DetailsView.length > 0)
		{
			String exp = iRequest.getParameter("_"+_xmlattr_req_ID+".exp");
			if(exp != null)
			{
				int expanded = Integer.parseInt(exp);
				iRequest.setAttribute(_xmlattr_opt_RowBeanName, data.get(expanded));
				for(int i=0; i<_xmlnode_0_unb_DetailsView.length; i++)
					_xmlnode_0_unb_DetailsView[i].preRender(iRequest);
			}
		}
		
		// --- remove rendering context
		iRequest.removeAttribute("$context");
		
		RenderingContext.get(iRequest).put(this, "ctx", context);
		if(data != null)
			RenderingContext.get(iRequest).put(this, "data", data);
	}

	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		List data = (List)RenderingContext.get(iRequest).get(this, "data");
		TableRenderingContextImpl context = (TableRenderingContextImpl)RenderingContext.get(iRequest).get(this, "ctx");
		// --- place rendering context in request
		iRequest.setAttribute("$context", context);

//		BricksSession session = BricksSession.getSession(iRequest);
		
		// --- precompute some information
		boolean hasNavigationBar = false;
		int nbOfPages = 0;
		if(context.rowsCount >= 0)
		{
			// --- we know row count
			nbOfPages = (context.rowsCount - 1) / context.getRowsPerPage() + 1;
		}
		else
		{
			// --- we don't know the total number of rows: next link is displayed only if the current page is full
			nbOfPages = context.getPage()+1;
			if(data != null && data.size() >= context.getRowsPerPage())
				// --- there's a next page
				nbOfPages++;
		}
		if(nbOfPages > 1)
			hasNavigationBar = true;

		int nbRowsDisplayed = data == null ? 0 : data.size();
		if(context.getRowsPerPage() > 0 && nbRowsDisplayed > context.getRowsPerPage())
			nbRowsDisplayed = context.getRowsPerPage();
		
		int nbToolCols = 0;
		int nbColsDisplayed = context.columnsCount;
		if(_xmlnode_0_unb_DetailsView != null)
			nbToolCols++;
		if(_xmlnode_opt_Selection != null)
			nbToolCols++;
		
		boolean hasForm = false;
		if(_xmlnode_opt_Selection != null)
			hasForm = true;
		if(context.hasFilters())
			hasForm = true;

		// --- retrieve selection (if any)
		List selectedIds = null;
		if(_xmlnode_opt_Selection != null)
		{
			selectedIds = ReflectionHelper.obj2List(_xmlnode_opt_Selection._xmlnode_req_SelectedIDs.invoke(iRequest));
			// --- make a copy of this list as we will touch it
			if(selectedIds != null)
				selectedIds = new ArrayList(selectedIds);
		}
		
		// --- retrieve expanded rows (if any)
		int expanded = -1;
		if(_xmlnode_0_unb_DetailsView != null)
		{
			String exp = iRequest.getParameter("_"+_xmlattr_req_ID+".exp");
			if(exp != null)
				expanded = Integer.parseInt(exp);
		}
		
		// --- Render
		PrintWriter writer = iResponse.getWriter();
		
		if(hasForm)
		{
			// --- put the table in a form
			HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Table.js");
			
			writer.print("<form name='"+getFormName()+"' method='post' action='");
//			iWriter.print(_xmlroot.createHandlerUrl(iRequest, this, "submit").toUrl(iRequest.getCharacterEncoding(), true));
			UrlBuilder formActionUrl = BricksUrlBuilder.copyFromRequest(iRequest, true);
			// --- remove page parameter (on filter value submitted)
//			formActionUrl.setParameter(_xmlancestor_Table.getID()+".page", "0");
			formActionUrl.removeParameter(getID()+".page");
			// --- remove filters from action url (posted as input value)
			for(int i=0; i<_xmlnode_1_unb_Columns.length; i++)
			{
				if(_xmlnode_1_unb_Columns[i].getFilter() != null)
					formActionUrl.removeParameter(getID()+".filter."+i);
			}
			writer.print(formActionUrl.toUrl(iRequest.getCharacterEncoding(), true));
			writer.println("'>");
			writer.print("<input type='hidden' name='");
			writer.print(_xmlroot.getHandlerParamName());
			writer.print("'");
			writer.print(" value='");
			writer.print(_xmlroot.getHandlerParamValue(this, "submit"));
			writer.print("'");
			writer.println("/>");
			
			writer.println("<input type='hidden' name='redirect_href'/>");
		}
		
		writer.print("<table class='");
		writer.print(_xmlattr_opt_CssClass);
		writer.print("'");
		writer.print(" id='");
		writer.print(_xmlattr_req_ID);
		writer.println("'>");
		
		// --- title
		if(_xmlnode_opt_Title != null)
		{
			// --- render into the table caption
			writer.print("<caption>");
			writer.print(HtmlUtils.encode2HTML(_xmlnode_opt_Title.getMessage(iRequest)));
			writer.println("</caption>");
		}
		
		// --- render table header (navigation, toolbar, column headers, filters)
		// -----------------------
		writer.println("<thead>");
		
		// --- render toolbar
		if(_xmlnode_0_unb_Toolbar != null)
		{
			// --- if table is in a form, toolbar buttons have to submit the form
			writer.println("<tr class='toolbar'>");
			writer.print("<th colspan='");
			writer.print(String.valueOf(nbToolCols+nbColsDisplayed));
			writer.println("'>");
			
			writer.print("<div class=Buttons>");
			writer.print("<ul>");
			for(int i=0; i<_xmlnode_0_unb_Toolbar.length; i++)
				_xmlnode_0_unb_Toolbar[i].render(iRequest, iResponse, hasForm ? this : null);
			writer.println("</ul>");
			
			writer.print("</div>");
			writer.println("</th>");
			writer.println("</tr>");
		}
		
		// --- render navigation bar (if any)
//		if(hasNavigationBar)
		if(true)
		{
			writer.println("<tr class='navigation'>");
			writer.print("<th colspan='");
			writer.print(String.valueOf(nbToolCols+nbColsDisplayed));
			writer.println("'>");
			
			// --- display rows index
			writer.print("<div class='range'>");
			if(context.rowsCount == 0 || nbRowsDisplayed == 0)
			{
				// --- display: No element.
				writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.no_data")));
			}
			else if(context.hasPagination())
			{
				if(context.rowsCount > 0)
				{
					// --- display: [first]-[last]/[total]
					Object[] args = new Object[]{new Integer(context.getFirstIndex()+1), new Integer(context.getFirstIndex()+nbRowsDisplayed), new Integer(context.rowsCount)};
					writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.nbrows_known", args)));
				}
				else
				{
					// --- display: [first]-[last]/???
					Object[] args = new Object[]{new Integer(context.getFirstIndex()+1), new Integer(context.getFirstIndex()+nbRowsDisplayed)};
					writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.nbrows_unknown", args)));
				}
			}
			else
			{
				// --- display: [total] elements
				Object[] args = new Object[]{new Integer(nbRowsDisplayed)};
				writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.no_pagination", args)));
			}
			writer.print("</div>");
			
			if(nbOfPages > 1)
			{
				boolean showPrevLink = context.getPage() > 0;
				boolean showNextLink = context.getPage() < nbOfPages-1;
	
				writer.print("<div class='pagelinks'>");
				// --- prev
				writer.print("&nbsp;");
				if(showPrevLink)
				{
					UrlBuilder prevurl = BricksUrlBuilder.copyFromRequest(iRequest, true);
					prevurl.setParameter(_xmlattr_req_ID+".page", String.valueOf(context.getPage()-1));
					
					writer.print("<a class=prev");
					renderHref(iRequest, iResponse, prevurl.toUrl(iRequest.getCharacterEncoding(), true));
					writer.print(">");
				}
				else
				{
					writer.print("<span class=prevd>");
				}
				writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.previous")));
				if(showPrevLink)
					writer.print("</a>");
				else
					writer.print("</span>");
	
				// --- page accessors
				for(int ipage=0; ipage<nbOfPages; ipage++)
				{
					writer.print("&nbsp;");
					if(ipage != context.getPage())
					{
						UrlBuilder pageurl = BricksUrlBuilder.copyFromRequest(iRequest, true);
						pageurl.setParameter(_xmlattr_req_ID+".page", String.valueOf(ipage));
						
						writer.print("<a");
						renderHref(iRequest, iResponse, pageurl.toUrl(iRequest.getCharacterEncoding(), true));
						writer.print(">");
					}
					else
					{
						writer.print("<span>");
					}
					writer.print(String.valueOf(ipage+1));
					if(ipage != context.getPage())
						writer.print("</a>");
					else
						writer.print("</span>");
				}
				
				// --- next
				writer.print("&nbsp;");
				if(showNextLink)
				{
					UrlBuilder nexturl = BricksUrlBuilder.copyFromRequest(iRequest, true);
					nexturl.setParameter(_xmlattr_req_ID+".page", String.valueOf(context.getPage()+1));
					
					writer.print("<a class=next");
					renderHref(iRequest, iResponse, nexturl.toUrl(iRequest.getCharacterEncoding(), true));
					writer.print(">");
				}
				else
				{
					writer.print("<span class=nextd>");
				}
				writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.next")));
				if(showNextLink)
					writer.print("</a>");
				else
					writer.print("</span>");
				
				writer.print("</div>");
			}
			
			writer.println("</th>");
			writer.println("</tr>");
		}
		
		// --- render columns headers
		writer.println("<tr class='headers'>");
		if(_xmlnode_0_unb_DetailsView != null)
		{
			// --- Expand details col
			writer.println("<th id='"+getID()+"_details' class=Details>&nbsp;</th>");
		}
		if(_xmlnode_opt_Selection != null)
		{
			// --- selection col
			writer.println("<th id='"+getID()+"_select' class=Select>&nbsp;</th>");
		}
		for(int icol=0; icol<_xmlnode_1_unb_Columns.length; icol++)
		{
			if(!context.columnsVisibility[icol])
				continue;
			
			_xmlnode_1_unb_Columns[icol].renderHeader(iRequest, iResponse, context, hasForm ? this : null, icol);
		}
		writer.println("</tr>");
		
		// --- render filters
		/*
		if(context.hasFilters())
		{
			writer.println("<tr class='filters'>");
			if(_xmlnode_opt_Selection != null)
				// --- selection col
				writer.println("<th>&nbsp;</th>");
			for(int icol=0; icol<_xmlnode_1_unb_Columns.length; icol++)
			{
				if(!context.columnsVisibility[icol])
					continue;
				
				_xmlnode_1_unb_Columns[icol].renderFilterCell(iRequest, iResponse, context, this, icol);
			}
			writer.println("</tr>");
		}
		*/
		
		writer.println("</thead>");
		
		// --- render table body (rows)
		// ----------------------------
		writer.println("<tbody>");
		
		// --- render rows
		if(data == null || data.size() == 0)
		{
			// --- display "no result"
			writer.println("<tr>");
			writer.print("<td colspan=");
			writer.print(String.valueOf(nbToolCols+nbColsDisplayed));
			writer.print(">");
			writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.nodata")));
			writer.println("</td>");
			writer.println("</tr>");
		}
		else
		{
			for(int irow=0; irow<nbRowsDisplayed; irow++)
			{
				// --- place item in request
				iRequest.setAttribute(_xmlattr_opt_RowBeanName, data.get(irow));
				
				writer.print("<tr class='");
				if(irow % 2 == 0)
					writer.print("even");
				else
					writer.print("odd");
				writer.println("'>");
				
				if(_xmlnode_0_unb_DetailsView != null)
				{
					// --- Expand details col
					writer.print("<td");
// no: use scope instead					writer.print(" headers='"+getID()+"_details'");
					writer.print(" class=Details>");
					if(irow == expanded)
					{
						// --- click this to collapse the row
						String collapseText = BricksMessages.getMessage(iResponse.getLocale(), "table.collapse");
						BricksUrlBuilder collapseUrl = BricksUrlBuilder.copyFromRequest(iRequest, true);
//						collapseUrl.removeParameter("_"+getID()+".exp");
						writer.print("<a class=Expanded");
						renderHref(iRequest, iResponse, collapseUrl.toUrl(iRequest.getCharacterEncoding(), true));
						writer.print(" title='");
						writer.print(HtmlUtils.encode2HTML(collapseText));
						writer.print("'");
						writer.print(">");
						writer.print(HtmlUtils.encode2HTML(collapseText));
						writer.print("</a>");
					}
					else
					{
						// --- click this to expand the row
						String expandText = BricksMessages.getMessage(iResponse.getLocale(), "table.expand");
						BricksUrlBuilder expandUrl = BricksUrlBuilder.copyFromRequest(iRequest, true);
						expandUrl.setParameter("_"+getID()+".exp", String.valueOf(irow));
						writer.print("<a class=Collasped");
						renderHref(iRequest, iResponse, expandUrl.toUrl(iRequest.getCharacterEncoding(), true));
						writer.print(" title='");
						writer.print(HtmlUtils.encode2HTML(expandText));
						writer.print("'");
						writer.print(">");
						writer.print(HtmlUtils.encode2HTML(expandText));
						writer.print("</a>");
					}
					writer.println("</td>");
				}

				if(_xmlnode_opt_Selection != null)
				{
					// --- selection col
					// --- retrieve current object ID
					Object curId = _xmlnode_opt_Selection._xmlnode_req_RowID.invoke(iRequest);
					// --- then check if it's selected
					boolean selected = false;
					if(selectedIds != null)
					{
						int idx = selectedIds.indexOf(curId);
						if(idx >= 0)
						{
							selected = true;
							// --- remove id from list
							selectedIds.remove(idx);
						}
					}
					writer.print("<td");
// no: use scope instead					writer.print(" headers='"+getID()+"_select'");
					writer.print(" class=Select>");
					writer.print("<input type='checkbox' class='checkbox' name='selection'");
					writer.print(" value='");
					writer.print(String.valueOf(curId));
					writer.print("'");
					if(selected)
						writer.print(" checked='checked'");
					writer.print("/>");
					
					writer.println("</td>");
				}
				if(_xmlattr_opt_Style == TableStyle.Paragraphs)
				{
					writer.print("<td colspan='");
					writer.print(String.valueOf(nbColsDisplayed));
					writer.println("'>");
				}
				int iDisplayedCol=0;
				for(int icol=0; icol<_xmlnode_1_unb_Columns.length; icol++)
				{
					if(!context.columnsVisibility[icol])
						continue;
					
					// --- render cell
					if(_xmlattr_opt_Style == TableStyle.Table)
					{
						_xmlnode_1_unb_Columns[icol].renderCell(iRequest, iResponse, icol, data.get(irow));
					}
					else
					{
						if(iDisplayedCol > 0)
							writer.print(", ");
						writer.print("<span class=title>");
						writer.print(HtmlUtils.encode2HTML(_xmlnode_1_unb_Columns[icol].getTitle(iRequest)));
						writer.print(" :</span>");
						writer.print(" ");
						_xmlnode_1_unb_Columns[icol].renderCellContent(iRequest, iResponse, icol, data.get(irow));
					}
					iDisplayedCol++;
				}
				if(_xmlattr_opt_Style == TableStyle.Paragraphs)
					writer.println("</td>");
				
				writer.println("</tr>");
				
				if(_xmlnode_0_unb_DetailsView != null && irow == expanded)
				{
					// --- render the expanded row
					writer.print("<tr class='Details ");
					if(irow % 2 == 0)
						writer.print("even");
					else
						writer.print("odd");
					writer.println("'>");
					
					/* No: use scope instead
					writer.print("<td headers='"+getID()+"_details' class=Details>&nbsp;</td>");
					if(_xmlnode_opt_Selection != null)
						writer.print("<td headers='"+getID()+"_select' class=Select>&nbsp;</td>");
					*/
					writer.print("<td class=Details>&nbsp;</td>");
					if(_xmlnode_opt_Selection != null)
						writer.print("<td class=Select>&nbsp;</td>");
					
					writer.print("<td class=DetailsView colspan=");
					writer.print(String.valueOf(nbColsDisplayed));
					writer.print(">");
					
					// --- render details
					for(int i=0; i<_xmlnode_0_unb_DetailsView.length; i++)
						_xmlnode_0_unb_DetailsView[i].render(iRequest, iResponse);
					
					writer.println("</td>");
					
					writer.println("</tr>");
				}
			}
		}
		
		writer.println("</tbody>");

		// --- render footer (navigation bar, toolbar, ...)
		//TODO ?
		
		writer.println("</table>");
		
		// --- manage selection
		if(hasForm)
		{
			if(_xmlnode_opt_Selection != null)
			{
				// --- add all non-displayed selected IDs
				if(selectedIds != null)
				{
					for(int i=0; i<selectedIds.size(); i++)
					{
						writer.print("<input type='hidden' name='selection'");
						writer.print(" value='");
						writer.print(String.valueOf(selectedIds.get(i)));
						writer.print("'");
						writer.println("/>");
					}
				}
			}
// temporary
//			writer.println("<input type=submit value='submit' style='visibility: hidden;'/>");
//writer.println("<input type=submit value='submit' style='display: none;'/>");
			// --- close form
			writer.println("</form>");
		}
	}
	/**
	 * implements ILinkHrefRenderer
	 */
	public boolean isEnabled(HttpServletRequest request)
	{
	    return true;
	}
	public void renderHref(HttpServletRequest iRequest, HttpServletResponse iResponse, String iHref) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		if(_xmlnode_opt_Selection == null)
		{
			writer.print(" href='");
			writer.print(iHref);
			writer.print("'");
		}
		else
		{
			// --- hyperlink submits the form and posts the redirect href
			writer.print(" href='javascript:void(0)' onclick=\"Table_submitAndNavigate('"+getFormName()+"', '"+iHref+"'); return false;\"");
		}
	}
	// =====================================================================================
	// === IBeanProvider implementation
	// =====================================================================================
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_RowBeanName.equals(iName))
		{
			if(_itemClass == null) throw new UnresolvedBeanError();
			return _itemClass;
		}
		else if("$context".equals(iName))
			return TableRenderingContextImpl.class;

		return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_RowBeanName.equals(iName))
		{
			if(_itemType == null) throw new UnresolvedBeanError();
			return _itemType;
		}
		else if("$context".equals(iName))
			return TableRenderingContextImpl.class;

		return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlattr_opt_RowBeanName.equals(iName))
			return iRequest.getAttribute(iName);
		else if("$context".equals(iName))
			return iRequest.getAttribute(iName);
		
		return getParentBeanValue(iRequest, iName);
	}
	/**
	 * Helper method to retreive the object representing the table row that is currently being rendered.
	 * This method should be called by custom column components during the rendering process.
	 * @param iRequest
	 * @return
	 */
	public Object getCurrentRow(HttpServletRequest iRequest)
	{
		return iRequest.getAttribute(_xmlattr_opt_RowBeanName);
	}
	/*
	public static TableRenderingContextImpl getRenderingContext(HttpServletRequest iRequest)
	{
		return (TableRenderingContextImpl)iRequest.getAttribute("$context");
	}
	*/
	private List sortAndPaginate(HttpServletRequest iRequest, List rowsData, TableRenderingContextImpl context) throws Exception
	{
		if(rowsData == null)
			rowsData = new ArrayList();
		
		// --- 1: filter
		if(context.getFilters() != null)
		{
			String[] filters = context.getFilters();
			// --- compile filters
			Object[] compiledFilter = new Object[filters.length];
			for(int j=0; j<filters.length; j++)
			{
				if(filters[j] != null && context.getColumns()[j].getFilter() != null)
					compiledFilter[j] = context.getColumns()[j].getFilter().compileFilter(iRequest, filters[j]);
			}
			// --- then filter
			ArrayList filtered = new ArrayList();
			for(int i=0; i<rowsData.size(); i++)
			{
				// --- put row object in request
				Object rowObj = rowsData.get(i);
				iRequest.setAttribute(_xmlattr_opt_RowBeanName, rowObj);
				// --- check whether if row passes filter(s)
				boolean passes = true;
				for(int j=0; j<compiledFilter.length; j++)
				{
					if(compiledFilter[j] != null && !context.getColumns()[j].getFilter().passFilter(iRequest, compiledFilter[j], rowObj))
					{
						passes = false;
						break;
					}
				}
				if(passes)
					filtered.add(rowObj);
			}
			
			rowsData = filtered;
		}
		
		// --- 2: sort
		if(context.hasSortedColumn())
		{
			// --- prepare sortable values
			SortableRow[] sortable = new SortableRow[rowsData.size()];
			for(int i=0; i<rowsData.size(); i++)
			{
				sortable[i] = new SortableRow();
				sortable[i].row = rowsData.get(i);
				iRequest.setAttribute(_xmlattr_opt_RowBeanName, sortable[i].row);
				sortable[i].value = _xmlnode_1_unb_Columns[context.sortColumn].getSorter().getSortableValue(iRequest, sortable[i].row);
			}
			
			// --- sort
//			Collections.sort(rowsData, new RowsComparator(iRequest, context));
			Arrays.sort(sortable, new RowsComparator(iRequest, context));
			
			// --- reorganize the list
			for(int i=0; i<sortable.length; i++)
				rowsData.set(i, sortable[i].row);
		}
		
		// --- set rows count
		context.setRowsCount(rowsData.size());
		
		// --- 3: adjust page number
		if(rowsData.size() == 0)
		{
			context.setPage(0);
		}
		else
		{
			if(context.getFirstIndex() >= rowsData.size())
			{
				int nbPages = (rowsData.size() + context.getRowsPerPage() - 1) / context.getRowsPerPage();
				context.setPage(nbPages-1);
			}
		}
		
		// --- 4: extract displayed slice
		if(context.getFirstIndex() > 0)
		{
			int number = rowsData.size() - context.getFirstIndex();
			if(context.getRowsPerPage() > 0 && number > context.getRowsPerPage())
				number = context.getRowsPerPage();
			rowsData = rowsData.subList(context.getFirstIndex(), context.getFirstIndex()+number);
		}
		
	    return rowsData;		
	}
	// =======================================================================================
	// === Inner classes for local sort implementation
	// =======================================================================================
	private static class SortableRow
	{
		protected Object value;
		protected Object row;
	}
	private static class RowsComparator implements Comparator<SortableRow>
	{
		private HttpServletRequest _req;
		private ISorter _sorter;
		private int _asc = 1;
		
		public RowsComparator(HttpServletRequest iRequest, TableRenderingContextImpl context)
		{
			_req = iRequest;
			_sorter = context.getColumns()[context.getSortColumn()].getSorter();
			_asc = context.getSortDirection() ? 1 : -1;
		}
		public int compare(SortableRow iObj1, SortableRow iObj2)
		{
			try
            {
	            return _asc*_sorter.compare(_req, iObj1.value, iObj2.value);
            }
            catch(Exception e)
            {
            	e.printStackTrace();
            	return 0;
            }
		}
	}
}
