package com.ebm_ws.infra.bricks.components.base.html.table;

import com.ebm_ws.infra.bricks.table.TableRenderingContext;

public class TableRenderingContextImpl extends TableRenderingContext
{
	protected IColumn[] columns;
	private int page = 0;
//	protected int firstIndex = 0;
	private int rowsPerPage = Integer.MAX_VALUE;
	protected boolean[] columnsVisibility;
	protected int columnsCount;
	protected int sortColumn = -1;
	protected boolean sortDirection = true;
	protected boolean hasFilters = false;
	protected String[] columnFilters;
	protected int rowsCount = -1;
	
	public IColumn[] getColumns()
	{
		return columns;
	}
	@Override
	public boolean hasFilters()
	{
	    return hasFilters;
	}
	public String[] getFilters()
    {
    	return columnFilters;
    }
	/**
	 * Returns the filter text for the given column.
	 * @param iColumn
	 * @return
	 */
	public String getFilter(int iColumn)
	{
		if(columnFilters == null)
			return null;
		return columnFilters[iColumn];
	}
	/**
	 * Returns the first index.
	 * @return
	 */
	public int getFirstIndex()
    {
    	if(rowsPerPage == Integer.MAX_VALUE)
    		return 0;
    	return rowsPerPage*page;
    }
	/**
	 * Returns the maximum number of results displayed by the table.
	 * A null value means "no limit".
	 * @return
	 */
	public int getRowsPerPage()
    {
    	return rowsPerPage;
    }
	/**
	 * Returns the index of the sorted column.
	 * A negative value means no sorted column.
	 * @return
	 */
	public int getSortColumn()
	{
		return sortColumn;
	}
	/**
	 * Returns the sort direction.
	 * <code>true</code> means ascending, <code>false</code> is descending.
	 * @return
	 */
	public boolean getSortDirection()
	{
		return sortDirection;
	}
	/**
	 * Determines whether the current table rendering context has a sorted column
	 * @return
	 */
	public boolean hasSortedColumn()
	{
		return sortColumn >= 0;
	}
	/**
	 * Determines whether the current table rendering context has pagination
	 * @return
	 */
	public boolean hasPagination()
	{
		return rowsPerPage != Integer.MAX_VALUE;
	}
	/**
	 * Allows to set the number of rows.
	 * This is only required in the case of a table that displays in page ranges. 
	 * @param iNumberOfRows
	 */
	public void setRowsCount(int iNumberOfRows)
	{
		rowsCount = iNumberOfRows;
	}
	@Override
	public int getPage()
	{
	    return page;
	}
	@Override
	public void setPage(int iPage)
	{
		if(iPage < 0)
			page = 0;
		else
			page = iPage;
	}
	protected void setRowsPerPage(int iRowsPerPage)
	{
		rowsPerPage = iRowsPerPage <= 5 ? 5 : iRowsPerPage;
	}
}
