package com.ebm_ws.infra.bricks.components.base.html.table;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;

public class TextColumn extends BaseColumn
{
	private IBinding _xmlnode_opt_CellValue;
	private IMessage _xmlnode_req_Text;
	private IImage _xmlnode_opt_Icon;
	private IAction _xmlnode_opt_OnClick;
	
	@Override
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    super.checkThisNode(iValidSupport, iErrors);
	    
	    if(_xmlnode_opt_CellValue != null && !_xmlnode_opt_CellValue.hasErrors())
	    {
	    	if(!_xmlnode_opt_CellValue.getType().isPrimitive() && !Comparable.class.isAssignableFrom(_xmlnode_opt_CellValue.getType()))
	    		iErrors.logMessage(this, "SortOn", IValidityLogger.ERROR, "Sortable value has to implement Comparable: "+_xmlnode_opt_CellValue.getType().getName());
	    }
	}
	public Object getCellValue(HttpServletRequest iRequest, Object iRowObject) throws Exception
	{
		if(_xmlnode_opt_CellValue == null)
			// --- sort on text
			return _xmlnode_req_Text.getMessage(iRequest);
		else
			// --- sort on value
			return _xmlnode_opt_CellValue.invoke(iRequest);
	}
	public String getCellText(HttpServletRequest iRequest, Object iRowObject) throws Exception
	{
		return _xmlnode_req_Text.getMessage(iRequest);
	}
	
	public void renderCellContent(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		String text = _xmlnode_req_Text.getMessage(iRequest);
		String textHtml = text == null || text.length() == 0 ? "&nbsp;" : HtmlUtils.encode2HTML(text);

		String url = null;
		if(_xmlnode_opt_OnClick != null)
			url = _xmlnode_opt_OnClick.getURL(iRequest, true);
		
		String iconSrc = _xmlnode_opt_Icon == null ? null : _xmlnode_opt_Icon.getImage(iRequest);

		if(url == null)
		{
			// --- render cell as simple text
			if(iconSrc != null)
			{
				writer.print("<img src='");
				writer.print(iconSrc);
				writer.print("' alt='");
//empty alt is ok				writer.print(textHtml);
				writer.print("'/>");
			}
			writer.print(textHtml);
		}
		else
		{
			// --- render hyperlink
			writer.print("<a href=\"");
			writer.print(url);
			writer.print("\">");
			if(iconSrc != null)
			{
				writer.print("<img src='");
				writer.print(iconSrc);
				writer.print("' alt='");
				//empty alt is ok				writer.print(textHtml);
				writer.print("'/>");
			}
			writer.print(textHtml);
			writer.print("</a>");
		}
	}
	public Class getCellType()
	{
		if(_xmlnode_opt_CellValue == null)
			return String.class;
		else
			return _xmlnode_opt_CellValue.getType();
	}
}
