package com.ebm_ws.infra.bricks.components.base.html.tree;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class DynamicItems extends BaseBeanProvider implements IXmlObject, ITreeItemsProvider, IBeanProvider
{
	private String _xmlattr_opt_ItemBeanName = "$item";
	
	private IBinding _xmlnode_req_RootItems;
	private IBinding _xmlnode_req_Children;
	private IMessage _xmlnode_req_Text;
	private IBinding _xmlnode_req_IsNode;
	private IImage _xmlnode_opt_Icon;

	private Type itemType;
	private Class itemClass;

	private void initialize()
	{
		if(itemClass != null)
			return;
		if(_xmlnode_req_RootItems != null && !_xmlnode_req_RootItems.hasErrors())
		{
			itemClass = ReflectionHelper.getVectorElementClass(_xmlnode_req_RootItems.getGenericType());
			itemType = ReflectionHelper.getVectorElementType(_xmlnode_req_RootItems.getGenericType());
		}
	}
	public void checkThisNode(Object validSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_RootItems != null && !_xmlnode_req_RootItems.hasErrors())
		{
			if(itemClass == null)
				initialize();
			if(itemClass == null)
		    	iErrors.logMessage(this, "RootItems", IValidityLogger.ERROR, "Bound items must be vector data.");
			
			// TODO: Children is of same type than root items
		}
	}
	public List<ITreeItem> getItems(HttpServletRequest iRequest) throws Exception
	{
		// --- 1: retrieve children items
		List<Object> children = ReflectionHelper.obj2List(_xmlnode_req_RootItems.invoke(iRequest));
		if(children == null)
		{
			return null;
		}
		// --- 2: build items list
		List<ITreeItem> childrenItems = new ArrayList<ITreeItem>();
		for(int i=0; i<children.size(); i++)
		{
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, children.get(i));
			boolean isnode = (Boolean)_xmlnode_req_IsNode.invoke(iRequest);
			if(isnode)
				childrenItems.add(new DynamicNode(children.get(i)));
			else
				childrenItems.add(new DynamicItem(children.get(i)));
		}
		return childrenItems;
	}
	// ==================================================================
	// === BeanProvider
	// ==================================================================
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			initialize();
			if(itemClass == null) throw new UnresolvedBeanError();
			return itemClass;
		}
		return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
		{
			initialize();
			if(itemType == null) throw new UnresolvedBeanError();
			return itemType;
		}
		return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlattr_opt_ItemBeanName.equals(iName))
			return iRequest.getAttribute(iName);
		return getParentBeanValue(iRequest, iName);
	}

	// ==================================================================
	// === DynamicItem
	// ==================================================================
	private class DynamicItem implements ITreeItem
	{
		protected Object obj;
		
		public DynamicItem(Object iObj)
		{
			obj = iObj;
		}
		public String getText(HttpServletRequest iRequest)
		{
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, obj);
			return _xmlnode_req_Text.getMessage(iRequest);
		}
		public String getIcon(HttpServletRequest iRequest)
		{
			if(_xmlnode_opt_Icon == null)
				return null;
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, obj);
			return _xmlnode_opt_Icon.getImage(iRequest);
		}
		@Override
		public boolean equals(Object o)
		{
			if(!(o instanceof DynamicItem))
				return false;
			
		    return obj.equals(((DynamicItem)o).obj);
		}
		@Override
		public int hashCode()
		{
		    return obj.hashCode();
		}
	}
	// ==================================================================
	// === DynamicNode
	// ==================================================================
	private class DynamicNode extends DynamicItem implements ITreeNode
	{
		public DynamicNode(Object iObj)
		{
			super(iObj);
		}
		public List<ITreeItem> getItems(HttpServletRequest iRequest) throws Exception
		{
			// --- 1: retrieve children items
			iRequest.setAttribute(_xmlattr_opt_ItemBeanName, obj);
			List<Object> children = ReflectionHelper.obj2List(_xmlnode_req_Children.invoke(iRequest));
			if(children == null)
			{
				return null;
			}
			// --- 2: build items list
			List<ITreeItem> childrenItems = new ArrayList<ITreeItem>();
			for(int i=0; i<children.size(); i++)
			{
				iRequest.setAttribute(_xmlattr_opt_ItemBeanName, children.get(i));
				boolean isnode = (Boolean)_xmlnode_req_IsNode.invoke(iRequest);
				if(isnode)
					childrenItems.add(new DynamicNode(children.get(i)));
				else
					childrenItems.add(new DynamicItem(children.get(i)));
			}
			return childrenItems;
		}
	}
}
