package com.ebm_ws.infra.bricks.components.base.html.tree;


import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.enums.Scope;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BeanUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Tree implements IView, IXmlObject, IIdentifiable
{
	protected Application _xmlroot;
	
	private String _xmlattr_req_ID;
	private String _xmlattr_opt_CssClass = "Tree";
	private Scope _xmlattr_opt_StateScope = Scope.PageContext;
	
	private IAction _xmlnode_opt_OnClick;
	private ITreeItemsProvider _xmlnode_req_Content;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Tree_"+_xmlattr_req_ID;
	}
	// --- [-] IIdentifiable implementation
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    if(_xmlroot.registerRequestHandler(getPathID(), this) != null)
        	iErrors.logMessage(this, "ID", IValidityLogger.INFO, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
	}
	public void preRender(HttpServletRequest request) throws Exception
	{
	}
	private TreeState getState(HttpServletRequest iRequest)
	{
		TreeState state = (TreeState)BeanUtils.getBean(iRequest, TreeState.class, getPathID(), _xmlattr_opt_StateScope);
		if(state == null)
		{
			state = new TreeState();
			BeanUtils.setBean(iRequest, state, getPathID(), _xmlattr_opt_StateScope);			
		}
		return state;
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
//		TreeStatus data = (TreeStatus)RenderingContext.get(iRequest).get(this, "data");
		TreeState state = getState(iRequest);
		
		PrintWriter writer = iResponse.getWriter();
		
		HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Common.js");
		HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Tree.js");
		
		writer.print("<div");
		writer.print(" id='");
		writer.print(_xmlattr_req_ID);
		writer.println("'");
		writer.print(" class='");
		writer.print(_xmlattr_opt_CssClass);
		writer.print("'");
		writer.println(">");
		renderItems(iRequest, iResponse, _xmlnode_req_Content, state);
		writer.println("</div>");
		
		UrlBuilder jsonRequestUrl = _xmlroot.createServiceUrl(iRequest, this, "jsonRequest");

		writer.println("<script language='javascript' type='text/javascript'>");
		writer.println("Tree_init('"+_xmlattr_req_ID+"', '"+jsonRequestUrl.toUrl(iResponse.getCharacterEncoding(), false)+"');");
		writer.println("</script>");
	}
	private void renderItems(HttpServletRequest iRequest, HttpServletResponse iResponse, ITreeItemsProvider iNode, TreeState state) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		List<ITreeItem> items = iNode.getItems(iRequest);
		
		writer.println("<ul>");
		if(items != null)
		{
			for(int i=0; i<items.size(); i++)
			{
				ITreeItem item = items.get(i);
				String itemId = state.getId(iNode instanceof ITreeNode ? (ITreeNode)iNode : null, item, i);
				String text = item.getText(iRequest);
				String iconSrc = item.getIcon(iRequest);
				String url = _xmlnode_opt_OnClick != null ? _xmlnode_opt_OnClick.getURL(iRequest, true) : null;
				boolean isnode = (item instanceof ITreeNode);
				boolean isexpanded = isnode ? state.isExpanded(itemId) : false;
				
				writer.print("<li");
				writer.print(" id='");
				writer.print(itemId);
				writer.print("'");
				if(i == items.size()-1)
					writer.print(" class=last");
				writer.print(">");
				
				if(isnode)
				{
					// --- anchor
					writer.print("<a href='javascript:void(0)'");
					if(isexpanded)
						writer.print(" class='anchor exp'");
					else
						writer.print(" class='anchor coll'");
					writer.print(" onclick=\"Tree_onClickAnchor(event);\"></a>");
				}
				
				// --- icon
				if(iconSrc != null)
				{
					writer.print("<img src='");
					writer.print(iconSrc);
					writer.print("' alt='");
					//empty alt is ok					writer.print(HtmlUtils.encode2HTML(text, false));
					writer.print("'/>");
				}
				
				// --- text
				if(url == null)
				{
					writer.print("<span class=label>");
				}
				else
				{
					writer.print("<a class=label href=\"");
					writer.print(url);
					writer.print("\">");
				}
				writer.print(HtmlUtils.encode2HTML(text));
				if(url == null)
					writer.print("</span>");
				else
					writer.print("</a>");
				
				// --- render node children
				if(isnode && isexpanded)
					renderItems(iRequest, iResponse, (ITreeNode)item, state);
				
				writer.println("</li>");
			}
		}
		writer.println("</ul>");
	}
	// ========================================================================
	// === JSON Methods
	// ========================================================================
	public void jsonRequest(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
System.out.println("--> Tree.jsonRequest(): "+iRequest.getQueryString());
		
		BricksSession session = BricksSession.getSession(iRequest);
		iResponse.setContentType("text/plain;charset="+session.getLocaleConfig().getCharSet());
//		iResponse.setHeader("Cache-Control", "no-store"); //HTTP 1.1
		iResponse.setHeader("Cache-Control", "no-cache"); //HTTP 1.1
		iResponse.setHeader("Pragma", "no-cache"); //HTTP 1.0
		iResponse.setDateHeader("Expires", 0); //prevents caching at the proxy server

		PrintWriter iWriter = iResponse.getWriter();

		String action = iRequest.getParameter("action");
		if("expand".equals(action))
		{
			String nodeId = iRequest.getParameter("id");
			TreeState state = getState(iRequest);
			state.setExpanded(nodeId, true);
			
			// --- now return children
			ITreeNode node = (ITreeNode)state.getNode(nodeId);
			jsonRenderItems(iRequest, iResponse, node, state);
		}
		else if("collapse".equals(action))
		{
			String nodeId = iRequest.getParameter("id");
			TreeState state = getState(iRequest);
			state.setExpanded(nodeId, false);
		}
		else
		{
			System.out.println("unknown action: "+action);
		}
		iWriter.print(" ");
		iWriter.flush();
		iWriter.close();
	}
	private void jsonRenderItems(HttpServletRequest iRequest, HttpServletResponse iResponse, ITreeItemsProvider iNode, TreeState state) throws Exception
	{
		PrintWriter writer = iResponse.getWriter();
		List<ITreeItem> items = iNode.getItems(iRequest);
		
		writer.print("[");
		if(items != null)
		{
			for(int i=0; i<items.size(); i++)
			{
				ITreeItem item = items.get(i);
				String itemId = state.getId(iNode instanceof ITreeNode ? (ITreeNode)iNode : null, item, i);
				String text = item.getText(iRequest);
				String iconSrc = item.getIcon(iRequest);
				String url = _xmlnode_opt_OnClick != null ? _xmlnode_opt_OnClick.getURL(iRequest, true) : null;
				boolean isnode = (item instanceof ITreeNode);
				boolean isexpanded = isnode ? state.isExpanded(itemId) : false;
				
				if(i > 0)
					writer.print(",");
				
				writer.print("{");
				writer.print("id:");
				writer.print("'");
				writer.print(HtmlUtils.encode2JsString(itemId));
				writer.print("'");
				
				if(isnode)
				{
					writer.print(",");
					writer.print("isNode:true");
					if(isexpanded)
					{
						writer.print(",");
						writer.print("isExp:true");
					}
				}
				
				writer.print(",");
				
				writer.print("text:");
				writer.print("'");
				writer.print(HtmlUtils.encode2JsString(text));
				writer.print("'");
				if(iconSrc != null)
				{
					writer.print(",");
					
					writer.print("icon:");
					writer.print("'");
					writer.print(HtmlUtils.encode2JsString(iconSrc));
					writer.print("'");
				}
				if(url != null)
				{
					writer.print(",");
					
					writer.print("url:");
					writer.print("'");
					writer.print(HtmlUtils.encode2JsString(url));
					writer.print("'");
				}

				if(isnode && isexpanded)
				{
					writer.print(",");
					
					writer.print("children:");
					jsonRenderItems(iRequest, iResponse, (ITreeNode)item, state);
				}
				writer.print("}");
			}
		}
		writer.print("]");
	}
	// ========================================================================
	// === Tree State
	// ========================================================================
	private class TreeState
	{
		private HashMap<ITreeItem, String> obj2Id = new HashMap<ITreeItem, String>();
		private HashMap<String, ITreeItem> id2Obj = new HashMap<String, ITreeItem>();
		private HashMap<String, Boolean> expanded = new HashMap<String, Boolean>();
		
		public String getId(ITreeNode father, ITreeItem item, int index)
		{
			String id = obj2Id.get(item);
			if(id == null)
			{
				String fatherId = father == null ? _xmlattr_req_ID : obj2Id.get(father);
				id = fatherId+"_"+String.valueOf(index);
				obj2Id.put(item, id);
				id2Obj.put(id, item);
			}
			return id;
		}
		public ITreeItem getNode(String id)
		{
			return id2Obj.get(id);
		}
		public boolean isExpanded(String id)
		{
			return expanded.get(id) != null;
		}
		public void setExpanded(String id, boolean state)
		{
			if(state)
				expanded.put(id, Boolean.TRUE);
			else
				expanded.remove(id);
		}
	}
}
