package com.ebm_ws.infra.bricks.components.base.img;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class LocalizedImage implements IImage, IXmlObject
{
	private Application _xmlroot;
	private String _xmlattr_opt_Provider;
	private String _xmlattr_req_Key;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- check the provider exists
		MessageProvider provider = _xmlroot.getMessageProvider(_xmlattr_opt_Provider);
		if(provider == null)
		{
			iErrors.logMessage(this, "Provider", IValidityLogger.ERROR, "Provider ["+_xmlattr_opt_Provider+"] not found.");
		}
		else
		{
			// --- check that the message exists in all supported languages
//			Locale[] langs = _xmlroot.getSupportedLanguages();
			ILocaleConfig[] langs = _xmlroot.getAllLanguages();
			for(int i=0; i<langs.length; i++)
			{
				try
				{
					if(!provider.checkMessage(langs[i].getLocale(), _xmlattr_req_Key))
						iErrors.logMessage(this, "Key", IValidityLogger.WARNING, "Message ["+_xmlattr_req_Key+"] in provider ["+provider.getName()+"] is null for language "+langs[i].getLocale().getLanguage()+".");
				}
				catch(Exception e)
				{
					iErrors.logMessage(this, "Key", IValidityLogger.ERROR, "Message ["+_xmlattr_req_Key+"] in provider ["+provider.getName()+"] not found for language "+langs[i].getLocale().getLanguage()+".");
				}
			}
		}
	}
	public String getImage(HttpServletRequest iRequest)
	{
		BricksSession session = BricksSession.getSession(iRequest);
		MessageProvider provider = session.getApplication().getMessageProvider(_xmlattr_opt_Provider);
		if(provider == null)
			return "!"+_xmlattr_req_Key+"!";
		
		return provider.getMessage(session.getLocale(), _xmlattr_req_Key, null);
	}
}
