package com.ebm_ws.infra.bricks.components.base.locale;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class FromCode implements IXmlObject, ILocaleSelector
{
	private Application _xmlroot;
	private IBinding _xmlnode_req_Locale;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlnode_req_Locale != null && !_xmlnode_req_Locale.hasErrors())
		{
			if(Locale.class != _xmlnode_req_Locale.getType())
				iErrors.logMessage(this, "Locale", IValidityLogger.ERROR, "This binding must return a java.util.Locale value.");
		}
	}
	public Locale getLocale(HttpServletRequest iRequest)
	{
		try
        {
	        return (Locale)_xmlnode_req_Locale.invoke(iRequest);
        }
        catch(Exception e)
        {
        	// --- return default locale (first one)
        	return _xmlroot.getAllLanguages()[0].getLocale();
        }
	}
}
