package com.ebm_ws.infra.bricks.components.base.locale;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class FromExpression implements IXmlObject, ILocaleSelector
{
    private IBinding _xmlcollect_req_Locale;
    
    
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
        // --- check Locale binding
        if(_xmlcollect_req_Locale != null && !_xmlcollect_req_Locale.hasErrors())
        {
            if(Locale.class != _xmlcollect_req_Locale.getType())
                iErrors.logMessage(this, "Locale", IValidityLogger.ERROR, "This binding must return a java.util.Locale value.");
            else if(!_xmlcollect_req_Locale.isGetSet())
                iErrors.logMessage(this, "Locale", IValidityLogger.ERROR, "This binding must be settable (to set language when selected).");
        }
	}
	public java.util.Locale getLocale(HttpServletRequest iRequest)
	{
	    try {
            return (java.util.Locale)_xmlcollect_req_Locale.invoke(iRequest);
        } catch (Exception e) {
            return null;
        }
	}
}
