package com.ebm_ws.infra.bricks.components.base.locale;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class LocaleConfig implements IXmlObject, ILocaleConfig
{
	private String _xmlattr_req_Language;
	private String _xmlattr_opt_Country;
	
	private String _xmlattr_opt_CharSet = "iso-8859-1";
	
//	private String _xmlattr_opt_TimeZone;
	private String _xmlattr_opt_DateOutputFormat;
	private String _xmlattr_opt_DateInputFormat;
	private String _xmlattr_opt_TimeOutputFormat;
	private String _xmlattr_opt_TimeInputFormat;
	private String _xmlattr_opt_DateTimeOutputFormat;
	private String _xmlattr_opt_DateTimeInputFormat;
	private TimeZone timeZone;
	private DateFormat dateOutputFormat;
	private DateFormat dateInputFormat;
	private DateFormat timeOutputFormat;
	private DateFormat timeInputFormat;
	private DateFormat dateTimeOutputFormat;
	private DateFormat dateTimeInputFormat;
	
	// TODO: currency ?
	
	private java.util.Locale locale;
	
	private void initialize()
	{
		if(locale != null)
			return;

		locale = _xmlattr_opt_Country == null ? new Locale(_xmlattr_req_Language) : new Locale(_xmlattr_req_Language, _xmlattr_opt_Country);
		
		if(_xmlattr_opt_DateOutputFormat != null)
			dateOutputFormat = new SimpleDateFormat(_xmlattr_opt_DateOutputFormat);
		else
			dateOutputFormat = DateFormat.getDateInstance(DateFormat.MEDIUM, locale);
		
		if(_xmlattr_opt_DateInputFormat != null)
			dateInputFormat = new SimpleDateFormat(_xmlattr_opt_DateInputFormat);
		else
			dateInputFormat = dateOutputFormat;
		
		if(_xmlattr_opt_TimeOutputFormat != null)
			timeOutputFormat = new SimpleDateFormat(_xmlattr_opt_TimeOutputFormat);
		else
			timeOutputFormat = DateFormat.getTimeInstance(DateFormat.MEDIUM, locale);
		
		if(_xmlattr_opt_TimeInputFormat != null)
			timeInputFormat = new SimpleDateFormat(_xmlattr_opt_TimeInputFormat);
		else
			timeInputFormat = timeOutputFormat;
		
		if(_xmlattr_opt_DateTimeOutputFormat != null)
			dateTimeOutputFormat = new SimpleDateFormat(_xmlattr_opt_DateTimeOutputFormat);
		else
			dateTimeOutputFormat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, locale);

		if(_xmlattr_opt_DateTimeInputFormat != null)
			dateTimeInputFormat = new SimpleDateFormat(_xmlattr_opt_DateTimeInputFormat);
		else
			dateTimeInputFormat = dateTimeOutputFormat;
		
		/*
		if(_xmlattr_opt_TimeZone != null)
		{
			timeZone = TimeZone.getTimeZone(_xmlattr_opt_TimeZone);
			
			dateOutputFormat.setTimeZone(timeZone);
			dateInputFormat.setTimeZone(timeZone);
			timeOutputFormat.setTimeZone(timeZone);
			timeInputFormat.setTimeZone(timeZone);
			dateTimeOutputFormat.setTimeZone(timeZone);
			dateTimeInputFormat.setTimeZone(timeZone);
		}
		*/
	}
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		initialize();
	}
	public java.util.Locale getLocale()
    {
		initialize();
    	return locale;
    }

	public DateFormat getDateInputFormat()
    {
    	return dateInputFormat;
    }

	public DateFormat getDateOutputFormat()
    {
    	return dateOutputFormat;
    }

	public DateFormat getDateTimeInputFormat()
    {
    	return dateTimeInputFormat;
    }

	public DateFormat getDateTimeOutputFormat()
    {
    	return dateTimeOutputFormat;
    }

	public DateFormat getTimeInputFormat()
    {
    	return timeInputFormat;
    }

	public DateFormat getTimeOutputFormat()
    {
    	return timeOutputFormat;
    }
	public String getCharSet()
	{
	    return _xmlattr_opt_CharSet;
	}
}
