package com.ebm_ws.infra.bricks.components.base.msg;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Message implements IMessage, IXmlObject
{
	private Application _xmlroot;
	private String _xmlattr_opt_Provider;
	private String _xmlattr_req_Key;
	private IBinding[] _xmlnode_0_unb_Args;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- check the provider exists
		MessageProvider provider = _xmlroot.getMessageProvider(_xmlattr_opt_Provider);
		if(provider == null)
		{
			iErrors.logMessage(this, "Provider", IValidityLogger.ERROR, "Provider ["+_xmlattr_opt_Provider+"] not found.");
		}
		else
		{
			// --- check that the message exists in all supported languages
//			Locale[] langs = _xmlroot.getSupportedLanguages();
			ILocaleConfig[] langs = _xmlroot.getAllLanguages();
			for(int i=0; i<langs.length; i++)
			{
				try
				{
					if(!provider.checkMessage(langs[i].getLocale(), _xmlattr_req_Key))
						iErrors.logMessage(this, "Key", IValidityLogger.WARNING, "Message ["+_xmlattr_req_Key+"] in provider ["+provider.getName()+"] is null for language "+langs[i].getLocale().getLanguage()+".");
				}
				catch(Exception e)
				{
					iErrors.logMessage(this, "Key", IValidityLogger.ERROR, "Message ["+_xmlattr_req_Key+"] in provider ["+provider.getName()+"] not found for language "+langs[i].getLocale().getLanguage()+".");
				}
			}
		}
	}
	public String getMessage(HttpServletRequest iRequest)
	{
		BricksSession session = BricksSession.getSession(iRequest);
		MessageProvider provider = session.getApplication().getMessageProvider(_xmlattr_opt_Provider);
		if(provider == null)
			return "!"+_xmlattr_req_Key+"!";
		
		// --- evaluate args
		Object[] args = null;
		if(_xmlnode_0_unb_Args != null && _xmlnode_0_unb_Args.length > 0)
		{
			args = new Object[_xmlnode_0_unb_Args.length];
			for(int i=0; i<args.length; i++)
			{
				try
                {
	                args[i] = _xmlnode_0_unb_Args[i].invoke(iRequest);
                }
                catch(Exception e)
                {
	                args[i] = "!error!";
                }
			}
		}
		return provider.getMessage(session.getLocale(), _xmlattr_req_Key, args);
	}
}
