package com.ebm_ws.infra.bricks.components.base.msg;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;

import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;

public class ResourceBundle extends MessageProvider
{
//	private Application _xmlroot;
	private String _xmlattr_req_BaseName;
	
	public ResourceBundle()
	{
	}
	public ResourceBundle(String baseName)
	{
		_xmlattr_req_BaseName = baseName;
	}
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- check that bundle exists for all supported locales (TODO)
		if(_xmlattr_req_BaseName != null)
		{
			try
			{
				java.util.ResourceBundle.getBundle(_xmlattr_req_BaseName);
			}
			catch(MissingResourceException e)
			{
				iErrors.logMessage(this, "BaseName", IValidityLogger.ERROR, "Resource bundle '"+_xmlattr_req_BaseName+"' not found.");
			}
		}
	}
	public boolean checkMessage(Locale iLocale, String iKey)
	{
		try
		{
			java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle(_xmlattr_req_BaseName, iLocale);
			return bundle.getString(iKey) != null;
		}
		catch(MissingResourceException e)
		{
		}
		return false;
	}
	public String getMessage(Locale iLocale, String iKey, Object[] iArgs)
	{
		java.util.ResourceBundle bundle = null;
		try
		{
			bundle = java.util.ResourceBundle.getBundle(_xmlattr_req_BaseName, iLocale);
		}
		catch(MissingResourceException e)
		{
		}
		if(bundle == null)
			return "! "+iKey+" (no bundle) !";
		
		String msg = null;
		try
		{
			msg = bundle.getString(iKey);
		}
		catch(MissingResourceException e)
		{
		}
		
		if(msg == null)
			return "! "+iKey+" (no key) !";
		
		if(iArgs == null || iArgs.length == 0)
			return msg;
		
		// --- replace args in message
		return MessageFormat.format(escapeForMessageFormat(msg), iArgs);
	}
	private static String escapeForMessageFormat(String pattern)
	{
		if(pattern == null || pattern.indexOf('\'') < 0)
			return pattern;
		int n = pattern.length();
		StringBuffer sb = new StringBuffer(n);
		for(int i = 0; i < n; i++)
		{
			char ch = pattern.charAt(i);
			if(ch == '\'')
				sb.append('\'');
			sb.append(ch);
		}

		return sb.toString();
	}
}
