package com.ebm_ws.infra.bricks.components.base.page;

import java.io.PrintWriter;
import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.base.page.ctx.IPageContextDef;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public abstract class BasePage extends BaseBeanProvider implements IXmlObject, IPage, IIdentifiable
{
	private Application _xmlroot;
	private String _xmlattr_opt_FrameName;
	private String _xmlattr_req_Name;
	private IPageContextDef _xmlnode_req_Context;
	private IBinding[] _xmlnode_0_unb_OnPreRender;
	
	private IMessage _xmlnode_req_Title;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Page_"+_xmlattr_req_Name;
	}
	// --- [-] IIdentifiable implementation

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlroot.getFrame(_xmlattr_opt_FrameName) == null)
			iErrors.logMessage(this, "FrameName", IValidityLogger.ERROR, "Frame '"+_xmlattr_opt_FrameName+"' not found.");
	}
	public IPageContextDef getContextDef()
	{
	    return _xmlnode_req_Context;
	}
	public String getName()
	{
	    return _xmlattr_req_Name;
	}
	public String getFrameName()
	{
	    return _xmlattr_opt_FrameName;
	}
	public String getTitle(HttpServletRequest iRequest) throws Exception
	{
		return _xmlnode_req_Title.getMessage(iRequest);
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		if(_xmlnode_0_unb_OnPreRender != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnPreRender.length; i++)
				_xmlnode_0_unb_OnPreRender[i].invoke(iRequest);
		}
	}
	public void servePage(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		BricksSession session = BricksSession.getSession(iRequest);
		iRequest.setAttribute("_RENDER_PAGE_", this);
		
		// --- 1: pre-render
//		preRender(iRequest);
		_xmlroot.getFrame(getFrameName()).preRender(iRequest);
		
		// --- 2: render
		
		/*
		 * W3C rules:
		 * 
		 * XHTML 1.0 strict:
		 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
		 * <html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
		 * 
		 * XHTML 1.0 transitional:
		 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		 * <html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
		 * 
		 * HTML 4.0.1 strict:
		 * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
		 * 
		 * HTML 4.0.1 transitional:
		 * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
		 * <html lang="en">
		 * 
		 * XHTML 1.1:
		 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
		 * <html lang="en">
		 * 
		 * 
		 * With XHTML, the content type must be "application/xhtml+xml" or "text/xml" (for IE)
		 */
		// --- render response (html)
		iResponse.setContentType("text/html;charset="+session.getLocaleConfig().getCharSet());
//		iResponse.setHeader("Cache-Control", "no-store"); //HTTP 1.1
		iResponse.setHeader("Cache-Control", "no-cache"); //HTTP 1.1
		iResponse.setHeader("Pragma", "no-cache"); //HTTP 1.0
		iResponse.setDateHeader("Expires", 0); //prevents caching at the proxy server
		PrintWriter htmlWriter = iResponse.getWriter();
		
		// --- 3: render
		//TODO: other headers
		
		htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
		htmlWriter.print("<html lang=\"");
		htmlWriter.print(session.getLocaleConfig().getLocale().getLanguage());
		htmlWriter.println("\">");
		htmlWriter.println("<head>");

		// --- write page title
		htmlWriter.print("<title>");
		htmlWriter.print(HtmlUtils.encode2HTML(this.getTitle(iRequest)));
		htmlWriter.println("</title>");

		// --- meta tags
		// html content type
		htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset="+session.getLocaleConfig().getCharSet()+"'>");
		// no cache (for all browsers)
		htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
		htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
		htmlWriter.println("<meta http-equiv='expires' content='0'>");
		// --- les liens relatifs le sont par rapport  l'application
		htmlWriter.print("<base href='");
		htmlWriter.print(iRequest.getScheme());
		htmlWriter.print("://");
		htmlWriter.print(iRequest.getServerName());
		htmlWriter.print(":");
		htmlWriter.print(String.valueOf(iRequest.getServerPort()));
		htmlWriter.print(iRequest.getContextPath());
		htmlWriter.print("/");
		htmlWriter.println("'>");

		// --- import stylesheets
		IFrame frame = _xmlroot.getFrame(getFrameName());
		CssStyleSheet[] styleSheets = frame.getStyleSheets();
		if(styleSheets != null)
		{
			for(int i=0; i<styleSheets.length; i++)
			{
				htmlWriter.print("<link rel='stylesheet' type='text/css' href='");
				htmlWriter.print(styleSheets[i].getFile());
				htmlWriter.println("'>");
			}
		}
		
		htmlWriter.println("</head>");
		
		htmlWriter.println("<body>");
		
		// --- render the frame
		frame.render(iRequest, iResponse);
		
		htmlWriter.println("</body>");
		htmlWriter.println("</html>");
		
		htmlWriter.flush();
		htmlWriter.close();
	}
	// ====================================================================
	// === Bean Provider methods
	// ====================================================================
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		Type t = _xmlnode_req_Context.getBeanGenericType(iName);
		if(t != null)
			return t;
		return getParentBeanGenericType(iName);
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		Class c = _xmlnode_req_Context.getBeanType(iName);
		if(c != null)
			return c;
		return getParentBeanType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		Object o = _xmlnode_req_Context.getBeanValue(iRequest, iName);
		if(o != null)
			return o;
		return getParentBeanValue(iRequest, iName);
	}
}
