package com.ebm_ws.infra.bricks.components.base.page.ctx;

import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.binding.IDataSource;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.components.base.param.UrlParameterDef;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider.UnresolvedBeanError;
import com.ebm_ws.infra.bricks.session.IPageContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Definition implements IXmlObject, IPageContextDef
{
	private Application _xmlroot;
	private IPage _xmlancestor_page;
//	private String _xmlattr_opt_Name;
	private IBoolExpr _xmlnode_opt_Authorization;
	private UrlParameterDef[] _xmlnode_0_unb_InputParameters;
	// --- local data sources
	private IDataSource[] _xmlnode_0_unb_LocalBeans;
	private IBinding[] _xmlnode_0_unb_OnLoad;
	private IBinding[] _xmlnode_0_unb_OnQuit;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	}
	public IPageContext extractContext(HttpServletRequest iRequest)
	{
		Hashtable params = null;
		if(_xmlnode_0_unb_InputParameters != null && _xmlnode_0_unb_InputParameters.length > 0)
		{
			params = new Hashtable();
			for(int i=0; i<_xmlnode_0_unb_InputParameters.length; i++)
			{
				String val = iRequest.getParameter(_xmlnode_0_unb_InputParameters[i].getName());
				if(val != null)
					params.put(_xmlnode_0_unb_InputParameters[i].getName(), val);
			}
		}
		return new PageContextImpl(params);
	}
	public void load(HttpServletRequest iRequest) throws Exception
	{
		if(_xmlnode_0_unb_OnLoad != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnLoad.length; i++)
				_xmlnode_0_unb_OnLoad[i].invoke(iRequest);
		}
	}
	public void quit(HttpServletRequest iRequest) throws Exception
	{
		if(_xmlnode_0_unb_OnQuit != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnQuit.length; i++)
				_xmlnode_0_unb_OnQuit[i].invoke(iRequest);
		}
	}
	/*
	public IPage getPage(String iPageName)
	{
		if(_xmlnode_1_unb_Pages == null)
			return null;
		if(iPageName == null)
			//return null;//???
			return _xmlnode_1_unb_Pages[0];//???
		for(int i=0; i<_xmlnode_1_unb_Pages.length; i++)
		{
			if(iPageName.equals(_xmlnode_1_unb_Pages[i].getName()))
				return _xmlnode_1_unb_Pages[i];
		}
		return null;
	}
	public IPage[] getPages()
	{
		return _xmlnode_1_unb_Pages;
	}
	*/
	/*
	public String getName()
	{
		return _xmlattr_req_Name;
	}
	*/
	public UrlParameterDef[] getInputParameters()
	{
		return _xmlnode_0_unb_InputParameters;
	}
	public boolean isAuthorized(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Authorization == null)
		{
			/*
			if(_xmlroot.getDefaultAuthorization() == null)
				return true;
			return _xmlroot.getDefaultAuthorization().eval(iRequest);
			*/
			return true;
		}
		return _xmlnode_opt_Authorization.eval(iRequest);
	}
	/*
	public IPageContextDef getRef()
	{
		return this;
	}
	*/
	@Override
	public boolean equals(Object obj)
	{
		if(obj instanceof Shared)
			return obj.equals(this);
//		System.out.println(toString()+".equals("+obj+"): "+(this == obj));
		return this == obj;
	}
	@Override
	public String toString()
	{
		return "Definition["+_xmlancestor_page.getName()+"]";
	}
	// ====================================================================
	// === Bean Provider methods
	// ====================================================================
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlnode_0_unb_LocalBeans == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_LocalBeans.length; i++)
		{
			Type t =_xmlnode_0_unb_LocalBeans[i].getBeanGenericType(iName);
			if(t != null)
				return t;
		}
		return null;
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlnode_0_unb_LocalBeans == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_LocalBeans.length; i++)
		{
			Class c =_xmlnode_0_unb_LocalBeans[i].getBeanType(iName);
			if(c != null)
				return c;
		}
		return null;
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlnode_0_unb_LocalBeans == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_LocalBeans.length; i++)
		{
			Object o =_xmlnode_0_unb_LocalBeans[i].getBeanValue(iRequest, iName);
			if(o != null)
				return o;
		}
		return null;
	}
	// ====================================================================
	// === PageContextImpl
	// ====================================================================
	private class PageContextImpl implements IPageContext
	{
		private Hashtable _inputParams;
		private Hashtable _name2Attr = new Hashtable();

		public PageContextImpl(Hashtable iInputArgs)
		{
			_inputParams = iInputArgs;
		}
		public boolean isSameContext(IPageContext iContext)
		{
			if(iContext == null)
				return false;
//			if(iContext.getContextDef() != getContextDef())
			if(!iContext.getContextDef().equals(getContextDef()))
				return false;
			
			UrlParameterDef[] contextParameters = getInputParameters();
			if(contextParameters == null || contextParameters.length == 0)
				return true;
			
			for(int i=0; i<contextParameters.length; i++)
			{
				String val1 = getInputParameter(contextParameters[i].getName());
				String val2 = iContext.getInputParameter(contextParameters[i].getName());
				if(val1 == null)
				{
					if(val2 != null)
						return false;
				}
				else
				{
					if(!val1.equals(val2))
						return false;
				}
			}
			// --- all same args
			return true;
		}
		
		public Object getAttribute(String iName)
		{
		    return _name2Attr.get(iName);
		}
		public Enumeration getAttributeNames()
		{
		    return _name2Attr.keys();
		}
		public void removeAttribute(String iName)
		{
			_name2Attr.remove(iName);
		}
		public void setAttribute(String iName, Object iValue)
		{
			_name2Attr.put(iName, iValue);
		}
		public String getInputParameter(String iName)
		{
			if(_inputParams == null)
				return null;
			return (String)_inputParams.get(iName);
		}
		public IPageContextDef getContextDef()
		{
			return Definition.this;
		}
		public boolean isNew()
		{
		    // TODO
		    return false;
		}
		public String toString()
		{
			return "PageCtx["+_inputParams+"]";
		}
	}
}
