package com.ebm_ws.infra.bricks.components.base.page.ctx;

import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.param.UrlParameterDef;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider.UnresolvedBeanError;
import com.ebm_ws.infra.bricks.session.IPageContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlSubstitutionGroup;

public interface IPageContextDef extends IXmlSubstitutionGroup
{
	public IPageContext extractContext(HttpServletRequest iRequest);
	
	public void load(HttpServletRequest iRequest) throws Exception;
	
	public void quit(HttpServletRequest iRequest) throws Exception;

	public UrlParameterDef[] getInputParameters();

	public boolean isAuthorized(HttpServletRequest iRequest);
	
	Type getBeanGenericType(String iName) throws UnresolvedBeanError;
	
	Class getBeanType(String iName) throws UnresolvedBeanError;
	
	Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception;

//	public Bean getBean(String iName);

//	public IPageContextDef getRef();

}
