package com.ebm_ws.infra.bricks.components.base.page.ctx;

import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.components.base.param.UrlParameterDef;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider.UnresolvedBeanError;
import com.ebm_ws.infra.bricks.session.IPageContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Shared implements IXmlObject, IPageContextDef
{
	private Application _xmlroot;
	private boolean _initialized = false;
	private IPageContextDef _context;
	private String _xmlattr_req_Page;
	
	// TODO: additional parameters ?
	
	public void checkThisNode(Object validSupport, IValidityLogger errors)
	{
		if(_xmlattr_req_Page != null)
		{
			if(getRefContext() == null)
				errors.logMessage(this, "Page", IValidityLogger.ERROR, "Page '"+_xmlattr_req_Page+"' not found.");
		}
	}
	private IPageContextDef getRefContext()
	{
		if(_initialized)
			return _context;
		_initialized = true;
		IPage refPage = _xmlroot.getPage(_xmlattr_req_Page);
		if(refPage != null)
			_context = refPage.getContextDef();
		return _context;
	}
	public IPageContext extractContext(HttpServletRequest iRequest)
	{
		return getRefContext().extractContext(iRequest);
	}
	public UrlParameterDef[] getInputParameters()
	{
		return getRefContext().getInputParameters();
	}
	public boolean isAuthorized(HttpServletRequest iRequest)
	{
		return getRefContext().isAuthorized(iRequest);
	}
	public void load(HttpServletRequest iRequest) throws Exception
	{
		getRefContext().load(iRequest);
	}
	public void quit(HttpServletRequest iRequest) throws Exception
	{
		getRefContext().quit(iRequest);
	}
	@Override
	public boolean equals(Object obj)
	{
//		System.out.println(toString()+".equals("+obj+")...");
		while(obj instanceof Shared)
			obj = ((Shared)obj).getRefContext();
		if(obj == null)
			return false;
		return getRefContext().equals(obj);
	}
	@Override
	public String toString()
	{
		return "Shared["+_xmlattr_req_Page+"]";
	}
	public Type getBeanGenericType(String name) throws UnresolvedBeanError
	{
		return getRefContext().getBeanGenericType(name);
	}
	public Class getBeanType(String name) throws UnresolvedBeanError
	{
		return getRefContext().getBeanType(name);
	}
	public Object getBeanValue(HttpServletRequest request, String name) throws Exception
	{
		return getRefContext().getBeanValue(request, name);
	}
}
