package com.ebm_ws.infra.bricks.components.base.validation;

import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class MinMax implements IXmlObject, IValidator
{
	private int _xmlattr_opt_Min = Integer.MIN_VALUE;
	private int _xmlattr_opt_Max = Integer.MAX_VALUE;
	
//	java.util.regex.Pattern
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	}
	public boolean isTypeValid(Class iClass)
	{
	    return String.class == iClass || ReflectionHelper.isIntegerLike(iClass);
	}
	public void checkValidity(String iItemId, Object iValue, ValidationErrors iValidation)
	{
		if(iValue == null)
			// --- allowed
			return;

		if(ReflectionHelper.isIntegerLike(iValue.getClass()))
		{
			int i = ((Number)iValue).intValue();
			if(i < _xmlattr_opt_Min)
			{
				iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.int_too_low", "bricks", new Object[]{new Integer(_xmlattr_opt_Min)}));
			}
			if(i > _xmlattr_opt_Max)
			{
				iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.int_too_high", "bricks", new Object[]{new Integer(_xmlattr_opt_Max)}));
			}
		}
		else if(iValue instanceof String)
		{
			String s = (String)iValue;
			int i = s.length();
			if(i < _xmlattr_opt_Min)
			{
				iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.str_too_low", "bricks", new Object[]{new Integer(_xmlattr_opt_Min)}));
			}
			if(i > _xmlattr_opt_Max)
			{
				iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.str_too_high", "bricks", new Object[]{new Integer(_xmlattr_opt_Max)}));
			}
		}
		else
		{
			// devrait etre dtect lors de la validation
		}
	}
}
