package com.ebm_ws.infra.bricks.components.base.validation;

import java.util.regex.Pattern;

import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class RegExp implements IXmlObject, IValidator
{
	private String _xmlattr_req_Pattern;
	private IMessage _xmlnode_opt_ErrorMessage;
	private Pattern _pattern;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		_pattern = Pattern.compile(_xmlattr_req_Pattern);
	}
	public boolean isTypeValid(Class iClass)
	{
	    return iClass == String.class;
	}
	public void checkValidity(String iItemId, Object iValue, ValidationErrors iValidation)
	{
		if(iValue == null)
			// --- allowed
			return;

		if(iValue instanceof String)
		{
			String v = ((String)iValue).trim();
			if(v.length() == 0)
				// --- allowed
				return;
			if(!_pattern.matcher(v).matches())
			{
				IValidationMessage msg = null;
				if(_xmlnode_opt_ErrorMessage == null)
					msg = new LocalizedMessage("validator.regexp.doesnt_match", "bricks");
				else
					msg = new BricksMessage(_xmlnode_opt_ErrorMessage);

				iValidation.addItemError(iItemId, msg);
			}
		}
	}
}
