package com.ebm_ws.infra.bricks.components.interfaces;

import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public abstract class BaseBeanProvider implements IBeanProvider, IXmlObject
{
	private IBeanProvider _xmlancestor_dynprovider;
	
	/*
	public abstract Type getBeanGenericType(String iName) throws UnresolvedBeanError;

	public abstract Class getBeanType(String iName) throws UnresolvedBeanError;

	public abstract Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception;
	*/

	/**
	 * Has to be overloaded
	 * @throws UnresolvedBeanError 
	 */
	protected Type getParentBeanGenericType(String iName) throws UnresolvedBeanError
	{
		/*
		Type t = getLocalBeanGenericType(iName);
		if(t != null)
			return t;
		*/
		if(_xmlancestor_dynprovider != null)
			return _xmlancestor_dynprovider.getBeanGenericType(iName);

	    return null;
	}
	/**
	 * Has to be overloaded
	 * @throws UnresolvedBeanError 
	 */
	protected Class getParentBeanType(String iName) throws UnresolvedBeanError
	{
		/*
		Class c = getLocalBeanType(iName);
		if(c != null)
			return c;
		*/
		if(_xmlancestor_dynprovider != null)
			return _xmlancestor_dynprovider.getBeanType(iName);

	    return null;
	}
	/**
	 * Retrieves the dynamic bean value from the request
	 */
	protected Object getParentBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		/*
		Object o = getLocalBeanValue(iRequest, iName);
		if(t != null)
			return t;
		*/
		if(_xmlancestor_dynprovider != null)
			return _xmlancestor_dynprovider.getBeanValue(iRequest, iName);

	    return null;
	}
}
