package com.ebm_ws.infra.bricks.error;

import javax.servlet.http.HttpServletRequest;

/**
 * This abstract class represents the base error that Bricks4WebApps
 * can handle in a nice way.
 * That is:
 *   - display localized messages,
 *   - redirect the user to a specific view point after he has acknowledged the error
 */
public abstract class IError extends Exception
{
	/**
	 * Error type: functional
	 * A functional error will lead to display a message box styled page
	 */
	public static final short FUNCTIONAL_ERROR = 0;
	/**
	 * Error type: technical
	 * A technical error will lead to display an error box styled page (with complete stack trace).
	 */
	public static final short TECHNICAL_ERROR = 1;
	
	private short type = TECHNICAL_ERROR;
	
	public IError(String message)
	{
		super(message);
	}
	public IError(String message, Throwable cause)
	{
		super(message, cause);
	}
	
	public abstract String getTitle(HttpServletRequest iRequest);

	public abstract String getMessage(HttpServletRequest iRequest);
	
	public abstract String getNextUrl();
	
	public short getType()
    {
    	return type;
    }
	/**
	 * Defines the error type (functional or technical).
	 * A functional error will lead to display a message box styled page,
	 * whereas a technical one will display an error box (with the complete stack trace).
	 * By default, an error is technical.
	 */
	public void setType(short type)
    {
    	this.type = type;
    }

	// la cause est la root exception
	// public abstract String getCause(HttpServletRequest iRequest);

	// Advice n'est pas connu de l'exception (celui qui throw) mais par celui qui catch
	// public abstract String getAdvice(HttpServletRequest iRequest);
}
