package com.ebm_ws.infra.bricks.error;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.bricks.session.BricksSession;

public class LocalizedError extends IError
{
    private static final long serialVersionUID = 1L;
	private String _msgProvider;
	private String _errorKey;
	private Object[] _args;
	private String nextUrl;
	
	public LocalizedError(String iErrorKey, String iMessageProvider, Object[] iArguments, Throwable iRootCause)
	{
		super("LocalizedError ["+iErrorKey+"]", (Throwable)iRootCause);
		
		_msgProvider = iMessageProvider;
		_errorKey = iErrorKey;
		_args = iArguments;
	}
	public LocalizedError(String iErrorKey, String iMessageProvider, Object[] iArguments)
	{
		this(iErrorKey, iMessageProvider, iArguments, null);
	}
	public LocalizedError(String iErrorKey, Object[] iArguments)
	{
		this(iErrorKey, null, iArguments, null);
	}
	public LocalizedError(String iErrorKey, Object[] iArguments, Throwable iRootCause)
	{
		this(iErrorKey, null, iArguments, iRootCause);
	}
	public LocalizedError(String iErrorKey, String iMessageProvider)
	{
		this(iErrorKey, iMessageProvider, null, null);
	}
	public LocalizedError(String iErrorKey, Throwable iRootCause)
	{
		this(iErrorKey, null, null, iRootCause);
	}
	public LocalizedError(String iErrorKey)
	{
		this(iErrorKey, null, null, null);
	}
	public String getTitle(HttpServletRequest iRequest)
	{
		BricksSession session = BricksSession.getSession(iRequest);
		MessageProvider provider = session.getApplication().getMessageProvider(_msgProvider);
		if(provider == null)
			return "!"+_errorKey+"!";
		return provider.getMessage(session.getLocale(), "error."+_errorKey+".title", _args);
	}
	public String getMessage(HttpServletRequest iRequest)
	{
		BricksSession session = BricksSession.getSession(iRequest);
		MessageProvider provider = session.getApplication().getMessageProvider(_msgProvider);
		if(provider == null)
			return "!"+_errorKey+"!";
		return provider.getMessage(session.getLocale(), "error."+_errorKey+".message", _args);
	}
	/*
	public String getCause(HttpServletRequest iRequest)
	{
		BricksSession session = BricksSession.getSession(iRequest);
		MessageProvider provider = session.getApplication().getMessageProvider(_msgProvider);
		if(provider == null)
			return "!"+_errorKey+"!";
		return provider.getMessage(session.getLocale(), "error."+_errorKey+".cause", _args);
	}
	public String getAdvice(HttpServletRequest iRequest)
	{
		// TODO: valeur par dfaut (si 'error.CODE.text' n'existe pas, ...)
		BricksSession session = BricksSession.getSession(iRequest);
		MessageProvider provider = session.getApplication().getMessageProvider(_msgProvider);
		if(provider == null)
			return "!"+_errorKey+"!";
		return provider.getMessage(session.getLocale(), "error."+_errorKey+".advice", _args);
	}
	*/
	public String getNextUrl()
    {
    	return nextUrl;
    }
	public void setNextUrl(String nextUrl)
    {
    	this.nextUrl = nextUrl;
    }
}
