package com.ebm_ws.infra.bricks.error;

import javax.servlet.http.HttpServletRequest;

public class NonLocalizedError extends IError
{
    private static final long serialVersionUID = 1L;
	private String title;
	private String msg;
	private String nextUrl;

	public NonLocalizedError(String iTitle, String iMessage, Throwable iRootCause)
	{
		super("["+iTitle+"] "+iMessage, (Throwable)iRootCause);
		
		title = iTitle;
		msg = iMessage;
	}
	public NonLocalizedError(String iTitle, String iMessage)
	{
		this(iTitle, iMessage, null);
	}
	public String getTitle(HttpServletRequest iRequest)
	{
		return title;
	}
	public String getMessage(HttpServletRequest iRequest)
	{
		return msg;
	}
	public String getNextUrl()
    {
    	return nextUrl;
    }
	/**
	 * Sets the next url to navigate after having displayed the error to the user
	 * By default, reties the last non-submit request.
	 * @param nextUrl
	 */
	public void setNextUrl(String nextUrl)
    {
    	this.nextUrl = nextUrl;
    }
}
