package com.ebm_ws.infra.bricks.impl;

import java.util.Vector;

// ======================================================================================
// === RenderUrls
// ======================================================================================
public class UrlWatcher
{
	private static UrlWatcher _installed;
	
	public static UrlWatcher getInstalled()
	{
		return _installed;
	}
	
	public void install()
	{
		_installed = this;
	}
	public void uninstall()
	{
		if(_installed == this)
			_installed = null;
	}
	
	private Vector _urlsProcessed = new Vector();
	private Vector _urlsToRender = new Vector();
	
	public void addUrl(String iUrl)
	{
		if(_urlsProcessed.contains(iUrl))
			return;
		_urlsProcessed.addElement(iUrl);
		_urlsToRender.addElement(iUrl);
	}
	public boolean hasMoreUrls()
	{
		return _urlsToRender.size() > 0;
	}
	public String nextUrl()
	{
		String url = (String)_urlsToRender.firstElement();
		_urlsToRender.removeElementAt(0);
		return url;
	}
}
