package com.ebm_ws.infra.bricks.impl.context;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.bricks.session.IPageContext;

public class BricksSessionImpl extends BricksSession
{
	private Application _site;
//	private Locale _locale;
	private ILocaleConfig localeConfig;
	private IPageContext _context;
	
	public static void enterRequest(HttpServletRequest iRequest, HttpServletResponse iResponse)
	{
		_currentRequest.set(iRequest);
		_currentResponse.set(iResponse);
	}
	public static void exitRequest()
	{
		_currentRequest.remove();
		_currentResponse.remove();
	}

	public static BricksSessionImpl getSession(HttpServletRequest iRequest)
	{
		return (BricksSessionImpl)iRequest.getSession().getAttribute("_BRICKS_CTX_");
	}
	public static void setSession(HttpServletRequest iRequest, BricksSessionImpl iSession)
	{
		iRequest.getSession().setAttribute("_BRICKS_CTX_", iSession);
	}
	public BricksSessionImpl(Application iSite)
	{
		_site = iSite;
	}
	/*
	public void setLocale(Locale locale)
	{
		_locale = locale;
	}
	public Locale getLocale()
	{
		return _locale;
	}
	*/
	@Override
	public Locale getLocale()
	{
		if(localeConfig == null)
			return null;
	    return localeConfig.getLocale();
	}
	public Application getApplication()
	{
	    return _site;
	}
	public ILocaleConfig getLocaleConfig()
    {
    	return localeConfig;
    }
	public void setLocaleConfig(ILocaleConfig localeConfig)
    {
    	this.localeConfig = localeConfig;
    }
	
	// ================================================================
	// === Page FormRenderingContext Attributes
	// ================================================================
	private Hashtable _name2Attr = new Hashtable();
	
	public Object getAttribute(String iName)
	{
	    return _name2Attr.get(iName);
	}
	public Enumeration getAttributeNames()
	{
	    return _name2Attr.keys();
	}
	public void removeAttribute(String iName)
	{
		_name2Attr.remove(iName);
	}
	public void setAttribute(String iName, Object iValue)
	{
		_name2Attr.put(iName, iValue);
	}
	
	
	public IPageContext getCurrentPageContext()
	{
		return _context;
	}
	public void setCurrentPageContext(IPageContext iContext)
	{
		_context = iContext;
	}


}
