package com.ebm_ws.infra.bricks.impl.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

import javax.servlet.ServletContext;

import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.bricks.impl.UrlWatcher;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.AttributeHolder;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.FakeRequest;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.FakeResponse;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.FakeSession;
import com.ebm_ws.infra.xmlmapping.IXmlModelMessage;
import com.ebm_ws.infra.xmlmapping.XmlInstantiator;

public class MockupGenerator
{
	private static String BRICKS_PROCESSOR = "bricks.do";

	/**
	 * The MockupGenerator program.
	 * <p>Usage:</p>
	 * <pre>MockupGenerator -xml <font color=red>&lt;input_xml&gt;</font> -outputdir <font color=red>&lt;output_dir&gt;</font> -config <font color=red>&lt;usercontext_properties&gt;</font> -messagesdir <font color=red>&lt;messages_dir&gt;</font>
	 * <p>Exemple:</p>
	 * <pre>MockupGenerator -xml <font color=red>web/bricks/Portal_S2R2UK.xml</font> -outputdir <font color=red>mockup/generated</font> -config <font color=red>mockup/config.properties&gt;</font> -messagesdir <font color=red>mockup</font>
	 * 
	 * @param args The program arguments.
	 */
	public static void main(String[] args)
	{
		// --- analyse arguments
		String xmlFile = null;
		String outputDir = null;
		String userCtxFile = null;
		String msgsRootDir = null;
		String msgBundle = null;
		String imgsRootDir = null;
		int i = 0;
		while(i < args.length)
		{
			if(args[i].equals("-xml"))
			{
				i++;
				xmlFile = args[i++];
			}
			else if(args[i].equals("-outputdir"))
			{
				i++;
				outputDir = args[i++];
			}
			else if(args[i].equals("-userctx"))
			{
				i++;
				userCtxFile = args[i++];
			}
			else if(args[i].equals("-imgsdir"))
			{
				i++;
				imgsRootDir = args[i++];
			}
			else if(args[i].equals("-msgsdir"))
			{
				i++;
				msgsRootDir = args[i++];
			}
			else if(args[i].equals("-msgsbundle"))
			{
				i++;
				msgBundle = args[i++];
			}
			else
			{
				System.out.println("Unknown argument '"+args[i++]+"'.");
			}
		}
		if(xmlFile == null)
		{
			System.out.println("specify the nav model file.");
			return;
		}
		try
		{
			System.out.println("Static Mockup Generation");
			System.out.println("------------------------");
			System.out.println(" - portal model (XML)        : "+xmlFile);
			System.out.println(" - output mockup directory   : "+outputDir);
			System.out.println(" - user context (properties) : "+userCtxFile);
			System.out.println(" - messages directory        : "+msgsRootDir);
			System.out.println(" - images root directory     : "+imgsRootDir);
			System.out.println("");
			
			// --- instanciate the message bundle loader
			MessageBundleLoader messages = new MessageBundleLoader(msgsRootDir, msgBundle);
			
			// --- 1: instantiate model
			System.out.println("1) load portal model...");
			XmlInstantiator doc = XmlInstantiator.instantiate(new FileInputStream(xmlFile), new FileValidSupport(imgsRootDir, messages));
			if(doc.hasMessages(IXmlModelMessage.VALID_WARNING))
			{
				System.out.println("Errors and Warnings:");
				doc.dumpMessages(IXmlModelMessage.VALID_WARNING, new PrintWriter(System.out));
			}
			
			// --- 2: create pages
			if(outputDir != null)
			{
				System.out.println("");
				System.out.println("2) generate mockup...");
				
				// --- create fake user context from a properties file
				Properties config = new Properties();
				if(userCtxFile != null)
					config.load(new FileInputStream(userCtxFile));
				String language = config.getProperty("Locale");
				if(language == null)
				{
					language = "fr";
					config.setProperty("Locale", language);
				}
				Locale locale = new Locale(language);
//				MockupUserContext userContext = new MockupUserContext(config);
				
				// --- load messages
				/*
				ResourceBundle messages = null;
				if(msgsRootDir != null)
				{
					// --- file base messages
					File msgFile = new File(msgsRootDir+"/messages_"+language+".properties");
					if(msgFile != null)
						messages = new PropertyResourceBundle(new FileInputStream(msgFile));
				}
				else
				{
					// --- resoures bundle
					messages = ResourceBundle.getBundle(msgBundle);
				}
				*/
				
				// --- create application state
				AttributeHolder appState = new AttributeHolder();
				
				// --- create session
				FakeSession session = new FakeSession(null);
//				session.setAttribute("userContext", userContext);
				
				// --- init output directory (cleanup / create)
				File outputdir = new File(outputDir);
				if(outputdir.exists())
				{
					// --- remove exiting generated pages
					String[] files = outputdir.list();
					for(int ifile=0; ifile<files.length; ifile++)
					{
						if(files[ifile].startsWith(BRICKS_PROCESSOR) && files[ifile].endsWith(".html"))
							new File(outputdir, files[ifile]).delete();
					}
				}
				else
				{
					// --- create output directory
					outputdir.mkdir();
				}

				// --- generate summary page
				File summary = new File(outputdir, "summary.html");
				Writer summaryWriter = new FileWriter(summary);
				summaryWriter.write("<BODY bgcolor='#DDDDDD' style='margin-left: 10px; font-family: helvetica; font-size: 10pt; color: black'>\n");
				summaryWriter.write("<span style='font-weight: bold; color: darkblue; text-decoration: underline'>Summary</span><br>\n");
				Date now = new Date();
				summaryWriter.write("Generated by: "+System.getProperty("user.name")+"<br>\n");
				SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
				summaryWriter.write("Date: "+dateFormat.format(now)+"<br>\n");
				SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
				summaryWriter.write("Time: "+timeFormat.format(now)+"<br>\n");
				summaryWriter.write("<br>User FormRenderingContext:\n");
				summaryWriter.write("<ul>\n");
				Enumeration enu = config.keys();
				while(enu.hasMoreElements())
				{
					String key = (String)enu.nextElement();
					String value = config.getProperty(key);
//					summaryWriter.write("<li><b>"+key+"</b>: "+value+"</li>\n");
//					summaryWriter.write("<li>"+key+": <b>"+value+"</b></li>\n");
					summaryWriter.write("<li>"+key+": "+value+"</li>\n");
				}
				summaryWriter.write("</ul>\n");
				summaryWriter.write("</BODY>\n");
				summaryWriter.flush();
				summaryWriter.close();

				// --- create render urls
				UrlWatcher urls = new UrlWatcher();
				urls.install();
				// --- init rendering with the default bricks url
//				support.createUrl().toUrl(null);
				
				IRequestProcessor reqProc = ((IRequestProcessor)doc.getRoot());
				while(urls.hasMoreUrls())
				{
					String url = urls.nextUrl();
					// --- generate filename
					String genFileName = toStaticFile(url)+".html";
					// --- output
					FileOutputStream output = new FileOutputStream(new File(outputdir, genFileName));
					// --- make request
					FakeRequest fakeRequest = new FakeRequest(url, locale, appState, session, "utf-8");
					FakeResponse fakeResponse = new FakeResponse(output, "utf-8", locale);
					
					System.out.println("  - making page for url '"+url+"'");
					try
					{
						reqProc.service(fakeRequest, fakeResponse);
					}
					catch(Throwable t)
					{
						System.out.println("Error:");
						t.printStackTrace();
					}
					output.flush();
					output.close();
				}
				System.out.println("... Done.");
			}
			/*
			if(xsdOutputDir != null)
			{
				System.out.println("");
				System.out.println("Generate XSD schema from code. Output: '"+xsdOutputDir+"'...");
				System.out.println("------------------------------------------------------------");
				// --- create empty document
				DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
				Document xmlDoc = docBuilder.newDocument();

				// --- generate XSD DOM
				XsdGenerator.generateXSD(xmlDoc, XsdGenerator.MANAGE_INHERITANCE);
				
				// --- output
				Transformer trans = TransformerFactory.newInstance().newTransformer();
				DOMSource source = new DOMSource(xmlDoc.getFirstChild());
				StreamResult result = new StreamResult(new File(xsdOutputDir));
				trans.transform(source, result);
				
				System.out.println("... Done.");
			}
			*/
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	private static String getRelativePath(File iDir, File iViewedFromDir)
	{
		if(iDir.equals(iViewedFromDir))
			return ".";
		String[] dirTokens = tokenizePath(iDir);
		String[] fromDirTokens = tokenizePath(iViewedFromDir);
		int i=0;
		// --- 1: skip common part of the path
		while(i<dirTokens.length && i<fromDirTokens.length && dirTokens[i].equals(fromDirTokens[i]))
			i++;
		// --- 2: build relative path
		StringBuffer sb = new StringBuffer();
		for(int j=i; j<fromDirTokens.length; j++)
		{
			if(sb.length() > 0)
				sb.append("/");
			sb.append("..");
		}
		for(int j=i; j<dirTokens.length; j++)
		{
			if(sb.length() > 0)
				sb.append("/");
			sb.append(dirTokens[i]);
		}
		
		return sb.toString();
	}
	private static String[] tokenizePath(File iFile)
	{
		String file = iFile.getAbsolutePath().replace('\\', '/');
		StringTokenizer st = new StringTokenizer(file, "/");
		String[] ret = new String[st.countTokens()];
		for(int i=0; i<ret.length; i++)
			ret[i] = st.nextToken();
		return ret;
	}
	private static String toStaticFile(String iUrl)
	{
		StringBuffer sb = new StringBuffer();
		for(int i=0; i<iUrl.length(); i++)
		{
			char c = iUrl.charAt(i);
			switch(c)
			{
			case '\\':
			case '/':
				sb.append('!');
				break;
			case '?':
				sb.append('@');
				break;
			case ':':
				sb.append('=');
				break;
			case '*':
				sb.append('#');
				break;
			case '\"':
				sb.append('\'');
				break;
			case '>':
				sb.append('}');
				break;
			case '<':
				sb.append('{');
				break;
			default:
				sb.append(c);
				break;
			}
		}
		return sb.toString();
	}
	// =================================================================
	// === Message Bundles Loader
	// =================================================================
	public static class MessageBundleLoader
	{
		private String _msgsRootDir;
		private String _msgBundle;
		private Hashtable _lang2Message = new Hashtable();
//		private ResourceBundle NULL = new ResourceBundle();
		
		public MessageBundleLoader(String iMsgsRootDir, String iMsgBundle)
		{
			_msgsRootDir = iMsgsRootDir;
			_msgBundle = iMsgBundle;
		}
		public ResourceBundle getBundle(String iLang)
		{
			ResourceBundle messages = (ResourceBundle)_lang2Message.get(iLang);
			if(messages == null)
			{
				if(_msgsRootDir != null)
				{
					// --- file base messages
					File msgFile = new File(_msgsRootDir+"/messages_"+iLang+".properties");
					if(msgFile != null)
	                    try
                        {
	                        messages = new PropertyResourceBundle(new FileInputStream(msgFile));
                        }
                        catch(FileNotFoundException e)
                        {
	                        e.printStackTrace();
                        }
                        catch(IOException e)
                        {
	                        e.printStackTrace();
                        }
				}
				else
				{
					// --- resoures bundle
					Locale loc = new Locale(iLang);
					messages = ResourceBundle.getBundle(_msgBundle, loc);
				}
				if(messages != null)
					_lang2Message.put(iLang, messages);
			}
			return messages;
		}
	}
	// =================================================================
	// === Validation Support
	// =================================================================
	public static class FileValidSupport implements IValidationSupport
	{
		private String _imagesRootDir;
		private MessageBundleLoader _messages;
		
		public FileValidSupport(String iImagesRootDir, MessageBundleLoader iMessages)
		{
			_imagesRootDir = iImagesRootDir;
			_messages = iMessages;
		}
		public ServletContext getServletContext()
		{
			// TODO Auto-generated method stub
			return null;
		}
		public boolean checkResource(String iResourcePath)
		{
		    // TODO Auto-generated method stub
		    return true;
		}
		/*
		public boolean checkMessage(String iLang, String iKey)
		{
			try
			{
				ResourceBundle rb = _messages.getBundle(iLang);
				if(rb == null)
					return false;
				String msg = rb.getString(iKey);
				return msg != null;
			}
			catch(Exception e)
			{
				return false;
			}
		}
		public boolean checkImage(String iImagePath)
		{
			File f = iImagePath.startsWith("/") || iImagePath.startsWith("\\") ? new File(_imagesRootDir+iImagePath) : new File(_imagesRootDir+"/"+iImagePath);
			return f.exists() && f.isFile();
		}
		*/
	}
}
