package com.ebm_ws.infra.bricks.impl.file.fake_j2ee;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


// ======================================================================================
// === FakeRequest
// ======================================================================================
public class FakeRequest extends AttributeHolder implements HttpServletRequest
{
	private Properties _requestParams;
	private Locale _locale;
	private HttpSession _session;
	private String _requestUrl;
	private String _queryString;
	private String _encoding;
	
	public FakeRequest(String iUrl, Locale iLocale, AttributeHolder iAppState, HttpSession iSession, String iEncoding)
	{
		// --- parse request
		_session = iSession;
		_locale = iLocale;
		_encoding = iEncoding;
		
		// --- decode Url
		_requestParams = new Properties();
		_requestUrl = iUrl;
		int idx = iUrl.indexOf('?');
		if(idx >= 0)
		{
			_requestUrl = iUrl.substring(0, idx);
			_queryString = iUrl.substring(idx+1);
			
			// --- extract parameters from query string
			StringTokenizer st = new StringTokenizer(_queryString, "&");
			while(st.hasMoreTokens())
			{
				String nameAndVal = st.nextToken();
				idx = nameAndVal.indexOf('=');
				if(idx > 0)
				{
					String name = nameAndVal.substring(0, idx);
					String val = nameAndVal.substring(idx+1);
					if(iEncoding != null)
					{
						try
                        {
	                        val = URLDecoder.decode(val, iEncoding);
                        }
                        catch(UnsupportedEncodingException e)
                        {
	                        // TODO Auto-generated catch block
	                        e.printStackTrace();
                        }
					}
					_requestParams.setProperty(name, val);
				}
			}
		}
	}
	public Locale getLocale()
	{
	    return _locale;
	}
	public String getQueryString()
	{
	    return _queryString;
	}
	public String getServletPath()
	{
	    return _requestUrl;
	}
	public String getRequestURI()
	{
	    return _requestUrl;
	}
	private String getParameter(String iKey, String iDefault)
	{
		String v = _requestParams.getProperty(iKey);
		if(v == null)
			return iDefault;
		return v;
	}
	public Enumeration getParameterNames()
	{
	    return _requestParams.keys();
	}
	public String getParameter(String iKey)
	{
		return getParameter(iKey, null);
	}
	public String getMethod()
	{
		return "GET";
	}
	public HttpSession getSession()
	{
	    return _session;
	}
	
	public String getCharacterEncoding()
    {
	    return _encoding;
    }
	public int getContentLength()
    {
	    // TODO Auto-generated method stub
	    return 0;
    }
	public String getContentType()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public ServletInputStream getInputStream() throws IOException
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public Enumeration getLocales()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public Map getParameterMap()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String[] getParameterValues(String arg0)
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getProtocol()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public BufferedReader getReader() throws IOException
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getRealPath(String arg0)
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getRemoteAddr()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getRemoteHost()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public RequestDispatcher getRequestDispatcher(String arg0)
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getScheme()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getServerName()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public int getServerPort()
    {
	    // TODO Auto-generated method stub
	    return 0;
    }
	public boolean isSecure()
    {
	    // TODO Auto-generated method stub
	    return false;
    }
	public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException
    {
	    // TODO Auto-generated method stub
	    
    }
	public String getAuthType()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getContextPath()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public Cookie[] getCookies()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public long getDateHeader(String arg0)
    {
	    // TODO Auto-generated method stub
	    return 0;
    }
	public String getHeader(String arg0)
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public Enumeration getHeaderNames()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public Enumeration getHeaders(String arg0)
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public int getIntHeader(String arg0)
    {
	    // TODO Auto-generated method stub
	    return 0;
    }
	public String getPathInfo()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getPathTranslated()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getRemoteUser()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public String getRequestedSessionId()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public StringBuffer getRequestURL()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public HttpSession getSession(boolean arg0)
    {
	    return _session;
    }
	public Principal getUserPrincipal()
    {
	    // TODO Auto-generated method stub
	    return null;
    }
	public boolean isRequestedSessionIdFromCookie()
    {
	    // TODO Auto-generated method stub
	    return false;
    }
	public boolean isRequestedSessionIdFromUrl()
    {
	    // TODO Auto-generated method stub
	    return false;
    }
	public boolean isRequestedSessionIdFromURL()
    {
	    // TODO Auto-generated method stub
	    return false;
    }
	public boolean isRequestedSessionIdValid()
    {
	    // TODO Auto-generated method stub
	    return false;
    }
	public boolean isUserInRole(String arg0)
    {
	    // TODO Auto-generated method stub
	    return false;
    }
	public String toString()
	{
		StringBuffer sb = new StringBuffer("FakeRequest[");
		sb.append("Method: ");
		sb.append(getMethod());
		sb.append(", ");
		sb.append("Url: ");
		sb.append(getServletPath());
		sb.append(", ");
		sb.append("Params: ");
		Enumeration names = getParameterNames();
		int nbParams = 0;
		while(names.hasMoreElements())
		{
			String name = (String)names.nextElement();
			String value = getParameter(name);
			if(nbParams > 0)
				sb.append("&");
			sb.append(name);
			sb.append("=");
			sb.append(value);
			nbParams++;
		}
		
		sb.append("]");
		return sb.toString();
	}
}
