package com.ebm_ws.infra.bricks.impl.j2ee;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.xmlmapping.IXmlModelMessage;
import com.ebm_ws.infra.xmlmapping.XmlEditor;
import com.ebm_ws.infra.xmlmapping.impl.ModelMessageImpl;
import com.ebm_ws.infra.xmlmapping.impl.ObjInfo;
import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.schema.ISchema;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import com.ebm_ws.infra.xmlmapping.utils.EnumHelper;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.MessagesHelper;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;

public class BricksEditor extends HttpServlet
{
    private static final long serialVersionUID = 1L;
    
    private static String BUNDLE = "com.ebm_ws.infra.bricks.impl.j2ee.BricksEditor";

	private String _charset = "UTF-8";
	private IValidationSupport _validSupport;
//	private String _msgbundle = null;
	
	private static String FORM_PREFIX = "_attr_";
	private static String ACTION_PARAM = "action";
	private static String ACTION_TARGET_ID_PARAM = "tgtid";
	private static String MAPPING_NAME_PARAM = "mapping";
	private static String VIEW_PARAM = "frame";
	private static String CUR_ELEMENT_ID_PARAM = "eltid";
//	private static String CHILD_INDEX_PARAM = "childidx";
	
//	private static String EDIT_ACTION = "edit";
//	private static String DELETE_COLLECT_ACTION = "delcoll";
	private static String DELETE_NODE_ACTION = "delnode";
//	private static String CREATE_COLLECT_ACTION = "newcoll";
	private static String CREATE_NODE_ACTION = "newnode";
	private static String SET_TYPE_ACTION = "settype";
	private static String SET_ATTRIBUTES_ACTION = "setattr";
	
	private static String XMLTREE_VIEW = "xmltree";
	
	private static String MAIN_VIEW = "main";
	
	/**
	 * Bricks Servlet Initialisation
	 */
	public void init() throws ServletException
	{
		System.err.println("BricksAdminServlet Init:");
		
		try
		{
			// --- validation support
			_validSupport = new J2EEValidator(getServletContext());
			
			System.err.println("BricksAdminServlet Init Done.");
		}
		catch(Exception e)
		{
//			_initException = e;
			System.err.println("Error while initializing BricksAdminServlet:");
			e.printStackTrace(System.err);
			/*
			if(_initException instanceof ServletException)
				throw (ServletException)_initException;
			else
				throw new ServletException(_initException);
			*/
		}
	}
	public XmlEditor getEditor(HttpServletRequest iRequest) throws ParserConfigurationException, SAXException, IOException
	{
		XmlEditor ctx = (XmlEditor)iRequest.getSession().getAttribute("XmlEditor");
		if(ctx == null)
		{
			System.out.println("initializing context...");
			ctx = new XmlEditor(_validSupport);
			String xmlfile = getInitParameter("xml");
			InputStream is = getServletContext().getResourceAsStream(xmlfile);
			ctx.load(is);
			is.close();
			
			System.out.println("Schemas: ");
			ISchema[] schemas = ctx.getSchemas().getAllSchemas();
			for(int i=0; i<schemas.length; i++)
			{
				System.out.println(" -"+i+": "+schemas[i]);
			}
			
			iRequest.getSession().setAttribute("XmlEditor", ctx);
		}
		return ctx;
	}
	public String getNiceName(Locale iLocale, IXmlObject iObj)
	{
		return MessagesHelper.getInstanceName(iLocale, iObj);
	}
	public String getMessage(Locale iLocale, String iKey, Object[] iArgs)
	{
		try
		{
			String msg = PropertyResourceBundle.getBundle(BUNDLE, iLocale).getString(iKey);
			if(iArgs != null)
				msg = MessageFormat.format(escapeForMessageFormat(msg), iArgs);
			return msg;
		}
		catch(Exception e)
		{
			return "(!)"+iKey;
		}
	}
	public String getMessage(Locale iLocale, String iKey)
	{
		return getMessage(iLocale, iKey, null);
	}

	private String getCharSet()
	{
		return _charset;
	}
	// ================================================================================
	// === Rendering methods
	// ================================================================================
	/**
	 * Bricks Servlet main service method
	 */
	public void service(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException
	{
		try
		{
			doservice(iRequest, iResponse);
		}
		catch(IOException ioe)
		{
			throw ioe;
		}
		catch(Throwable t)
		{
			renderStackPage(iRequest, iResponse, t);
		}
	}
	public void doservice(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, IllegalArgumentException, IllegalAccessException, ParserConfigurationException, SAXException
	{
		System.out.println("BricksAdminServlet.service() ("+iRequest.getMethod()+"). Params: ");
		Enumeration params = iRequest.getParameterNames();
		while(params.hasMoreElements())
		{
			String name = (String)params.nextElement();
			String value = iRequest.getParameter(name);
			System.out.println(" - ["+name+"]: ["+value+"]");
		}
		
		XmlEditor ctx = getEditor(iRequest);
		
		// --- 1: process action
		String action = iRequest.getParameter(ACTION_PARAM);
		if(action != null)
		{
			if(action.equals(DELETE_NODE_ACTION))
			{
				// --- delete child node
				String targetEltId = iRequest.getParameter(ACTION_TARGET_ID_PARAM);
				ObjInfo targetInfo = ctx.getInfoFromId(targetEltId);
				if(targetInfo != null)
					ctx.delete(targetInfo.getObject());
			}
			else if(action.equals(SET_TYPE_ACTION))
			{
				String targetEltId = iRequest.getParameter(ACTION_TARGET_ID_PARAM);
				ObjInfo targetInfo = ctx.getInfoFromId(targetEltId);
				if(targetInfo != null)
				{
					String className = iRequest.getParameter("type");
					Class c = null;
	                try
	                {
		                c = Class.forName(className);
		                ctx.changeType(targetInfo.getObject(), c);
	                }
	                catch(ClassNotFoundException e)
	                {
		                e.printStackTrace();
	                }
				}
			}
			else if(action.equals(SET_ATTRIBUTES_ACTION))
			{
				String targetEltId = iRequest.getParameter(CUR_ELEMENT_ID_PARAM);
				ObjInfo targetInfo = ctx.getInfoFromId(targetEltId);
				if(targetInfo != null)
				{
					XmlMappings mappings = XmlMappings.getMappings(targetInfo.getObject().getClass(), true);
					MappedField[] fields = mappings.getMappings(MappedField.ATTRIBUTE | MappedField.CONTENT);
					Object[] values = new Object[fields.length];
					for(int i=0; i<fields.length; i++)
					{
						MappedField fieldMapping = fields[i];
						fields[i] = fieldMapping;
						String value = iRequest.getParameter(FORM_PREFIX+fieldMapping.getName());
						if(value == null || value.trim().length() == 0)
						{
							values[i] = null;
						}
						else
						{
							// --- build value according to type
							if(String.class.isAssignableFrom(fieldMapping.getBaseClass()))
							{
								values[i] = value;
							}
							else if(int.class.isAssignableFrom(fieldMapping.getBaseClass()) || Integer.class.isAssignableFrom(fieldMapping.getBaseClass()))
							{
								values[i] = new Integer(value);
							}
							else if(boolean.class.isAssignableFrom(fieldMapping.getBaseClass()) || Boolean.class.isAssignableFrom(fieldMapping.getBaseClass()))
							{
								values[i] = new Boolean("true".equals(value));
							}
							else if(IEnumeration.class.isAssignableFrom(fieldMapping.getBaseClass()))
							{
								values[i] = EnumHelper.getItem(fieldMapping.getBaseClass(), value);
							}
							else
							{
								// --- unsupported type
							}
						}
					}

					ctx.changeValues(targetInfo.getObject(), fields, values);
				}
			}
			else if(action.equals(CREATE_NODE_ACTION))
			{
				String targetEltId = iRequest.getParameter(CUR_ELEMENT_ID_PARAM);
				ObjInfo targetInfo = ctx.getInfoFromId(targetEltId);
				if(targetInfo != null)
				{
					String mappingName = iRequest.getParameter(MAPPING_NAME_PARAM);
					XmlMappings mappings = XmlMappings.getMappings(targetInfo.getObject().getClass(), true);
					MappedField mapping = mappings.getMappingByNameAndType(mappingName, MappedField.CHILD_ELT);
					if(mapping == null)
					{
						System.out.println("create node error : mapping '"+mappingName+"' not found for class '"+targetInfo.getObject().getClass().getName()+"'");
					}
					else
					{
						// --- choose the default compatible type element to create
						ISchemaElement defaultElt = null;
						if(mapping.getBaseClass().isInterface())
						{
							// --- take the first implementor
							ISchemaElement[] implementors = ctx.getSchemas().getAllImplementors(mapping.getBaseClass());
							if(implementors != null && implementors.length > 0)
								defaultElt = implementors[0];
						}
						else
						{
							// --- directly a class
							defaultElt = ctx.getSchemas().getElement(mapping.getBaseClass());
						}
						
						if(defaultElt == null)
						{
							System.out.println("create node error : not default implementor found for type '"+mapping.getBaseClass().getName()+"' (mapping '"+mappingName+"')");
						}
						else
						{
							System.out.println("create node: create default implementor '"+defaultElt.getMappedClass().getName()+"' for mapping '"+mappingName+"'.");
							// --- get or create node container
							try
                            {
	                            ctx.add(targetInfo.getObject(), mapping, (IXmlObject)defaultElt.getMappedClass().newInstance());
                            }
                            catch(InstantiationException e)
                            {
	                            // TODO Auto-generated catch block
	                            e.printStackTrace();
                            }
						}
					}
				}
				/* TODO
				Element elt = ctx.getEditingObject();
				String mappingName = iRequest.getParameter(MAPPING_NAME_PARAM);
//				XmlMappings mappings = ctx.getSchemaElement(elt).getClassMappings();
				Class eltClass = ctx.getMappedClass(elt);
				*/
			}
			/*
			else if(action.equals(CREATE_COLLECT_ACTION))
			{
				// --- add new collected child
				Element elt = ctx.getEditingObject();
				String mappingName = iRequest.getParameter("mapping");
//				XmlMappings mappings = ctx.getSchemaElement(elt).getClassMappings();
				Class eltClass = ctx.getMappedClass(elt);
				XmlMappings mappings = XmlMappings.getMappings(eltClass, true);
				MappedField mapping = mappings.getMappingByNameAndType(mappingName, MappedField.CHILD_ELT);
				if(mapping != null)
				{
					ISchemaElement defaultElt = null;
					if(mapping.getBaseClass().isInterface())
					{
						// --- take the first implementor
						ISchemaElement[] implementors = _schemas.getAllImplementors(mapping.getBaseClass());
						if(implementors != null && implementors.length > 0)
							defaultElt = implementors[0];
					}
					else
					{
						// --- directly a class
						defaultElt = _schemas.getElement(mapping.getBaseClass());
					}
					
					if(defaultElt != null)
					{
						// --- create the corresponding element
						Element objElt = elt.getOwnerDocument().createElementNS(defaultElt.getSchema().getRootPackage(), defaultElt.getSchema().getName()+":"+defaultElt.getTagName());
						elt.appendChild(objElt);
						
						ctx.setEditingElement(objElt);
						
						// --- rebuild model
						ctx.buildModel();
					}
				}
			}
			*/
		}
		
		// --- 2: render
		String view = iRequest.getParameter(VIEW_PARAM);
		if("tree".equals(view))
		{
			// --- render the tree model
			renderTree(iRequest, iResponse);
		}
		else if(MAIN_VIEW.equals(view))
		{
			// --- render the main edition page
			renderMain(iRequest, iResponse);
		}
		else if("header".equals(view))
		{
			// --- render the header (with commands)
			renderHeader(iRequest, iResponse);
		}
		else if("errors".equals(view))
		{
			// --- render the errors
			renderErrors(iRequest, iResponse);
		}
		else if(XMLTREE_VIEW.equals(view))
		{
			// --- render the xml model
			renderTreeXml(iRequest, iResponse);
		}
		else
		{
			// --- render the frameset
			renderFrameset(iRequest, iResponse);
		}
	}
	public void renderFrameset(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException
	{
		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
		iResponse.setContentType("text/html");
		htmlWriter.write("<html>");
		htmlWriter.write("<head>");
		htmlWriter.write("<title>Bricks Administration Page</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		// no cache (for all browsers)
		htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
		htmlWriter.write("<link href='"+iRequest.getContextPath()+"/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
		htmlWriter.write("<script language='JavaScript' src='"+iRequest.getContextPath()+"/bricks_admin/js/Common.js'></script>\n");
		htmlWriter.write("</head>");
		/*
		htmlWriter.write("<frameset rows='38,*,150' framespacing='1' border='1' frameborder='yes' bordercolor='black'>");
		htmlWriter.write("	<frame name='header' src='"+iRequest.getRequestURI()+"?frame=header' scrolling='no' noresize border='0' frameborder='no'>");
		htmlWriter.write("	<frameset id='SplitFS' cols='200,*' framespacing='5' border='7' frameborder='yes' bordercolor='#FFA111'>");
		htmlWriter.write("		<frame name='tree' src='"+iRequest.getRequestURI()+"?frame=tree' scrolling='no'></frame>");
		htmlWriter.write("		<frame name='main' src='"+iRequest.getRequestURI()+"?frame=main' scrolling='yes'></frame>");
		htmlWriter.write("	</frameset>");
		htmlWriter.write("	<frame name='errors' src='"+iRequest.getRequestURI()+"?frame=errors' scrolling='yes' border='0' frameborder='no'>");
		htmlWriter.write("</frameset>");
		*/
		htmlWriter.write("<frameset rows='38,*' framespacing='1' border='1' frameborder='yes' bordercolor='black'>");
		htmlWriter.write("	<frame name='header' src='"+iRequest.getRequestURI()+"?frame=header' scrolling='no' noresize border='0' frameborder='no'>");
		htmlWriter.write("	<frameset id='SplitV' cols='200,*' framespacing='5' border='5' frameborder='yes' bordercolor='#FFA111'>");
		htmlWriter.write("		<frame name='tree' src='"+iRequest.getRequestURI()+"?frame=tree' scrolling='auto'></frame>");
		htmlWriter.write("		<frameset id='SplitH' rows='*,200' framespacing='2' border='2' frameborder='yes' bordercolor='#FFA111'>");
		htmlWriter.write("			<frame name='main' onload='onLoadMain()' src='"+iRequest.getRequestURI()+"?frame=main' scrolling='auto'></frame>");
		htmlWriter.write("			<frame name='errors' src='"+iRequest.getRequestURI()+"?frame=errors' scrolling='auto' border='0' frameborder='no'>");
		htmlWriter.write("		</frameset>");
		htmlWriter.write("	</frameset>");
		htmlWriter.write("</frameset>");
		
		htmlWriter.write("</html>");
		htmlWriter.flush();
	}
	public void renderHeader(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException
	{
		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
		iResponse.setContentType("text/html");
		htmlWriter.write("<html>\n");
		htmlWriter.write("<head>\n");
		htmlWriter.write("<title>Header</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		// no cache (for all browsers)
		htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
		htmlWriter.write("<link href='"+iRequest.getContextPath()+"/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
		htmlWriter.write("</head>\n");
		
		htmlWriter.write("<body class=Header>\n" );
		htmlWriter.write("Header\n" );
		htmlWriter.write("</body>\n");
		htmlWriter.write("</html>\n");
		htmlWriter.flush();
	}
	public void renderTree(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException
	{
		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
		iResponse.setContentType("text/html");
		htmlWriter.write("<html>\n");
		htmlWriter.write("<head>\n");
		htmlWriter.write("<title>Bricks Tree Model</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		// no cache (for all browsers)
		htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
		htmlWriter.write("<link href='"+iRequest.getContextPath()+"/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
		htmlWriter.write("<script language='JavaScript' src='"+iRequest.getContextPath()+"/bricks_admin/js/Common.js'></script>\n");
		htmlWriter.write("<script language='JavaScript' src='"+iRequest.getContextPath()+"/bricks_admin/js/Tree.js'></script>\n");
		htmlWriter.write("</head>\n");
		
		htmlWriter.write("<body class=Tree onload=\"initTree('"+iRequest.getRequestURI()+"', '"+iRequest.getContextPath()+"/bricks_admin/icons')\">\n");
		htmlWriter.write("</body>\n");
		
		htmlWriter.write("</html>\n");
		htmlWriter.flush();
	}
	public void renderTreeXml(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, ParserConfigurationException, SAXException
	{
		iResponse.setContentType("text/xml");
//		iResponse.setHeader(arg0, arg1);
		
		XmlEditor ctx = getEditor(iRequest);
		
		try
		{
			// --- 1: create the xml view
			DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document viewDoc = docBuilder.newDocument();
			IXmlObject root = ctx.getRoot();
			makeViewNode(iRequest, root, viewDoc, ctx);
			
			// --- 2: send in the response
			Writer writer = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
//			writer.write("<?xml version=\"1.0\" encoding=\""+getCharSet()+"\"?>\n");
			Transformer trans = TransformerFactory.newInstance().newTransformer();
			DOMSource source = new DOMSource(viewDoc.getDocumentElement());
			StreamResult result = new StreamResult(writer);
			trans.transform(source, result);
			
			writer.flush();
		}
		catch(Exception e)
		{
			System.err.println("Error:");
			e.printStackTrace(System.err);
		}
	}
	private void makeViewNode(HttpServletRequest iRequest, IXmlObject iObject, Node iViewParent, XmlEditor iCtx) throws IllegalArgumentException, IllegalAccessException
	{
		ObjInfo info = iCtx.getInfoFromObj(iObject);
		Class eltClass = iObject.getClass();
//		System.err.println("Creating object for element "+iObject.getNodeName());
		
		Document viewDoc = iViewParent instanceof Document ? (Document)iViewParent : iViewParent.getOwnerDocument();
		Element viewElt = viewDoc.createElement("object");
		iViewParent.appendChild(viewElt);
		// --- set id
		viewElt.setAttribute("id", info.getId());
		// --- set nice name
		viewElt.setAttribute("name", getNiceName(iRequest.getLocale(), info.getObject()));
		// --- set details
		String details = MessagesHelper.getComponentDetails(iRequest.getLocale(), eltClass);
		if(details != null)
			viewElt.setAttribute("details", details);
			
		// --- set child nodes
		XmlMappings mappings = XmlMappings.getMappings(eltClass, true);
		MappedField[] childMappings = mappings.getMappings(MappedField.CHILD_ELT | MappedField.COLLECTED_ELT);
		for(int i=0; i<childMappings.length; i++)
		{
			MappedField mapping = (MappedField)childMappings[i];
			if(mapping.getMappingType() == MappedField.CHILD_ELT)
			{
				if(mapping.getMaxOccurs() <= 1)
				{
					// --- single child node
					IXmlObject child = (IXmlObject)mapping.getField().get(iObject);
					if(child != null)
					{
						Element nodeMappingElt = viewDoc.createElement("attr");
						viewElt.appendChild(nodeMappingElt);
						nodeMappingElt.setAttribute("id", mapping.getName());
						nodeMappingElt.setAttribute("name", MessagesHelper.getAttributeName(iRequest.getLocale(), eltClass, mapping.getName()));
						String attrdetails = MessagesHelper.getAttributeDetails(iRequest.getLocale(), eltClass, mapping.getName());
						if(attrdetails != null)
							nodeMappingElt.setAttribute("details", attrdetails);

						makeViewNode(iRequest, child, nodeMappingElt, iCtx);
					}
				}
				else
				{
					// --- array mapping
					Object children = mapping.getField().get(iObject);
					int nbChildren = children == null ? 0 : Array.getLength(children);
					if(nbChildren > 0)
					{
						Element nodeMappingElt = viewDoc.createElement("attr");
						viewElt.appendChild(nodeMappingElt);
						nodeMappingElt.setAttribute("id", mapping.getName());
						nodeMappingElt.setAttribute("name", MessagesHelper.getAttributeName(iRequest.getLocale(), eltClass, mapping.getName()));
						String attrdetails = MessagesHelper.getAttributeDetails(iRequest.getLocale(), eltClass, mapping.getName());
						if(attrdetails != null)
							nodeMappingElt.setAttribute("details", attrdetails);

						for(int j=0; j<nbChildren; j++)
						{
							IXmlObject child = (IXmlObject)Array.get(children, j);
							makeViewNode(iRequest, child, nodeMappingElt, iCtx);
						}
					}
				}
			}
			else // --- collected
			{
				if(mapping.getMaxOccurs() <= 1)
				{
					// --- single child node
					IXmlObject child = (IXmlObject)mapping.getField().get(iObject);
					if(child != null)
					{
						makeViewNode(iRequest, child, viewElt, iCtx);
					}
				}
				else
				{
					// --- array mapping
					Object children = mapping.getField().get(iObject);
					int nbChildren = children == null ? 0 : Array.getLength(children);
					if(nbChildren > 0)
					{
						for(int j=0; j<nbChildren; j++)
						{
							IXmlObject child = (IXmlObject)Array.get(children, j);
							makeViewNode(iRequest, child, viewElt, iCtx);
						}
					}
				}
			}
		}
	}
	public void renderMain(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, IllegalArgumentException, IllegalAccessException, ParserConfigurationException, SAXException
	{
		Locale locale = iRequest.getLocale();

		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
		iResponse.setContentType("text/html");
		htmlWriter.write("<html>\n");
		htmlWriter.write("<head>\n");
		htmlWriter.write("<title>Bricks Main Editor</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		// no cache (for all browsers)
		htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
		htmlWriter.write("<link href='"+iRequest.getContextPath()+"/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
		htmlWriter.write("</head>\n");
		
		htmlWriter.write("<script language=JavaScript>\n");
		
		htmlWriter.write("function getAbsPos(obj, relativeToObj)\n");
		htmlWriter.write("{\n");
		htmlWriter.write("	var topOffset = 0;\n");
		htmlWriter.write("	var leftOffset = 0;\n");
		htmlWriter.write("	if(relativeToObj == null) relativeToObj = document.body;\n");
//		htmlWriter.write("	// --- IE, Netscape>=7, mozilla, ...\n");
		htmlWriter.write("	while(true)\n");
		htmlWriter.write("	{\n");
		htmlWriter.write("		topOffset += obj.offsetTop;\n");
		htmlWriter.write("		leftOffset += obj.offsetLeft;\n");
		htmlWriter.write("		obj = obj.offsetParent;\n");
		htmlWriter.write("		if(!obj) break;\n");
		htmlWriter.write("		if(relativeToObj && relativeToObj == obj) break;\n");
		htmlWriter.write("		topOffset -= obj.scrollTop;\n");
		htmlWriter.write("		leftOffset -= obj.scrollLeft;\n");
		htmlWriter.write("	}\n");
		htmlWriter.write("	return [leftOffset, topOffset];\n");
		htmlWriter.write("}\n");

		htmlWriter.write("function getAncestor(elt, tag)\n");
		htmlWriter.write("{\n");
		htmlWriter.write("	while(elt.parentNode != null && elt.nodeName != tag)\n");
		htmlWriter.write("		elt = elt.parentNode;\n");
		htmlWriter.write("	return elt;\n");
		htmlWriter.write("}\n");
		
		htmlWriter.write("function showPopup(evt, obj, id)\n");
		htmlWriter.write("{\n");
		htmlWriter.write("	var div = document.getElementById(id);\n");
		htmlWriter.write("	if(!div) return;\n");
//		htmlWriter.write("	var src = window.event ? event.srcElement : evt.target;\n");
//		htmlWriter.write("	src = getAncestor(src, 'A');\n");
		htmlWriter.write("	var pos = getAbsPos(obj);\n");
		htmlWriter.write("	div.style.top = pos[1]+obj.offsetHeight;\n");
		htmlWriter.write("	var left = pos[0];\n");
		htmlWriter.write("	if(left+div.offsetWidth > document.body.clientWidth)\n");
		htmlWriter.write("		left = document.body.clientWidth - div.offsetWidth;\n");
		htmlWriter.write("	div.style.left = left;\n");
		htmlWriter.write("	div.style.visibility = 'visible';\n");
		htmlWriter.write("}\n");
		
		htmlWriter.write("function hidePopup(evt, id)\n");
		htmlWriter.write("{\n");
		htmlWriter.write("	var div = document.getElementById(id);\n");
		htmlWriter.write("	if(!div) return;\n");
		htmlWriter.write("	div.style.visibility = 'hidden';\n");
		htmlWriter.write("}\n");
		htmlWriter.write("</script>\n");

		htmlWriter.write("<body class=Main>\n");
		
		XmlEditor ctx = getEditor(iRequest);
		String curid = iRequest.getParameter(CUR_ELEMENT_ID_PARAM);
		
		ObjInfo info = null;
		if(curid != null)
			info = ctx.getInfoFromId(curid);
		if(info == null)
			info = ctx.getInfoFromObj(ctx.getRoot());
		
		IXmlObject curObj = info.getObject();
		Class eltClass = curObj.getClass();
		XmlMappings mappings = XmlMappings.getMappings(eltClass, true);
		MappedField parentMapping = info.getParentMapping();
		
//TODO		System.out.println("Editing element: nodename="+curElt.getNodeName()+", ns="+curElt.getNamespaceURI()+", localname="+curElt.getLocalName()+", prefix="+curElt.getPrefix()+", obj: "+curElt);
		System.out.println("Mapped class: "+eltClass.getName());
//		System.out.println("Parent Mapping: "+parentMapping);
		
		// --- breadcrumb
		// --------------
		Vector ancestors = new Vector();
		ObjInfo oi = info.getParent();
		while(oi != null)
		{
			ancestors.insertElementAt(oi, 0);
			oi = oi.getParent();
		}
		for(int i=0; i<ancestors.size(); i++)
		{
			oi = (ObjInfo)ancestors.elementAt(i);
			htmlWriter.write("&nbsp;&gt;&nbsp;");
			htmlWriter.write("<a href='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+CUR_ELEMENT_ID_PARAM+"="+oi.getIdPath()+"'>" );
			htmlWriter.write(getNiceName(iRequest.getLocale(), oi.getObject()));
			htmlWriter.write("</a>\n");
		}
		


		// --- title
		// ---------
		htmlWriter.write("<h1>");
		htmlWriter.write(getNiceName(iRequest.getLocale(), info.getObject()));
		htmlWriter.write("</h1>\n");
		String objDetails = MessagesHelper.getComponentDetails(locale, eltClass);
		if(objDetails != null)
		{
			htmlWriter.write("<h3>");
			htmlWriter.write(objDetails);
			htmlWriter.write("</h3>\n");
		}
		
		// --- global errors
		IXmlModelMessage[] messages = ctx.getGlobalElementMessages(curObj);
		if(messages != null)
		{
			htmlWriter.write("<div class=GlobalErrors>\n");
			htmlWriter.write(" "+messages.length+" global messages!");
			htmlWriter.write("</div>\n");
		}

		htmlWriter.write("<table border=0 cellpadding=0 cellspacing=0 class=Form>\n" );
		int row = 1;
		// --- type
		// --------
		htmlWriter.write("<tr class=even>\n");
		htmlWriter.write("<td class=AttrName align=right valign=top>" );
		htmlWriter.write(getMessage(locale, "ObjForm.Type.Label"));
		htmlWriter.write("</td>\n");
		
		ISchemaElement[] compatibleTypes = null;
		if(parentMapping == null)
		{
			// --- this is the top element: it can only be a IRequestProcessor
			compatibleTypes = ctx.getSchemas().getAllImplementors(IRequestProcessor.class);
		}
		else
		{
			if(parentMapping.getBaseClass().isInterface())
				compatibleTypes = ctx.getSchemas().getAllImplementors(parentMapping.getBaseClass());
			else
				compatibleTypes = new ISchemaElement[]{ctx.getSchemas().getElement(parentMapping.getBaseClass())};
		}
		
		htmlWriter.write("<td class=AttrValue align=left valign=top>\n" );
		if(compatibleTypes.length == 1)
		{
			// --- no choice of type
			htmlWriter.write(compatibleTypes[0].getTagName());
		}
		else
		{
			// --- allow choice on type
			htmlWriter.write("<form method=post action='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+SET_TYPE_ACTION+"&"+CUR_ELEMENT_ID_PARAM+"="+curid+"'>\n");
			htmlWriter.write("<select name='type' onchange='this.form.submit()'>\n");
			for(int i=0; i<compatibleTypes.length; i++)
			{
				htmlWriter.write("<option value='");
				htmlWriter.write(compatibleTypes[i].getMappedClass().getName());
				htmlWriter.write("'");
				if(compatibleTypes[i].getMappedClass() == eltClass)
					htmlWriter.write(" selected");
				htmlWriter.write(">");
				htmlWriter.write(compatibleTypes[i].getTagName());
				htmlWriter.write("</option>\n");
			}
			htmlWriter.write("</select>\n");
			htmlWriter.write("</form>\n");
		}
		htmlWriter.write("</td>\n");

		htmlWriter.write("<td class=AttrErrors align=left valign=top>\n" );
		htmlWriter.write("&nbsp;</td>\n");

		htmlWriter.write("</tr>\n");
		
		// --- attributes
		// --------------
		MappedField[] attrMappings = mappings.getMappings(MappedField.ATTRIBUTE | MappedField.CONTENT);
		if(attrMappings != null && attrMappings.length > 0)
		{
			htmlWriter.write("<form method=post action='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+SET_ATTRIBUTES_ACTION+"&"+CUR_ELEMENT_ID_PARAM+"="+curid+"'>\n");

			htmlWriter.write("<tr class=Title>\n");
//			htmlWriter.write("<td>&nbsp;</td>" );
			htmlWriter.write("<td colspan=3>");
			htmlWriter.write(getMessage(locale, "ObjForm.Attributes"));
			htmlWriter.write("</td>\n");
			htmlWriter.write("</tr>\n");

			for(int i=0; i<attrMappings.length; i++)
			{
				MappedField mapping = (MappedField)attrMappings[i];
				renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
			}
			
			// --- submit button
			htmlWriter.write("<tr class=Buttons>\n");
			htmlWriter.write("<td>&nbsp;</td>");
			htmlWriter.write("<td align=left colspan=2>\n");
			htmlWriter.write("<input type=submit value='"+getMessage(locale, "ObjForm.Submit.Label")+"'>\n");
			htmlWriter.write("</td>\n");
			htmlWriter.write("</tr>\n");
			
			htmlWriter.write("</form>\n");
		}

		MappedField[] childMappings = mappings.getMappings(MappedField.CHILD_ELT);
		MappedField[] collectMappings = mappings.getMappings(MappedField.COLLECTED_ELT);
		if(childMappings.length+collectMappings.length > 0)
		{
			htmlWriter.write("<tr class=Title>\n");
//			htmlWriter.write("<td>&nbsp;</td>" );
			htmlWriter.write("<td colspan=3>");
			htmlWriter.write(getMessage(locale, "ObjForm.Elements"));
			htmlWriter.write("</td>\n");
			htmlWriter.write("</tr>\n");
		}
		// --- single child nodes
		for(int i=0; i<childMappings.length; i++)
		{
			MappedField mapping = (MappedField)childMappings[i];
			if(mapping.getMaxOccurs() <= 1)
				renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
		}
		
		// --- single collected nodes
		for(int i=0; i<collectMappings.length; i++)
		{
			MappedField mapping = (MappedField)collectMappings[i];
			if(mapping.getMaxOccurs() <= 1)
				renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
		}
		
		// --- array child nodes
		for(int i=0; i<childMappings.length; i++)
		{
			MappedField mapping = (MappedField)childMappings[i];
			if(mapping.getMaxOccurs() > 1)
				renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
		}
		
		// --- array collected nodes
		for(int i=0; i<collectMappings.length; i++)
		{
			MappedField mapping = (MappedField)collectMappings[i];
			if(mapping.getMaxOccurs() > 1)
				renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
		}
		
		htmlWriter.write("</table>\n" );
		htmlWriter.write("</body>\n");
		
		htmlWriter.write("</html>\n");
		htmlWriter.flush();
	}
	public void renderMappingField(HttpServletRequest iRequest, Writer htmlWriter, ObjInfo info, Class eltClass, int iRow, MappedField mapping) throws IOException, IllegalArgumentException, IllegalAccessException, ParserConfigurationException, SAXException
	{
		XmlEditor ctx = getEditor(iRequest);
		IXmlObject curObj = info.getObject();
		Locale locale = iRequest.getLocale();
		boolean even = (iRow % 2) == 0;
		
		htmlWriter.write("<tr class="+(even ? "even" : "odd")+">\n");
		
		// --- 1: mapping name
		htmlWriter.write("<td class=AttrName align=right valign=top nowrap>");
		String name = MessagesHelper.getAttributeName(locale, eltClass, mapping.getName());
		String details = MessagesHelper.getAttributeDetails(locale, eltClass, mapping.getName());
		if(details != null)
		{
			htmlWriter.write(" <span style='text-decoration: underline' title=\"");
			htmlWriter.write(details);
			htmlWriter.write("\">");
			htmlWriter.write(name+":");
			htmlWriter.write("</span>");
		}
		else
		{
			htmlWriter.write(name+":");
		}
		htmlWriter.write("</td>\n");
		
		// --- 2: mapping value
		htmlWriter.write("<td class=AttrValue align=left valign=top nowrap>\n");
		if(mapping.getMappingType() == MappedField.ATTRIBUTE)
		{
			// --- attribute mapping
//			String strVal = curObj.getAttribute(mapping.getName());
			Object val = mapping.getField().get(curObj);
			if(String.class.isAssignableFrom(mapping.getBaseClass()))
			{
				// --- field is of type String
				String strVal = (String)val;
				htmlWriter.write("<input name='"+FORM_PREFIX+mapping.getName()+"' type=text value='"+(strVal == null ? "" : strVal)+"'>\n");
			}
			else if(int.class.isAssignableFrom(mapping.getBaseClass()) || Integer.class.isAssignableFrom(mapping.getBaseClass()))
			{
				// --- field is of type int
				//TODO: specific editor
				Integer intVal = (Integer)val;
				htmlWriter.write("<input name='"+FORM_PREFIX+mapping.getName()+"' type=text value='"+(intVal == null ? "" : intVal)+"'>\n");
				//TODO: how to unset? --> empty
			}
			else if(boolean.class.isAssignableFrom(mapping.getBaseClass()) || Boolean.class.isAssignableFrom(mapping.getBaseClass()))
			{
				// --- field is of type boolean
				Boolean boolVal = (Boolean)val;
				if(boolVal == null)
					boolVal = Boolean.FALSE;
				htmlWriter.write("<select name='"+FORM_PREFIX+mapping.getName()+"'>\n");
				htmlWriter.write("<option class=null value=''"+(boolVal == null ? " selected" : "" )+">");
				htmlWriter.write(getMessage(locale, "ObjForm.Object.Null"));
				htmlWriter.write("</option>\n");
				htmlWriter.write("<option value='true'"+(boolVal == Boolean.TRUE ? " selected" : "" )+">");
				htmlWriter.write(getMessage(locale, "ObjForm.Boolean.True"));
				htmlWriter.write("</option>\n");
				htmlWriter.write("<option value='false'"+(boolVal == Boolean.FALSE ? " selected" : "" )+">");
				htmlWriter.write(getMessage(locale, "ObjForm.Boolean.False"));
				htmlWriter.write("</option>\n");
				htmlWriter.write("</select>\n");
			}
			else if(IEnumeration.class.isAssignableFrom(mapping.getBaseClass()))
			{
				// --- field is an enumerated type
				htmlWriter.write("<select name='"+FORM_PREFIX+mapping.getName()+"'>\n");
				htmlWriter.write("<option class=null value=''"+(val == null ? " selected" : "" )+">");
				htmlWriter.write(getMessage(locale, "ObjForm.Object.Null"));
				htmlWriter.write("</option>\n");
				int nbElts = EnumHelper.getNbOfItems(mapping.getBaseClass());
				for(int j=0; j<nbElts; j++)
				{
					String eltName = EnumHelper.getItemName(mapping.getBaseClass(), j);
					IEnumeration curVal = EnumHelper.getItem(mapping.getBaseClass(), j);
					htmlWriter.write("<option value='"+eltName+"'"+(curVal.equals(val) ? " selected" : "" )+">");
					htmlWriter.write(eltName);
					htmlWriter.write("</option>\n");
				}
				htmlWriter.write("</select>\n");
			}
			else
			{
				htmlWriter.write("unsuppported type: ");
				htmlWriter.write(mapping.getBaseClass().getName());
			}
		}
		else if(mapping.getMappingType() == MappedField.CONTENT)
		{
			// --- textual content
			Object val = mapping.getField().get(curObj);
			String content = (String)val;
			if(content == null)
				content = "";
			htmlWriter.write("<textarea name='"+FORM_PREFIX+mapping.getName()+"'>");
			//TODO: encode as html and manage change request
			htmlWriter.write(content);
			htmlWriter.write("</textarea>\n");
		}
		else if(mapping.getMappingType() == MappedField.CHILD_ELT)
		{
			if(mapping.getMaxOccurs() <= 1)
			{
				// --- single child element
				IXmlObject child = (IXmlObject)mapping.getField().get(curObj);
				if(child == null)
				{
					// --- unset: link causes a create
					htmlWriter.write("<a href='");
					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+CREATE_NODE_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
					htmlWriter.write("'");
					htmlWriter.write(" title='");
					htmlWriter.write(getMessage(locale, "action.create"));
					htmlWriter.write("'>");
					htmlWriter.write("<img src='");
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/new_16.gif");
					htmlWriter.write("'>");
					htmlWriter.write("</a>\n");
					
					htmlWriter.write("&nbsp;&lt;");
					htmlWriter.write(getMessage(locale, "ObjForm.Object.Null"));
					htmlWriter.write("&gt;");
				}
				else
				{
					// --- set: link causes an edit (+delete action)
					ObjInfo childInfo = ctx.getInfoFromObj(child);
					htmlWriter.write("<a href='");
//					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_NODE_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CHILD_INDEX_PARAM+"=0");
					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_NODE_ACTION+"&"+ACTION_TARGET_ID_PARAM+"="+childInfo.getIdPath()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
					htmlWriter.write("'");
					htmlWriter.write(" title='");
					htmlWriter.write(getMessage(locale, "action.delete"));
					htmlWriter.write("'>");
					htmlWriter.write("<img src='");
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/trash_16.gif");
					htmlWriter.write("'>");
					htmlWriter.write("</a>\n");

					htmlWriter.write("&nbsp;");

					htmlWriter.write("<a href='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+CUR_ELEMENT_ID_PARAM+"="+childInfo.getIdPath()+"'>");
					htmlWriter.write(getNiceName(iRequest.getLocale(), childInfo.getObject()));
					htmlWriter.write("</a>\n");
				}
			}
			else
			{
				// --- array child elements
				Object children = mapping.getField().get(curObj);
				int nbChidren = children == null ? 0 : Array.getLength(children);
				
				htmlWriter.write("<table border=1 cellpadding=0 cellspacing=0 class=List>\n");
				// --- headers
				htmlWriter.write("<tr>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.index"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.delete"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.object"));
				htmlWriter.write("</th>\n");
				/*
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.up"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.down"));
				htmlWriter.write("</th>\n");
				*/
				htmlWriter.write("<th colspan=2>");
				htmlWriter.write(getMessage(locale, "list.move"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("</tr>\n");
				
				if(nbChidren == 0)
				{
					htmlWriter.write("<tr>\n");
					htmlWriter.write("<td colspan=5>\n");
					htmlWriter.write(getMessage(locale, "list.empty"));
					htmlWriter.write("</td>\n");
					htmlWriter.write("</tr>\n");
				}
				else
				{
					// --- set: link causes an edit
					for(int j=0; j<nbChidren; j++)
					{
						IXmlObject child = (IXmlObject)Array.get(children, j);
						ObjInfo childInfo = ctx.getInfoFromObj(child);
						htmlWriter.write("<tr>\n");
						// --- index
						htmlWriter.write("<td align=center>");
						htmlWriter.write(String.valueOf(j));
						htmlWriter.write("</td>\n");
						
						// --- delete
						htmlWriter.write("<td align=center>");
						htmlWriter.write("<a href='");
//						htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_NODE_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CHILD_INDEX_PARAM+"="+j);
						htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_NODE_ACTION+"&"+ACTION_TARGET_ID_PARAM+"="+childInfo.getIdPath()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
						htmlWriter.write("'");
						htmlWriter.write(" title='");
						htmlWriter.write(getMessage(locale, "action.delete"));
						htmlWriter.write("'>");
						htmlWriter.write("<img src='");
						htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/trash_16.gif");
						htmlWriter.write("'>");
						htmlWriter.write("</a>\n");
						htmlWriter.write("</td>\n");
						
						// --- object
						htmlWriter.write("<td align=left nowrap>\n");
						htmlWriter.write("<a href='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+CUR_ELEMENT_ID_PARAM+"="+childInfo.getIdPath()+"'>");
						htmlWriter.write(getNiceName(iRequest.getLocale(), childInfo.getObject()));
						htmlWriter.write("</a>\n");
						htmlWriter.write("</td>\n");
						
						// --- up
						htmlWriter.write("<td align=center>");
						if(j > 0)
						{
							htmlWriter.write("<a href='");
							htmlWriter.write("#");
							htmlWriter.write("'");
							htmlWriter.write(" title='");
							htmlWriter.write(getMessage(locale, "action.up"));
							htmlWriter.write("'>");
							htmlWriter.write("<img src='");
							htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/up_16.gif");
							htmlWriter.write("'>");
							htmlWriter.write("</a>");
						}
						else
						{
							htmlWriter.write("&nbsp;");
						}
						htmlWriter.write("</td>\n");
						
						// --- down
						htmlWriter.write("<td align=center>");
						if(j < nbChidren-1)
						{
							htmlWriter.write("<a href='");
							htmlWriter.write("#");
							htmlWriter.write("'");
							htmlWriter.write(" title='");
							htmlWriter.write(getMessage(locale, "action.down"));
							htmlWriter.write("'>");
							htmlWriter.write("<img src='");
							htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/down_16.gif");
							htmlWriter.write("'>");
							htmlWriter.write("</a>");
						}
						else
						{
							htmlWriter.write("&nbsp;");
						}
						htmlWriter.write("</td>\n");
												
						htmlWriter.write("</tr>\n");
					}
					
					//TODO: add delete button (if allowed ?)
				}
				// --- add button
				if(nbChidren < mapping.getMaxOccurs())
				{
					htmlWriter.write("<tr>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("<th nowrap>\n");
					htmlWriter.write("<a href='");
					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+CREATE_NODE_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
					htmlWriter.write("'");
					htmlWriter.write(" title='");
					htmlWriter.write(getMessage(locale, "action.add"));
					htmlWriter.write("'>");
					htmlWriter.write("<img src='");
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/new_16.gif");
					htmlWriter.write("'>");
					htmlWriter.write("&nbsp;");
					htmlWriter.write(getMessage(locale, "action.add"));
					htmlWriter.write("</a>\n");
					htmlWriter.write("</th>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("</tr>\n");
				}
				htmlWriter.write("</table>\n" );
			}
		}
		else if(mapping.getMappingType() == MappedField.COLLECTED_ELT)
		{
			if(mapping.getMaxOccurs() <= 1)
			{
				// --- single collected element
				IXmlObject child = (IXmlObject)mapping.getField().get(curObj);
				
				if(child == null)
				{
					// --- unset: link causes a create
					htmlWriter.write("<a href='");
					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+CREATE_NODE_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
					htmlWriter.write("'");
					htmlWriter.write(" title='");
					htmlWriter.write(getMessage(locale, "action.create"));
					htmlWriter.write("'>");
					htmlWriter.write("<img src='");
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/new_16.gif");
					htmlWriter.write("'>");
					htmlWriter.write("</a>\n");
					
					htmlWriter.write("&nbsp;");
					
					htmlWriter.write("&lt;");
					htmlWriter.write(getMessage(locale, "ObjForm.Object.Null"));
					htmlWriter.write("&gt;");
				}
				else
				{
					// --- set: link causes an edit
					ObjInfo childInfo = ctx.getInfoFromObj(child);
					htmlWriter.write("<a href='");
//					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_COLLECT_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CHILD_INDEX_PARAM+"="+childEltIndex);
					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_NODE_ACTION+"&"+ACTION_TARGET_ID_PARAM+"="+childInfo.getIdPath()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
					htmlWriter.write("'");
					htmlWriter.write(" title='");
					htmlWriter.write(getMessage(locale, "action.delete"));
					htmlWriter.write("'>");
					htmlWriter.write("<img src='");
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/trash_16.gif");
					htmlWriter.write("'>");
					htmlWriter.write("</a>\n");
					
					htmlWriter.write("&nbsp;");
					
					htmlWriter.write("<a href='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+CUR_ELEMENT_ID_PARAM+"="+childInfo.getIdPath()+"'>");
					htmlWriter.write(getNiceName(iRequest.getLocale(), childInfo.getObject()));
					htmlWriter.write("</a>\n");
				}
			}
			else
			{
				// --- array collected elements
				Object children = mapping.getField().get(curObj);
				int nbChidren = children == null ? 0 : Array.getLength(children);
				
				htmlWriter.write("<table border=1 cellpadding=0 cellspacing=0 class=List>\n");
				// --- headers
				htmlWriter.write("<tr>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.index"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.delete"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.object"));
				htmlWriter.write("</th>\n");
				/*
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.up"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("<th>");
				htmlWriter.write(getMessage(locale, "list.down"));
				htmlWriter.write("</th>\n");
				*/
				htmlWriter.write("<th colspan=2>");
				htmlWriter.write(getMessage(locale, "list.move"));
				htmlWriter.write("</th>\n");
				htmlWriter.write("</tr>\n");
				
				if(nbChidren == 0)
				{
					htmlWriter.write("<tr>\n");
					htmlWriter.write("<td colspan=5>\n");
					htmlWriter.write(getMessage(locale, "list.empty"));
					htmlWriter.write("</td>\n");
					htmlWriter.write("</tr>\n");
				}
				else
				{
					// --- set: link causes an edit
					for(int j=0; j<nbChidren; j++)
					{
						IXmlObject child = (IXmlObject)Array.get(children, j);
						ObjInfo childInfo = ctx.getInfoFromObj(child);
						htmlWriter.write("<tr>\n");
						
						// --- index
						htmlWriter.write("<td align=center>");
						htmlWriter.write(String.valueOf(j));
						htmlWriter.write("</td>\n");
						
						// --- delete
						htmlWriter.write("<td align=center>");
						htmlWriter.write("<a href='");
//						htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_COLLECT_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CHILD_INDEX_PARAM+"="+index);
						htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+DELETE_NODE_ACTION+"&"+ACTION_TARGET_ID_PARAM+"="+childInfo.getIdPath()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
						htmlWriter.write("'");
						htmlWriter.write(" title='");
						htmlWriter.write(getMessage(locale, "action.delete"));
						htmlWriter.write("'>");
						htmlWriter.write("<img src='");
						htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/trash_16.gif");
						htmlWriter.write("'>");
						htmlWriter.write("</a>\n");
						htmlWriter.write("</td>\n");
						
						// --- object
						htmlWriter.write("<td align=left nowrap>\n");
						htmlWriter.write("<a href='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+CUR_ELEMENT_ID_PARAM+"="+childInfo.getIdPath()+"'>");
						htmlWriter.write(getNiceName(iRequest.getLocale(), childInfo.getObject()));
						htmlWriter.write("</a>\n");
						htmlWriter.write("</td>\n");
						
						// --- up
						htmlWriter.write("<td align=center>");
						if(j > 0)
						{
							htmlWriter.write("<a href='");
							htmlWriter.write("#");
							htmlWriter.write("'");
							htmlWriter.write(" title='");
							htmlWriter.write(getMessage(locale, "action.up"));
							htmlWriter.write("'>");
							htmlWriter.write("<img src='");
							htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/up_16.gif");
							htmlWriter.write("'>");
							htmlWriter.write("</a>");
						}
						else
						{
							htmlWriter.write("&nbsp;");
						}
						htmlWriter.write("</td>\n");
						
						// --- down
						htmlWriter.write("<td align=center>");
						if(j < nbChidren-1)
						{
							htmlWriter.write("<a href='");
							htmlWriter.write("#");
							htmlWriter.write("'");
							htmlWriter.write(" title='");
							htmlWriter.write(getMessage(locale, "action.down"));
							htmlWriter.write("'>");
							htmlWriter.write("<img src='");
							htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/down_16.gif");
							htmlWriter.write("'>");
							htmlWriter.write("</a>");
						}
						else
						{
							htmlWriter.write("&nbsp;");
						}
						htmlWriter.write("</td>\n");
												
						htmlWriter.write("</tr>\n");
					}
				}
				// --- add button
				if(nbChidren < mapping.getMaxOccurs())
				{
					htmlWriter.write("<tr>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("<th nowrap>\n");
					htmlWriter.write("<a href='");
//					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+CREATE_COLLECT_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName());
					htmlWriter.write(iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+ACTION_PARAM+"="+CREATE_NODE_ACTION+"&"+MAPPING_NAME_PARAM+"="+mapping.getName()+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath());
					htmlWriter.write("'");
					htmlWriter.write(" title='");
					htmlWriter.write(getMessage(locale, "action.add"));
					htmlWriter.write("'>");
					htmlWriter.write("<img src='");
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/new_16.gif");
					htmlWriter.write("'>");
					htmlWriter.write("&nbsp;");
					htmlWriter.write(getMessage(locale, "action.add"));
					htmlWriter.write("</a>\n");
					htmlWriter.write("</th>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("<th>&nbsp;</th>\n");
					htmlWriter.write("</tr>\n");
				}
				htmlWriter.write("</table>\n" );
			}
		}
		htmlWriter.write("</td>\n");
		
		// --- 3: mapping messages (error / warning / info)
		IXmlModelMessage[] messages = ctx.getMappingElementMessages(curObj, mapping.getName());
		htmlWriter.write("<td class=AttrErrors align=left valign=top nowrap>\n");
		if(messages != null)
		{
			int nbErrors = 0;
			int nbWarnings = 0;
			int nbInfos = 0;
			// --- 1: render DIV that contains the list of messages
			htmlWriter.write("<div id='Err"+mapping.getName()+"' class=Errors style='position: absolute; display: inline; visibility: hidden;'>\n");
			htmlWriter.write("<table border=0 cellpadding=0 cellspacing=2>\n");
			for(int i=0; i<messages.length; i++)
			{
				htmlWriter.write("<tr>\n");
				// --- icon cell
				htmlWriter.write("<td align=center valign=middle>");
				htmlWriter.write("<img src='");
				switch(messages[i].getSeverity())
				{
				case IXmlModelMessage.INST_ERROR:
				case IXmlModelMessage.VALID_ERROR:
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Error.gif");
					nbErrors++;
					break;
				case IXmlModelMessage.INST_WARNING:
				case IXmlModelMessage.VALID_WARNING:
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Warning.gif");
					nbWarnings++;
					break;
				default:
					htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Info.gif");
					nbInfos++;
					break;
				}
				htmlWriter.write("'>");
				htmlWriter.write("</td>\n");
				// --- message cell
				htmlWriter.write("<td align=left valign=middle>");
				htmlWriter.write(messages[i].getMessage());
				htmlWriter.write("</td>\n");
				
				htmlWriter.write("</tr>\n");
			}
			htmlWriter.write("</table>\n");
			htmlWriter.write("</div>\n");

			
			htmlWriter.write("<span class=Errors onmouseover=\"showPopup(event, this, 'Err"+mapping.getName()+"')\" onmouseout=\"hidePopup(event, 'Err"+mapping.getName()+"')\">\n");
			if(nbErrors > 0)
			{
				htmlWriter.write("<img src='");
				htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Error.gif");
				htmlWriter.write("'>");
				htmlWriter.write("&nbsp;:&nbsp;");
				htmlWriter.write(String.valueOf(nbErrors));
			}
			if(nbWarnings > 0)
			{
				if(nbErrors > 0)
					htmlWriter.write(",&nbsp;");
				htmlWriter.write("<img src='");
				htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Warning.gif");
				htmlWriter.write("'>");
				htmlWriter.write("&nbsp;:&nbsp;");
				htmlWriter.write(String.valueOf(nbWarnings));
			}
			if(nbInfos > 0)
			{
				if(nbErrors+nbWarnings > 0)
					htmlWriter.write(",&nbsp;");
				htmlWriter.write("<img src='");
				htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Info.gif");
				htmlWriter.write("'>");
				htmlWriter.write("&nbsp;:&nbsp;");
				htmlWriter.write(String.valueOf(nbInfos));
			}
			htmlWriter.write("</span>\n");
		}
		htmlWriter.write("&nbsp;</td>\n");
		
		htmlWriter.write("</tr>\n");
	}
	public void renderErrors(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, ParserConfigurationException, SAXException
	{
		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
		iResponse.setContentType("text/html");
		htmlWriter.write("<html>\n");
		htmlWriter.write("<head>\n");
		htmlWriter.write("<title>Bricks Errors</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		// no cache (for all browsers)
		htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
		htmlWriter.write("<link href='"+iRequest.getContextPath()+"/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
		htmlWriter.write("</head>\n");
		
		htmlWriter.write("<body class=Errors>\n");
		
		
		XmlEditor ctx = getEditor(iRequest);
		/*
		Element curElt = ctx.getEditingElement();
		Class eltClass = ctx.getMappedClass(curElt);
		XmlMappings mappings = XmlMappings.getMappings(eltClass, true);
		MappedField parentMapping = ctx.getEditingParentMapping();
		Locale locale = iRequest.getLocale();
		*/
		IXmlModelMessage[] messages = ctx.getAllMessages();
		htmlWriter.write("<table width='100%' class=Errors border=1 cellpadding=0 cellspacing=0>\n");
		htmlWriter.write("<tr>\n");
		// --- index
		htmlWriter.write("<th>\n");
		htmlWriter.write(getMessage(iRequest.getLocale(), "Errors.Index"));
		htmlWriter.write("</th>\n");
		// --- severity
		htmlWriter.write("<th>\n");
		htmlWriter.write(getMessage(iRequest.getLocale(), "Errors.Severity"));
		htmlWriter.write("</th>\n");
		// --- element
		htmlWriter.write("<th>\n");
		htmlWriter.write(getMessage(iRequest.getLocale(), "Errors.Element"));
		htmlWriter.write("</th>\n");
		// --- message
		htmlWriter.write("<th width='100%'>\n");
		htmlWriter.write(getMessage(iRequest.getLocale(), "Errors.Message"));
		htmlWriter.write("</th>\n");
		htmlWriter.write("</tr>\n");
		for(int i=0; i<messages.length; i++)
		{
			ObjInfo info = ((ModelMessageImpl)messages[i]).getInfo();
			htmlWriter.write("<tr>\n");
			// -- index
			htmlWriter.write("<td align=center valign=middle>");
			htmlWriter.write(String.valueOf(i));
			htmlWriter.write("</td>\n");

			// --- icon cell
			htmlWriter.write("<td align=center valign=middle>");
			htmlWriter.write("<img src='");
			switch(messages[i].getSeverity())
			{
			case IXmlModelMessage.INST_ERROR:
			case IXmlModelMessage.VALID_ERROR:
				htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Error.gif");
				break;
			case IXmlModelMessage.INST_WARNING:
			case IXmlModelMessage.VALID_WARNING:
				htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Warning.gif");
				break;
			default:
				htmlWriter.write(iRequest.getContextPath()+"/bricks_admin/icons/I_Msg_Info.gif");
				break;
			}
			htmlWriter.write("' title='");
			switch(messages[i].getSeverity())
			{
			case IXmlModelMessage.INST_ERROR:
			case IXmlModelMessage.VALID_ERROR:
				htmlWriter.write(getMessage(iRequest.getLocale(), "Errors.error"));
				break;
			case IXmlModelMessage.INST_WARNING:
			case IXmlModelMessage.VALID_WARNING:
				htmlWriter.write(getMessage(iRequest.getLocale(), "Errors.warning"));
				break;
			default:
				htmlWriter.write(getMessage(iRequest.getLocale(), "Errors.info"));
				break;
			}
			htmlWriter.write("'>");
			htmlWriter.write("</td>\n");
			
			// --- element cell
			htmlWriter.write("<td align=left valign=middle nowrap>");
			IXmlObject obj = messages[i].getObject();
			htmlWriter.write("<a target='"+MAIN_VIEW+"' href='"+iRequest.getRequestURI()+"?"+VIEW_PARAM+"="+MAIN_VIEW+"&"+CUR_ELEMENT_ID_PARAM+"="+info.getIdPath()+"'>" );
			htmlWriter.write(getNiceName(iRequest.getLocale(), info.getObject()));
			htmlWriter.write("</a>\n");
			htmlWriter.write("</td>\n");
			
			// --- message cell
			htmlWriter.write("<td align=left valign=middle>");
			htmlWriter.write(messages[i].getMessage());
			htmlWriter.write("</td>\n");
			
			htmlWriter.write("</tr>\n");
		}
		htmlWriter.write("</table>\n");
		htmlWriter.write("</body>\n");
		htmlWriter.write("</html>\n");
		htmlWriter.flush();
	}
	private void renderStackPage(HttpServletRequest iRequest, HttpServletResponse iResponse, Throwable iThrowable) throws IOException
	{
//		IHtmlWriter htmlWriter = new HtmlWriter(new OutputStreamWriter(iRequest.getOutputStream(), getCharSet()));
		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
		iResponse.setContentType("text/html");
		
		htmlWriter.write("<html>\n");
		htmlWriter.write("<head>\n");
		htmlWriter.write("<title>Error</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		// no cache (for all browsers)
		htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
		htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
		htmlWriter.write("</head>\n");
		htmlWriter.write("<body bgcolor='#FFFFFF' style='font-family: Verdana' text='#192c8f'>\n" );
		
		renderStack(iRequest, htmlWriter, iThrowable);
		
		htmlWriter.write("</body>\n");
		htmlWriter.write("</html>\n");
		htmlWriter.flush();
	}
	private void renderStack(HttpServletRequest iRequest, Writer writer, Throwable e) throws IOException
	{
		writer.write( "<h3 style='color: #990000;'>"+((e.getMessage()==null)?e.getClass().getName():e.getMessage())+"</h3>\n" );
		writer.write( "Exception type : "+e.getClass().getName()+"<BR>\n" );
		
		// --- dump stack
		StringWriter stackInString= new StringWriter();
		PrintWriter print= new PrintWriter(stackInString);
		e.printStackTrace( print );
		print.close();

		StringTokenizer tokens= new StringTokenizer( stackInString.toString(), "\n" );
		if( tokens.hasMoreElements() ) tokens.nextElement();
		while( tokens.hasMoreElements() )
		{
			String token= tokens.nextToken().trim();
			if( token.startsWith("at ") )
			{
				token= token.substring(3);
				writer.write( "Exception thrown in :<BR><A style='color: #990000;'>"+token+"</A>\n<P>" );
				break;
			}
		}
		tokens= new StringTokenizer( stackInString.toString(), "\n" );

		writer.write( "Stack trace :<BR><UL>\n" );
		if( tokens.hasMoreElements() ) tokens.nextElement();
		while( tokens.hasMoreElements() )
		{
			String token= tokens.nextToken().trim();
			if( token.startsWith("at ") )
				token= token.substring(3);
			else
				continue;
			if( token.indexOf("java.lang.reflect.Method.invoke")>=0 )
				break;
			if( token.indexOf("javax.servlet.http.HttpServlet.service")>=0 )
				break;
			writer.write( "<LI>"+token+"</LI>\n" );
		}
		writer.write( "</UL>\n");

		writer.write( "<A style='text-decoration: underline; cursor: pointer;' onClick=\"stack.style.display=stack.style.display == 'none' ? 'block' : 'none'\";'>Show Full Stack</A><BR>\n" );
		writer.write( "<PRE id=stack style='display: none;'>\n" );
		writer.write( stackInString.toString() );
		writer.write( "\n</PRE>\n" );
		writer.flush();
//		e.printStackTrace();
	}
	private static String escapeForMessageFormat(String pattern)
	{
		if(pattern == null || pattern.indexOf('\'') < 0)
			return pattern;
		int n = pattern.length();
		StringBuffer sb = new StringBuffer(n);
		for(int i = 0; i < n; i++)
		{
			char ch = pattern.charAt(i);
			if(ch == '\'')
				sb.append('\'');
			sb.append(ch);
		}

		return sb.toString();
	}
	// ==================================================================
	// === IValidationSupport implementation
	// ==================================================================
	public class J2EEValidator implements IValidationSupport
	{
		private ServletContext _ctx;
//		private Hashtable _lang2Locale = new Hashtable();
		
		public J2EEValidator(ServletContext context)
		{
			_ctx = context;
		}
		public ServletContext getServletContext()
		{
			return _ctx;
		}
		public boolean checkResource(String iResourcePath)
		{
			if(_ctx == null)
				return false;
			return _ctx.getResourceAsStream(iResourcePath) != null;
		}
	}
	
}
